/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.util;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.servux.Servux;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_5250;

public class i18nLang {
    private static final Gson GSON = new Gson();
    public static final String DEFAULT_LANG = "en_us";
    public static final String DEFAULT_PATH = "/assets/servux/lang/";
    private static volatile i18nLang instance = null;
    private final String languageCode;
    private final Map<String, String> map;

    public i18nLang(String languageCode, Map<String, String> map) {
        this.languageCode = languageCode;
        this.map = map;
    }

    public static i18nLang create(String languageCode, String path) throws IOException {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        BiConsumer<String, String> biConsumer = (arg_0, arg_1) -> ((ImmutableMap.Builder)builder).put(arg_0, arg_1);
        i18nLang.load(biConsumer, path);
        ImmutableMap map = builder.build();
        return new i18nLang(languageCode, (Map<String, String>)map);
    }

    public static i18nLang create(String languageCode) throws IOException {
        return i18nLang.create(languageCode, DEFAULT_PATH + languageCode + ".json");
    }

    public static void load(BiConsumer<String, String> entryConsumer, String path) throws IOException {
        InputStream inputStream;
        block7: {
            inputStream = i18nLang.class.getResourceAsStream(path);
            try {
                if (inputStream != null) {
                    JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), JsonObject.class);
                    for (Map.Entry entry : jsonObject.entrySet()) {
                        entryConsumer.accept((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                    }
                    break block7;
                }
                throw new IOException("Couldn't find the file: " + path);
            }
            catch (Throwable var6) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable var5) {
                        var6.addSuppressed(var5);
                    }
                }
                throw var6;
            }
        }
        inputStream.close();
    }

    public static i18nLang getInstance() {
        return instance;
    }

    public static void setInstance(i18nLang language) {
        instance = language;
    }

    public static boolean tryLoadLanguage(String langCode) {
        try {
            instance = i18nLang.create(langCode);
            return true;
        }
        catch (Exception e) {
            Servux.LOGGER.error("Failed to load language file for '{}'", (Object)langCode, (Object)e);
            return false;
        }
    }

    @Nullable
    public String get(String key) {
        return this.map.get(key);
    }

    public class_5250 translate(String key, Object ... args) {
        if (this.hasTranslation(key)) {
            return class_2561.method_48322((String)key, (String)this.get(key), (Object[])args);
        }
        return class_2561.method_43470((String)key).method_27694(style -> style.method_10977(class_124.field_1061).method_10949((class_2568)new class_2568.class_10613(class_2561.method_30163((String)("Missing translation: " + key)))));
    }

    public boolean hasTranslation(String key) {
        return this.map.containsKey(key);
    }

    static {
        i18nLang.tryLoadLanguage(DEFAULT_LANG);
    }
}

