/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.util;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.PrimitiveCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fi.dy.masa.servux.util.IntBoundingBox;
import fi.dy.masa.servux.util.JsonUtils;
import fi.dy.masa.servux.util.LayerMode;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_3532;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public class LayerRange {
    public static final Codec<LayerRange> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)LayerMode.CODEC.fieldOf("mode").forGetter(get -> get.layerMode), (App)class_2350.class_2351.field_25065.fieldOf("axis").forGetter(get -> get.axis), (App)PrimitiveCodec.INT.fieldOf("layer_single").forGetter(get -> get.layerSingle), (App)PrimitiveCodec.INT.fieldOf("layer_above").forGetter(get -> get.layerAbove), (App)PrimitiveCodec.INT.fieldOf("layer_below").forGetter(get -> get.layerBelow), (App)PrimitiveCodec.INT.fieldOf("layer_range_min").forGetter(get -> get.layerRangeMin), (App)PrimitiveCodec.INT.fieldOf("layer_range_max").forGetter(get -> get.layerRangeMax), (App)PrimitiveCodec.BOOL.fieldOf("hotkey_range_min").forGetter(get -> get.hotkeyRangeMin), (App)PrimitiveCodec.BOOL.fieldOf("hotkey_range_max").forGetter(get -> get.hotkeyRangeMax)).apply((Applicative)inst, LayerRange::new));
    public static final class_9139<ByteBuf, LayerRange> PACKET_CODEC = new class_9139<ByteBuf, LayerRange>(){

        public void encode(ByteBuf buf, LayerRange value) {
            LayerMode.PACKET_CODEC.encode((Object)buf, (Object)value.layerMode);
            class_9135.field_48554.encode((Object)buf, (Object)value.axis.method_15434());
            class_9135.field_49675.encode((Object)buf, (Object)value.layerSingle);
            class_9135.field_49675.encode((Object)buf, (Object)value.layerAbove);
            class_9135.field_49675.encode((Object)buf, (Object)value.layerBelow);
            class_9135.field_49675.encode((Object)buf, (Object)value.layerRangeMin);
            class_9135.field_49675.encode((Object)buf, (Object)value.layerRangeMax);
            class_9135.field_48547.encode((Object)buf, (Object)value.hotkeyRangeMin);
            class_9135.field_48547.encode((Object)buf, (Object)value.hotkeyRangeMax);
        }

        public LayerRange decode(ByteBuf buf) {
            return new LayerRange((LayerMode)((Object)LayerMode.PACKET_CODEC.decode((Object)buf)), class_2350.class_2351.method_10177((String)((String)class_9135.field_48554.decode((Object)buf))), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Integer)class_9135.field_49675.decode((Object)buf), (Boolean)class_9135.field_48547.decode((Object)buf), (Boolean)class_9135.field_48547.decode((Object)buf));
        }
    };
    protected LayerMode layerMode = LayerMode.ALL;
    protected class_2350.class_2351 axis = class_2350.class_2351.field_11052;
    protected int layerSingle = 0;
    protected int layerAbove = 0;
    protected int layerBelow = 0;
    protected int layerRangeMin = 0;
    protected int layerRangeMax = 0;
    protected boolean hotkeyRangeMin;
    protected boolean hotkeyRangeMax;

    private LayerRange() {
    }

    private LayerRange(LayerMode mode, class_2350.class_2351 axis, int single, int above, int below, int min, int max, boolean minRange, boolean maxRange) {
        this.layerMode = mode;
        this.axis = axis;
        this.layerSingle = single;
        this.layerAbove = above;
        this.layerBelow = below;
        this.layerRangeMin = min;
        this.layerRangeMax = max;
        this.hotkeyRangeMin = minRange;
        this.hotkeyRangeMax = maxRange;
    }

    public LayerMode getLayerMode() {
        return this.layerMode;
    }

    public class_2350.class_2351 getAxis() {
        return this.axis;
    }

    public boolean getMoveLayerRangeMin() {
        return this.hotkeyRangeMin;
    }

    public boolean getMoveLayerRangeMax() {
        return this.hotkeyRangeMax;
    }

    public void toggleHotkeyMoveRangeMin() {
        this.hotkeyRangeMin = !this.hotkeyRangeMin;
    }

    public void toggleHotkeyMoveRangeMax() {
        this.hotkeyRangeMax = !this.hotkeyRangeMax;
    }

    public int getLayerSingle() {
        return this.layerSingle;
    }

    public int getLayerAbove() {
        return this.layerAbove;
    }

    public int getLayerBelow() {
        return this.layerBelow;
    }

    public int getLayerRangeMin() {
        return this.layerRangeMin;
    }

    public int getLayerRangeMax() {
        return this.layerRangeMax;
    }

    public int getLayerMin() {
        switch (this.layerMode) {
            case ALL: 
            case ALL_BELOW: {
                return -30000000;
            }
            case SINGLE_LAYER: {
                return this.layerSingle;
            }
            case ALL_ABOVE: {
                return this.layerAbove;
            }
            case LAYER_RANGE: {
                return this.layerRangeMin;
            }
        }
        return 0;
    }

    public int getLayerMax() {
        switch (this.layerMode) {
            case ALL: 
            case ALL_ABOVE: {
                return 30000000;
            }
            case SINGLE_LAYER: {
                return this.layerSingle;
            }
            case ALL_BELOW: {
                return this.layerBelow;
            }
            case LAYER_RANGE: {
                return this.layerRangeMax;
            }
        }
        return 0;
    }

    public int getCurrentLayerValue(boolean isSecondValue) {
        switch (this.layerMode) {
            case SINGLE_LAYER: {
                return this.layerSingle;
            }
            case ALL_ABOVE: {
                return this.layerAbove;
            }
            case ALL_BELOW: {
                return this.layerBelow;
            }
            case LAYER_RANGE: {
                return isSecondValue ? this.layerRangeMax : this.layerRangeMin;
            }
        }
        return 0;
    }

    public void setLayerMode(LayerMode mode) {
        this.layerMode = mode;
    }

    public void setAxis(class_2350.class_2351 axis) {
        this.axis = axis;
    }

    public void setLayerSingle(int layer) {
        int old = this.layerSingle;
        if (layer != old) {
            this.layerSingle = layer;
        }
    }

    public void setLayerAbove(int layer) {
        int old = this.layerAbove;
        if (layer != old) {
            this.layerAbove = layer;
        }
    }

    public void setLayerBelow(int layer) {
        int old = this.layerBelow;
        if (layer != old) {
            this.layerBelow = layer;
        }
    }

    public boolean setLayerRangeMin(int layer) {
        return this.setLayerRangeMin(layer, false);
    }

    public boolean setLayerRangeMax(int layer) {
        return this.setLayerRangeMax(layer, false);
    }

    protected boolean setLayerRangeMin(int layer, boolean force) {
        int old = this.layerRangeMin;
        if (!force) {
            layer = Math.min(layer, this.layerRangeMax);
        }
        if (layer != old) {
            this.layerRangeMin = layer;
        }
        return layer != old;
    }

    protected int getPositionFromEntity(class_1297 entity) {
        switch (this.axis) {
            case field_11048: {
                return class_3532.method_15357((double)entity.method_23317());
            }
            case field_11052: {
                return class_3532.method_15357((double)entity.method_23318());
            }
            case field_11051: {
                return class_3532.method_15357((double)entity.method_23321());
            }
        }
        return 0;
    }

    protected boolean setLayerRangeMax(int layer, boolean force) {
        int old = this.layerRangeMax;
        if (!force) {
            layer = Math.max(layer, this.layerRangeMin);
        }
        if (layer != old) {
            this.layerRangeMax = layer;
        }
        return layer != old;
    }

    public void setSingleBoundaryToPosition(class_1297 entity) {
        int pos = this.getPositionFromEntity(entity);
        this.setSingleBoundaryToPosition(pos);
    }

    protected void setSingleBoundaryToPosition(int pos) {
        switch (this.layerMode) {
            case SINGLE_LAYER: {
                this.setLayerSingle(pos);
                break;
            }
            case ALL_ABOVE: {
                this.setLayerAbove(pos);
                break;
            }
            case ALL_BELOW: {
                this.setLayerBelow(pos);
                break;
            }
        }
    }

    public void setToPosition(class_1297 entity) {
        if (this.layerMode == LayerMode.LAYER_RANGE) {
            int pos = this.getPositionFromEntity(entity);
            this.setLayerRangeMin(pos, true);
            this.setLayerRangeMax(pos, true);
        } else {
            this.setSingleBoundaryToPosition(entity);
        }
    }

    protected void markAffectedLayersForRenderUpdate(IntBoundingBox limits) {
        switch (this.layerMode) {
            case ALL: {
                return;
            }
            case SINGLE_LAYER: {
                int val1 = this.layerSingle;
                int val2 = this.layerSingle;
                break;
            }
            case ALL_ABOVE: {
                int val1 = this.layerAbove;
                int val2 = limits.getMaxValueForAxis(this.axis);
                break;
            }
            case ALL_BELOW: {
                int val1 = limits.getMinValueForAxis(this.axis);
                int val2 = this.layerBelow;
                break;
            }
            case LAYER_RANGE: {
                int val1 = this.layerRangeMin;
                int val2 = this.layerRangeMax;
                break;
            }
            default: {
                return;
            }
        }
    }

    protected boolean getMoveMax(boolean minBoundaryClosest) {
        return this.hotkeyRangeMax || !minBoundaryClosest && !this.hotkeyRangeMin;
    }

    protected boolean getMoveMin(boolean minBoundaryClosest) {
        return this.hotkeyRangeMin || minBoundaryClosest && !this.hotkeyRangeMax;
    }

    protected boolean layerRangeIsMinClosest(class_1297 entity) {
        double playerPos = this.axis == class_2350.class_2351.field_11052 ? entity.method_23318() : (this.axis == class_2350.class_2351.field_11048 ? entity.method_23317() : entity.method_23321());
        double min = (double)this.layerRangeMin + 0.5;
        double max = (double)this.layerRangeMax + 0.5;
        return playerPos < min || Math.abs(playerPos - min) < Math.abs(playerPos - max);
    }

    public String getCurrentLayerString() {
        switch (this.layerMode) {
            case SINGLE_LAYER: {
                return String.valueOf(this.layerSingle);
            }
            case ALL_ABOVE: {
                return String.valueOf(this.layerAbove);
            }
            case ALL_BELOW: {
                return String.valueOf(this.layerBelow);
            }
            case LAYER_RANGE: {
                return String.format("%d ... %s", this.layerRangeMin, this.layerRangeMax);
            }
        }
        return "";
    }

    protected int getWorldLimitsClampedValue(int value, IntBoundingBox limits) {
        return class_3532.method_15340((int)value, (int)limits.getMinValueForAxis(this.axis), (int)limits.getMaxValueForAxis(this.axis));
    }

    public boolean isPositionWithinRange(class_2338 pos) {
        return this.isPositionWithinRange(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public boolean isPositionWithinRange(long posLong) {
        int x = class_2338.method_10061((long)posLong);
        int y = class_2338.method_10071((long)posLong);
        int z = class_2338.method_10083((long)posLong);
        return this.isPositionWithinRange(x, y, z);
    }

    public boolean isPositionWithinRange(int x, int y, int z) {
        switch (this.layerMode) {
            case ALL: {
                return true;
            }
            case SINGLE_LAYER: {
                return this.isPositionWithinSingleLayerRange(x, y, z);
            }
            case ALL_ABOVE: {
                return this.isPositionWithinAboveRange(x, y, z);
            }
            case ALL_BELOW: {
                return this.isPositionWithinBelowRange(x, y, z);
            }
            case LAYER_RANGE: {
                return this.isPositionWithinLayerRangeRange(x, y, z);
            }
        }
        return false;
    }

    protected boolean isPositionWithinSingleLayerRange(int x, int y, int z) {
        switch (this.axis) {
            case field_11048: {
                return x == this.layerSingle;
            }
            case field_11052: {
                return y == this.layerSingle;
            }
            case field_11051: {
                return z == this.layerSingle;
            }
        }
        return false;
    }

    protected boolean isPositionWithinAboveRange(int x, int y, int z) {
        switch (this.axis) {
            case field_11048: {
                return x >= this.layerAbove;
            }
            case field_11052: {
                return y >= this.layerAbove;
            }
            case field_11051: {
                return z >= this.layerAbove;
            }
        }
        return false;
    }

    protected boolean isPositionWithinBelowRange(int x, int y, int z) {
        switch (this.axis) {
            case field_11048: {
                return x <= this.layerBelow;
            }
            case field_11052: {
                return y <= this.layerBelow;
            }
            case field_11051: {
                return z <= this.layerBelow;
            }
        }
        return false;
    }

    protected boolean isPositionWithinLayerRangeRange(int x, int y, int z) {
        switch (this.axis) {
            case field_11048: {
                return x >= this.layerRangeMin && x <= this.layerRangeMax;
            }
            case field_11052: {
                return y >= this.layerRangeMin && y <= this.layerRangeMax;
            }
            case field_11051: {
                return z >= this.layerRangeMin && z <= this.layerRangeMax;
            }
        }
        return false;
    }

    public boolean isPositionAtRenderEdgeOnSide(class_2338 pos, class_2350 side) {
        switch (this.axis) {
            case field_11048: {
                return side == class_2350.field_11039 && pos.method_10263() == this.getLayerMin() || side == class_2350.field_11034 && pos.method_10263() == this.getLayerMax();
            }
            case field_11052: {
                return side == class_2350.field_11033 && pos.method_10264() == this.getLayerMin() || side == class_2350.field_11036 && pos.method_10264() == this.getLayerMax();
            }
            case field_11051: {
                return side == class_2350.field_11043 && pos.method_10260() == this.getLayerMin() || side == class_2350.field_11035 && pos.method_10260() == this.getLayerMax();
            }
        }
        return false;
    }

    public boolean intersects(IntBoundingBox box) {
        return this.intersectsBox(box.minX, box.minY, box.minZ, box.maxX, box.maxY, box.maxZ);
    }

    public boolean intersectsBox(class_2338 posMin, class_2338 posMax) {
        return this.intersectsBox(posMin.method_10263(), posMin.method_10264(), posMin.method_10260(), posMax.method_10263(), posMax.method_10264(), posMax.method_10260());
    }

    public boolean intersectsBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        switch (this.axis) {
            case field_11048: {
                return !(maxX < this.getLayerMin() || minX > this.getLayerMax());
            }
            case field_11052: {
                return !(maxY < this.getLayerMin() || minY > this.getLayerMax());
            }
            case field_11051: {
                return !(maxZ < this.getLayerMin() || minZ > this.getLayerMax());
            }
        }
        return false;
    }

    public int getClampedValue(int value, class_2350.class_2351 axis) {
        if (this.axis == axis) {
            return class_3532.method_15340((int)value, (int)this.getLayerMin(), (int)this.getLayerMax());
        }
        return value;
    }

    @Nullable
    public IntBoundingBox getClampedRenderBoundingBox(IntBoundingBox box) {
        if (!this.intersects(box)) {
            return null;
        }
        switch (this.axis) {
            case field_11048: {
                int xMin = Math.max(box.minX, this.getLayerMin());
                int xMax = Math.min(box.maxX, this.getLayerMax());
                return IntBoundingBox.createProper(xMin, box.minY, box.minZ, xMax, box.maxY, box.maxZ);
            }
            case field_11052: {
                int yMin = Math.max(box.minY, this.getLayerMin());
                int yMax = Math.min(box.maxY, this.getLayerMax());
                return IntBoundingBox.createProper(box.minX, yMin, box.minZ, box.maxX, yMax, box.maxZ);
            }
            case field_11051: {
                int zMin = Math.max(box.minZ, this.getLayerMin());
                int zMax = Math.min(box.maxZ, this.getLayerMax());
                return IntBoundingBox.createProper(box.minX, box.minY, zMin, box.maxX, box.maxY, zMax);
            }
        }
        return null;
    }

    public IntBoundingBox getExpandedBox(class_1937 world, int expandAmount) {
        int worldMinH = -30000000;
        int worldMaxH = 30000000;
        int worldMinY = world != null ? world.method_31607() : -64;
        int worldMaxY = world != null ? world.method_31600() : 319;
        int minX = worldMinH;
        int minY = worldMinY;
        int minZ = worldMinH;
        int maxX = worldMaxH;
        int maxY = worldMaxY;
        int maxZ = worldMaxH;
        switch (this.axis) {
            case field_11048: {
                minX = Math.max(minX, this.getLayerMin() - expandAmount);
                maxX = Math.min(maxX, this.getLayerMax() + expandAmount);
                break;
            }
            case field_11052: {
                minY = Math.max(minY, this.getLayerMin() - expandAmount);
                maxY = Math.min(maxY, this.getLayerMax() + expandAmount);
                break;
            }
            case field_11051: {
                minZ = Math.max(minZ, this.getLayerMin() - expandAmount);
                maxZ = Math.min(maxZ, this.getLayerMax() + expandAmount);
            }
        }
        return IntBoundingBox.createProper(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nullable
    public IntBoundingBox getClampedArea(class_2338 posMin, class_2338 posMax) {
        return this.getClampedArea(posMin.method_10263(), posMin.method_10264(), posMin.method_10260(), posMax.method_10263(), posMax.method_10264(), posMax.method_10260());
    }

    @Nullable
    public IntBoundingBox getClampedArea(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        if (!this.intersectsBox(minX, minY, minZ, maxX, maxY, maxZ)) {
            return null;
        }
        switch (this.axis) {
            case field_11048: {
                int xMin = Math.max(minX, this.getLayerMin());
                int xMax = Math.min(maxX, this.getLayerMax());
                return IntBoundingBox.createProper(xMin, minY, minZ, xMax, maxY, maxZ);
            }
            case field_11052: {
                int yMin = Math.max(minY, this.getLayerMin());
                int yMax = Math.min(maxY, this.getLayerMax());
                return IntBoundingBox.createProper(minX, yMin, minZ, maxX, yMax, maxZ);
            }
            case field_11051: {
                int zMin = Math.max(minZ, this.getLayerMin());
                int zMax = Math.min(maxZ, this.getLayerMax());
                return IntBoundingBox.createProper(minX, minY, zMin, maxX, maxY, zMax);
            }
        }
        return null;
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.add("mode", (JsonElement)new JsonPrimitive(this.layerMode.name()));
        obj.add("axis", (JsonElement)new JsonPrimitive(this.axis.name()));
        obj.add("layer_single", (JsonElement)new JsonPrimitive((Number)this.layerSingle));
        obj.add("layer_above", (JsonElement)new JsonPrimitive((Number)this.layerAbove));
        obj.add("layer_below", (JsonElement)new JsonPrimitive((Number)this.layerBelow));
        obj.add("layer_range_min", (JsonElement)new JsonPrimitive((Number)this.layerRangeMin));
        obj.add("layer_range_max", (JsonElement)new JsonPrimitive((Number)this.layerRangeMax));
        obj.add("hotkey_range_min", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.hotkeyRangeMin)));
        obj.add("hotkey_range_max", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.hotkeyRangeMax)));
        return obj;
    }

    public static LayerRange createFromJson(JsonObject obj) {
        LayerRange range = new LayerRange();
        range.fromJson(obj);
        return range;
    }

    public void fromJson(JsonObject obj) {
        this.layerMode = LayerMode.fromStringStatic(JsonUtils.getString(obj, "mode"));
        this.axis = class_2350.class_2351.method_10177((String)JsonUtils.getString(obj, "axis"));
        if (this.axis == null) {
            this.axis = class_2350.class_2351.field_11052;
        }
        this.layerSingle = JsonUtils.getInteger(obj, "layer_single");
        this.layerAbove = JsonUtils.getInteger(obj, "layer_above");
        this.layerBelow = JsonUtils.getInteger(obj, "layer_below");
        this.layerRangeMin = JsonUtils.getInteger(obj, "layer_range_min");
        this.layerRangeMax = JsonUtils.getInteger(obj, "layer_range_max");
        this.hotkeyRangeMin = JsonUtils.getBoolean(obj, "hotkey_range_min");
        this.hotkeyRangeMax = JsonUtils.getBoolean(obj, "hotkey_range_max");
    }
}

