/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.schematic.placement;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.servux.Servux;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;

public class SubRegionPlacement {
    private final String name;
    private final class_2338 defaultPos;
    private class_2338 pos;
    public class_2470 rotation = class_2470.field_11467;
    public class_2415 mirror = class_2415.field_11302;
    public boolean enabled = true;
    public boolean ignoreEntities;

    public SubRegionPlacement(class_2338 pos, String name) {
        this.pos = pos;
        this.defaultPos = pos;
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean ignoreEntities() {
        return this.ignoreEntities;
    }

    public boolean matchesRequirement(RequiredEnabled required) {
        if (required == RequiredEnabled.ANY) {
            return true;
        }
        if (required == RequiredEnabled.PLACEMENT_ENABLED) {
            return this.isEnabled();
        }
        Servux.LOGGER.warn("RequiredEnabled.RENDERING_ENABLED is not supported on server side!");
        return false;
    }

    public String getName() {
        return this.name;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public class_2470 getRotation() {
        return this.rotation;
    }

    public class_2415 getMirror() {
        return this.mirror;
    }

    void toggleIgnoreEntities() {
        this.ignoreEntities = !this.ignoreEntities;
    }

    void setPos(class_2338 pos) {
        this.pos = pos;
    }

    void setRotation(class_2470 rotation) {
        this.rotation = rotation;
    }

    void setMirror(class_2415 mirror) {
        this.mirror = mirror;
    }

    void resetToOriginalValues() {
        this.pos = this.defaultPos;
        this.rotation = class_2470.field_11467;
        this.mirror = class_2415.field_11302;
        this.enabled = true;
        this.ignoreEntities = false;
    }

    public boolean isRegionPlacementModifiedFromDefault() {
        return this.isRegionPlacementModified(this.defaultPos);
    }

    public boolean isRegionPlacementModified(class_2338 originalPosition) {
        return !this.isEnabled() || this.ignoreEntities() || this.getMirror() != class_2415.field_11302 || this.getRotation() != class_2470.field_11467 || !this.getPos().equals((Object)originalPosition);
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        JsonArray arr = new JsonArray();
        arr.add((Number)this.pos.method_10263());
        arr.add((Number)this.pos.method_10264());
        arr.add((Number)this.pos.method_10260());
        obj.add("pos", (JsonElement)arr);
        obj.add("name", (JsonElement)new JsonPrimitive(this.getName()));
        obj.add("rotation", (JsonElement)new JsonPrimitive(this.rotation.name()));
        obj.add("mirror", (JsonElement)new JsonPrimitive(this.mirror.name()));
        obj.add("locked_coords", (JsonElement)new JsonPrimitive((Number)0));
        obj.add("enabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.enabled)));
        obj.add("rendering_enabled", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        obj.add("ignore_entities", (JsonElement)new JsonPrimitive(Boolean.valueOf(this.ignoreEntities)));
        return obj;
    }

    public static enum RequiredEnabled {
        ANY,
        PLACEMENT_ENABLED,
        RENDERING_ENABLED;

    }
}

