/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.network.packet;

import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.EntitiesDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.IServerPayloadData;
import fi.dy.masa.servux.network.PacketSplitter;
import fi.dy.masa.servux.network.packet.ServuxEntitiesPacket;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_8710;

@Environment(value=EnvType.SERVER)
public abstract class ServuxEntitiesHandler<T extends class_8710>
implements IPluginServerPlayHandler<T> {
    private static final ServuxEntitiesHandler<ServuxEntitiesPacket.Payload> INSTANCE = new ServuxEntitiesHandler<ServuxEntitiesPacket.Payload>(){

        public void receive(ServuxEntitiesPacket.Payload payload, ServerPlayNetworking.Context context) {
            INSTANCE.receivePlayPayload(payload, context);
        }
    };
    public static final class_2960 CHANNEL_ID = class_2960.method_60655((String)"servux", (String)"entity_data");
    private boolean payloadRegistered = false;
    private final Map<UUID, Integer> failures = new HashMap<UUID, Integer>();
    private static final int MAX_FAILURES = 4;
    private final Map<UUID, Long> readingSessionKeys = new HashMap<UUID, Long>();

    public static ServuxEntitiesHandler<ServuxEntitiesPacket.Payload> getInstance() {
        return INSTANCE;
    }

    @Override
    public class_2960 getPayloadChannel() {
        return CHANNEL_ID;
    }

    @Override
    public boolean isPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            return this.payloadRegistered;
        }
        return false;
    }

    @Override
    public void setPlayRegistered(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.payloadRegistered = true;
        }
    }

    @Override
    public <P extends IServerPayloadData> void decodeServerData(class_2960 channel, class_3222 player, P data) {
        ServuxEntitiesPacket packet = (ServuxEntitiesPacket)data;
        if (!channel.equals((Object)CHANNEL_ID)) {
            return;
        }
        switch (packet.getType()) {
            case PACKET_C2S_METADATA_REQUEST: {
                EntitiesDataProvider.INSTANCE.sendMetadata(player);
                break;
            }
            case PACKET_C2S_BLOCK_ENTITY_REQUEST: {
                EntitiesDataProvider.INSTANCE.onBlockEntityRequest(player, packet.getPos());
                break;
            }
            case PACKET_C2S_ENTITY_REQUEST: {
                EntitiesDataProvider.INSTANCE.onEntityRequest(player, packet.getEntityId());
                break;
            }
            default: {
                Servux.LOGGER.warn("ServuxEntitiesHandler#decodeServerData(): Invalid packetType '{}' from player: {}, of size in bytes: {}.", (Object)packet.getPacketType(), (Object)player.method_5477().method_54160(), (Object)packet.getTotalSize());
            }
        }
    }

    @Override
    public void reset(class_2960 channel) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.failures.clear();
        }
    }

    public void resetFailures(class_2960 channel, class_3222 player) {
        if (channel.equals((Object)CHANNEL_ID)) {
            this.failures.remove(player.method_5667());
        }
    }

    @Override
    public void receivePlayPayload(T payload, ServerPlayNetworking.Context ctx) {
        if (payload.method_56479().comp_2242().equals((Object)CHANNEL_ID)) {
            class_3222 player = ctx.player();
            INSTANCE.decodeServerData(CHANNEL_ID, player, ((ServuxEntitiesPacket.Payload)payload).data());
        }
    }

    @Override
    public void encodeWithSplitter(class_3222 player, class_2540 buffer, class_3244 networkHandler) {
        INSTANCE.sendPlayPayload(player, new ServuxEntitiesPacket.Payload(ServuxEntitiesPacket.ResponseS2CData(buffer)));
    }

    @Override
    public <P extends IServerPayloadData> void encodeServerData(class_3222 player, P data) {
        if (!EntitiesDataProvider.INSTANCE.isEnabled()) {
            return;
        }
        ServuxEntitiesPacket packet = (ServuxEntitiesPacket)data;
        if (packet.getType().equals((Object)ServuxEntitiesPacket.Type.PACKET_S2C_NBT_RESPONSE_START)) {
            class_2540 buffer = new class_2540(Unpooled.buffer());
            buffer.method_10804(packet.getTransactionId());
            buffer.method_10794((class_2520)packet.getCompound());
            PacketSplitter.send(this, buffer, player, player.field_13987);
        } else if (!INSTANCE.sendPlayPayload(player, new ServuxEntitiesPacket.Payload(packet))) {
            UUID id = player.method_5667();
            if (!this.failures.containsKey(id)) {
                this.failures.put(id, 1);
            } else if (this.failures.get(id) > 4) {
                EntitiesDataProvider.INSTANCE.onPacketFailure(player);
            } else {
                int count = this.failures.get(id) + 1;
                this.failures.put(id, count);
            }
        }
    }
}

