/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxTweaksHandler;
import fi.dy.masa.servux.network.packet.ServuxTweaksPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

public class TweaksDataProvider
extends DataProviderBase {
    public static final TweaksDataProvider INSTANCE = new TweaksDataProvider();
    protected static final ServuxTweaksHandler<ServuxTweaksPacket.Payload> HANDLER = ServuxTweaksHandler.getInstance();
    protected final class_2487 metadata = new class_2487();
    protected ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    protected List<IServuxSetting<?>> settings = List.of(this.permissionLevel);
    private final List<UUID> invalidPlayers = new ArrayList<UUID>();

    protected TweaksDataProvider() {
        super("tweaks_data", ServuxTweaksHandler.CHANNEL_ID, 1, 0, "servux.provider.tweaks_data", "Tweaks Data provider for Client Side mods.");
        this.metadata.method_10582("name", this.getName());
        this.metadata.method_10582("id", this.getNetworkChannel().toString());
        this.metadata.method_10569("version", this.getProtocolVersion());
        this.metadata.method_10582("servux", Reference.MOD_STRING);
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxTweaksPacket.Payload.ID, ServuxTweaksPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxTweaksPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxTweaksPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(class_3222 player) {
        return !this.isPlayerInvalid(player);
    }

    public void sendMetadata(class_3222 player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player)) {
            Servux.debugLog("tweaks_service: Denying access for player {}, Insufficient Permissions", player.method_5477().method_54160());
            return;
        }
        Servux.debugLog("tweaksDataChannel: sendMetadata to player {}", player.method_5477().method_54160());
        if (player.field_13987 != null) {
            HANDLER.sendPlayPayload(player.field_13987, new ServuxTweaksPacket.Payload(ServuxTweaksPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxTweaksPacket.Payload(ServuxTweaksPacket.MetadataResponse(this.metadata)));
        }
    }

    public void onPacketFailure(class_3222 player) {
        this.setPlayerInvalid(player);
    }

    public void removePlayer(class_3222 player) {
        this.removeInvalidPlayer(player);
    }

    private void setPlayerInvalid(class_3222 player) {
        if (!this.invalidPlayers.contains(player.method_5667())) {
            this.invalidPlayers.add(player.method_5667());
        }
    }

    private boolean isPlayerInvalid(class_3222 player) {
        return this.invalidPlayers.contains(player.method_5667());
    }

    private void removeInvalidPlayer(class_3222 player) {
        this.invalidPlayers.remove(player.method_5667());
    }

    public void onBlockEntityRequest(class_3222 player, class_2338 pos) {
        if (!this.hasPermission(player) || !this.isEnabled()) {
            return;
        }
        class_2586 be = player.method_5770().method_8321(pos);
        class_2487 nbt = be != null ? be.method_38244((class_7225.class_7874)player.method_56673()) : new class_2487();
        HANDLER.encodeServerData(player, ServuxTweaksPacket.SimpleBlockResponse(pos, nbt));
    }

    public void onEntityRequest(class_3222 player, int entityId) {
        if (!this.hasPermission(player)) {
            return;
        }
        class_1297 entity = player.method_37908().method_8469(entityId);
        class_2487 nbt = new class_2487();
        if (entity != null) {
            if (entity instanceof class_1657) {
                class_2960 id = class_1299.method_5890((class_1299)entity.method_5864());
                nbt = entity.method_5647(nbt);
                if (id != null) {
                    nbt.method_10582("id", id.toString());
                }
                HANDLER.encodeServerData(player, ServuxTweaksPacket.SimpleEntityResponse(entityId, nbt));
            } else if (entity.method_5786(nbt)) {
                HANDLER.encodeServerData(player, ServuxTweaksPacket.SimpleEntityResponse(entityId, nbt));
            }
        }
    }

    @Override
    public boolean hasPermission(class_3222 player) {
        return Permissions.check((class_1297)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }
}

