/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.DataProviderBase;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.network.IPluginServerPlayHandler;
import fi.dy.masa.servux.network.ServerPlayHandler;
import fi.dy.masa.servux.network.packet.ServuxHudHandler;
import fi.dy.masa.servux.network.packet.ServuxHudPacket;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.settings.ServuxBoolSetting;
import fi.dy.masa.servux.settings.ServuxIntSetting;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1860;
import net.minecraft.class_1928;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3695;
import net.minecraft.server.MinecraftServer;

public class HudDataProvider
extends DataProviderBase {
    public static final HudDataProvider INSTANCE = new HudDataProvider();
    protected static final ServuxHudHandler<ServuxHudPacket.Payload> HANDLER = ServuxHudHandler.getInstance();
    protected final class_2487 metadata = new class_2487();
    protected ServuxIntSetting permissionLevel = new ServuxIntSetting((IDataProvider)this, "permission_level", 0, 4, 0);
    protected ServuxIntSetting updateInterval = new ServuxIntSetting((IDataProvider)this, "update_interval", 80, 1200, 20);
    protected ServuxBoolSetting shareWeatherStatus = new ServuxBoolSetting(this, "share_weather_status", false);
    protected ServuxIntSetting weatherPermissionLevel = new ServuxIntSetting((IDataProvider)this, "weather_permission_level", 0, 4, 0);
    protected ServuxBoolSetting shareSeed = new ServuxBoolSetting(this, "share_seed", false);
    protected ServuxIntSetting seedPermissionLevel = new ServuxIntSetting((IDataProvider)this, "seed_permission_level", 2, 4, 0);
    protected List<IServuxSetting<?>> settings = List.of(this.permissionLevel, this.updateInterval, this.shareWeatherStatus, this.weatherPermissionLevel, this.shareSeed, this.seedPermissionLevel);
    private class_2338 spawnPos = class_2338.field_10980;
    private int spawnChunkRadius = -1;
    private long worldSeed = 0L;
    private int clearWeatherTime = -1;
    private int rainWeatherTime = -1;
    private int thunderWeatherTime = -1;
    private boolean isRaining;
    private boolean isThundering;
    private long lastTick;
    private long lastWeatherTick;
    private boolean refreshSpawnMetadata;
    private boolean refreshWeatherData;
    private final List<UUID> invalidPlayers = new ArrayList<UUID>();

    protected HudDataProvider() {
        super("hud_data", ServuxHudHandler.CHANNEL_ID, 1, 0, "servux.provider.hud_data", "MiniHUD Meta Data provider for various Server-Side information");
        this.metadata.method_10582("name", this.getName());
        this.metadata.method_10582("id", this.getNetworkChannel().toString());
        this.metadata.method_10569("version", this.getProtocolVersion());
        this.metadata.method_10582("servux", Reference.MOD_STRING);
        this.metadata.method_10569("spawnPosX", this.getSpawnPos().method_10263());
        this.metadata.method_10569("spawnPosY", this.getSpawnPos().method_10264());
        this.metadata.method_10569("spawnPosZ", this.getSpawnPos().method_10260());
        this.metadata.method_10569("spawnChunkRadius", this.getSpawnChunkRadius());
    }

    @Override
    public List<IServuxSetting<?>> getSettings() {
        return this.settings;
    }

    @Override
    public void registerHandler() {
        ServerPlayHandler.getInstance().registerServerPlayHandler(HANDLER);
        if (!this.isRegistered()) {
            HANDLER.registerPlayPayload(ServuxHudPacket.Payload.ID, ServuxHudPacket.Payload.CODEC, 3);
            this.setRegistered(true);
        }
        HANDLER.registerPlayReceiver(ServuxHudPacket.Payload.ID, (ServerPlayNetworking.PlayPayloadHandler<ServuxHudPacket.Payload>)((ServerPlayNetworking.PlayPayloadHandler)HANDLER::receivePlayPayload));
    }

    @Override
    public void unregisterHandler() {
        HANDLER.unregisterPlayReceiver();
        ServerPlayHandler.getInstance().unregisterServerPlayHandler(HANDLER);
    }

    @Override
    public IPluginServerPlayHandler<?> getPacketHandler() {
        return HANDLER;
    }

    @Override
    public boolean isPlayerRegistered(class_3222 player) {
        return !this.isPlayerInvalid(player);
    }

    @Override
    public boolean shouldTick() {
        return this.enabled;
    }

    @Override
    public void tick(MinecraftServer server, int tickCounter, class_3695 profiler) {
        if (!this.isEnabled()) {
            return;
        }
        if (tickCounter % (Integer)this.updateInterval.getValue() == 0) {
            profiler.method_15396(this.getName());
            List playerList = server.method_3760().method_14571();
            this.lastTick = tickCounter;
            int radius = this.getSpawnChunkRadius();
            int rule = server.method_3767().method_8356(class_1928.field_48374);
            if (radius != rule) {
                this.setSpawnChunkRadius(rule);
            }
            if (this.worldSeed == 0L) {
                this.checkWorldSeed(server);
            } else if (!((Boolean)this.shareSeed.getValue()).booleanValue()) {
                this.setWorldSeed(0L);
            }
            profiler.method_15405(this.getName() + "_players");
            for (class_3222 player : playerList) {
                if (this.isPlayerInvalid(player)) continue;
                if (this.shouldRefreshWeatherData()) {
                    this.refreshWeatherData(player, null);
                }
                if (!this.shouldRefreshSpawnMetadata()) continue;
                this.refreshSpawnMetadata(player, null);
            }
            if (this.shouldRefreshWeatherData()) {
                this.lastWeatherTick = tickCounter;
                this.setRefreshWeatherDataComplete();
            }
            if (this.shouldRefreshSpawnMetadata()) {
                this.setRefreshSpawnMetadataComplete();
            }
            profiler.method_15407();
        }
    }

    private void setPlayerInvalid(class_3222 player) {
        if (!this.invalidPlayers.contains(player.method_5667())) {
            this.invalidPlayers.add(player.method_5667());
        }
    }

    private boolean isPlayerInvalid(class_3222 player) {
        return this.invalidPlayers.contains(player.method_5667());
    }

    private void removeInvalidPlayer(class_3222 player) {
        this.invalidPlayers.remove(player.method_5667());
    }

    public void tickWeather(int clearTime, int rainTime, int thunderTime, boolean isRaining, boolean isThunder) {
        if (!this.isEnabled()) {
            return;
        }
        this.clearWeatherTime = clearTime;
        this.rainWeatherTime = rainTime;
        this.thunderWeatherTime = thunderTime;
        this.isRaining = isRaining;
        this.isThundering = isThunder;
        if (this.lastTick - this.lastWeatherTick > (long)this.getTickInterval()) {
            this.refreshWeatherData = true;
        }
    }

    public void sendMetadata(class_3222 player) {
        if (!this.isEnabled()) {
            return;
        }
        if (!this.hasPermission(player)) {
            Servux.debugLog("hud_service: Denying access for player {}, Insufficient Permissions", player.method_5477().method_54160());
            return;
        }
        this.removeInvalidPlayer(player);
        class_2487 nbt = new class_2487();
        nbt.method_10543(this.metadata);
        if (!this.hasPermissionsForSeed(player) && nbt.method_10545("worldSeed")) {
            nbt.method_10551("worldSeed");
        }
        Servux.debugLog("hudDataChannel: sendMetadata to player {}", player.method_5477().method_54160());
        if (player.field_13987 != null) {
            HANDLER.sendPlayPayload(player.field_13987, new ServuxHudPacket.Payload(ServuxHudPacket.MetadataResponse(this.metadata)));
        } else {
            HANDLER.sendPlayPayload(player, new ServuxHudPacket.Payload(ServuxHudPacket.MetadataResponse(this.metadata)));
        }
    }

    public void onPacketFailure(class_3222 player) {
        this.setPlayerInvalid(player);
    }

    public void removePlayer(class_3222 player) {
        this.removeInvalidPlayer(player);
    }

    public void refreshSpawnMetadata(class_3222 player, @Nullable class_2487 data) {
        if (!this.isEnabled()) {
            return;
        }
        class_2487 nbt = new class_2487();
        class_2338 spawnPos = INSTANCE.getSpawnPos();
        nbt.method_10582("id", this.getNetworkChannel().toString());
        nbt.method_10582("servux", Reference.MOD_STRING);
        nbt.method_10569("spawnPosX", spawnPos.method_10263());
        nbt.method_10569("spawnPosY", spawnPos.method_10264());
        nbt.method_10569("spawnPosZ", spawnPos.method_10260());
        nbt.method_10569("spawnChunkRadius", INSTANCE.getSpawnChunkRadius());
        if (((Boolean)this.shareSeed.getValue()).booleanValue() && this.hasPermissionsForSeed(player)) {
            Servux.debugLog("refreshSpawnMetadata() player [{}] has seedPermissions.", player.method_5477().method_54160());
            nbt.method_10544("worldSeed", this.worldSeed);
        } else {
            Servux.debugLog("refreshSpawnMetadata() player [{}] does not have seedPermissions.", player.method_5477().method_54160());
        }
        HANDLER.encodeServerData(player, ServuxHudPacket.SpawnResponse(nbt));
    }

    public void refreshWeatherData(class_3222 player, @Nullable class_2487 data) {
        class_2487 nbt = new class_2487();
        if (!this.hasPermissionsForWeather(player) || !this.isEnabled()) {
            return;
        }
        nbt.method_10582("id", this.getNetworkChannel().toString());
        nbt.method_10582("servux", Reference.MOD_STRING);
        if (this.isRaining && this.rainWeatherTime > -1) {
            nbt.method_10569("SetRaining", this.rainWeatherTime);
            nbt.method_10556("isRaining", true);
        } else {
            nbt.method_10556("isRaining", false);
        }
        if (this.isThundering && this.thunderWeatherTime > -1) {
            nbt.method_10569("SetThundering", this.thunderWeatherTime);
            nbt.method_10556("isThundering", true);
        } else {
            nbt.method_10556("isThundering", false);
        }
        if (this.clearWeatherTime > -1) {
            nbt.method_10569("SetClear", this.clearWeatherTime);
        }
        HANDLER.encodeServerData(player, ServuxHudPacket.WeatherTick(nbt));
    }

    public void refreshRecipeManager(class_3222 player, @Nullable class_2487 data) {
        if (!this.hasPermission(player)) {
            return;
        }
        class_3218 world = player.method_51469();
        Collection recipes = world.method_64577().method_8126();
        class_2487 nbt = new class_2487();
        class_2499 list = new class_2499();
        if (data != null) {
            Servux.debugLog("hudDataChannel: received RecipeManager request from {}, client version: {}", player.method_5477().method_54160(), data.method_68564("version", "?"));
        }
        recipes.forEach(recipeEntry -> {
            DataResult dr = class_1860.field_47319.encodeStart((DynamicOps)class_2509.field_11560, (Object)recipeEntry.comp_1933());
            if (dr.result().isPresent()) {
                class_2487 entry = new class_2487();
                entry.method_10582("id_reg", recipeEntry.comp_1932().method_41185().toString());
                entry.method_10582("id_value", recipeEntry.comp_1932().method_29177().toString());
                entry.method_10566("recipe", (class_2520)dr.result().get());
                list.add((Object)entry);
            }
        });
        nbt.method_10566("RecipeManager", (class_2520)list);
        HANDLER.encodeServerData(player, ServuxHudPacket.ResponseS2CStart(nbt));
    }

    public class_2338 getSpawnPos() {
        if (this.spawnPos == null) {
            this.setSpawnPos(class_2338.field_10980);
        }
        return this.spawnPos;
    }

    public void setSpawnPos(class_2338 spawnPos) {
        if (!this.spawnPos.equals((Object)spawnPos)) {
            this.metadata.method_10551("spawnPosX");
            this.metadata.method_10551("spawnPosY");
            this.metadata.method_10551("spawnPosZ");
            this.metadata.method_10569("spawnPosX", spawnPos.method_10263());
            this.metadata.method_10569("spawnPosY", spawnPos.method_10264());
            this.metadata.method_10569("spawnPosZ", spawnPos.method_10260());
            this.refreshSpawnMetadata = true;
            Servux.debugLog("setSpawnPos(): updating World Spawn [{}] -> [{}]", this.spawnPos.method_23854(), spawnPos.method_23854());
        }
        this.spawnPos = spawnPos;
    }

    public int getSpawnChunkRadius() {
        if (this.spawnChunkRadius < 0) {
            this.spawnChunkRadius = 2;
        }
        return this.spawnChunkRadius;
    }

    public void setSpawnChunkRadius(int radius) {
        if (this.spawnChunkRadius != radius) {
            this.metadata.method_10551("spawnChunkRadius");
            this.metadata.method_10569("spawnChunkRadius", radius);
            this.refreshSpawnMetadata = true;
            Servux.debugLog("setSpawnPos(): updating Spawn Chunk Radius [{}] -> [{}]", this.spawnChunkRadius, radius);
        }
        this.spawnChunkRadius = radius;
    }

    public boolean shouldRefreshSpawnMetadata() {
        return this.refreshSpawnMetadata;
    }

    public void setRefreshSpawnMetadataComplete() {
        this.refreshSpawnMetadata = false;
        Servux.debugLog("setRefreshSpawnMetadataComplete()", new Object[0]);
    }

    public boolean shouldRefreshWeatherData() {
        return this.refreshWeatherData;
    }

    public void setRefreshWeatherDataComplete() {
        this.refreshWeatherData = false;
    }

    public long getWorldSeed() {
        return this.worldSeed;
    }

    public void setWorldSeed(long seed) {
        if (this.worldSeed != seed) {
            if (((Boolean)this.shareSeed.getValue()).booleanValue()) {
                this.metadata.method_10551("worldSeed");
                this.metadata.method_10544("worldSeed", seed);
                this.refreshSpawnMetadata = true;
            }
            Servux.debugLog("setWorldSeed(): updating World Seed [{}] -> [{}]", this.worldSeed, seed);
        }
        this.worldSeed = seed;
    }

    public void checkWorldSeed(MinecraftServer server) {
        class_3218 world;
        if (((Boolean)this.shareSeed.getValue()).booleanValue() && (world = server.method_30002()) != null) {
            this.setWorldSeed(world.method_8412());
        }
    }

    public boolean hasPermissionsForWeather(class_3222 player) {
        return Permissions.check((class_1297)player, (String)(this.permNode + ".weather"), (int)((Integer)this.weatherPermissionLevel.getValue()));
    }

    public boolean hasPermissionsForSeed(class_3222 player) {
        return Permissions.check((class_1297)player, (String)(this.permNode + ".seed"), (int)((Integer)this.seedPermissionLevel.getValue()));
    }

    @Override
    public boolean hasPermission(class_3222 player) {
        return Permissions.check((class_1297)player, (String)this.permNode, (int)((Integer)this.permissionLevel.getValue()));
    }

    @Override
    public void onTickEndPre() {
    }

    @Override
    public void onTickEndPost() {
    }
}

