/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.servux.dataproviders;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import fi.dy.masa.servux.Reference;
import fi.dy.masa.servux.Servux;
import fi.dy.masa.servux.dataproviders.IDataProvider;
import fi.dy.masa.servux.settings.IServuxSetting;
import fi.dy.masa.servux.util.JsonUtils;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_3695;
import net.minecraft.class_5455;
import net.minecraft.server.MinecraftServer;

public class DataProviderManager {
    public static final DataProviderManager INSTANCE = new DataProviderManager();
    protected final HashMap<String, IDataProvider> providers = new HashMap();
    protected ImmutableList<IDataProvider> providersImmutable = ImmutableList.of();
    protected ArrayList<IDataProvider> providersTicking = new ArrayList();
    protected Path configDir = null;
    protected class_5455.class_6890 immutable = class_5455.field_40585;

    public ImmutableList<IDataProvider> getAllProviders() {
        return this.providersImmutable;
    }

    public boolean registerDataProvider(IDataProvider provider) {
        String name = provider.getName().toLowerCase();
        if (!this.providers.containsKey(name)) {
            this.providers.put(name, provider);
            this.providersImmutable = ImmutableList.copyOf(this.providers.values());
            return true;
        }
        return false;
    }

    public boolean setProviderEnabled(String providerName, boolean enabled) {
        IDataProvider provider = this.providers.get(providerName);
        return provider != null && this.setProviderEnabled(provider, enabled);
    }

    public boolean setProviderEnabled(IDataProvider provider, boolean enabled) {
        boolean wasEnabled = provider.isEnabled();
        if (enabled || wasEnabled != enabled) {
            provider.setEnabled(enabled);
            this.updatePacketHandlerRegistration(provider);
            if (enabled && provider.shouldTick() && !this.providersTicking.contains(provider)) {
                this.providersTicking.add(provider);
            } else {
                this.providersTicking.remove(provider);
            }
            return true;
        }
        return false;
    }

    public void tickProviders(MinecraftServer server, int tickCounter, class_3695 profiler) {
        if (!this.providersTicking.isEmpty()) {
            for (IDataProvider provider : this.providersTicking) {
                if (tickCounter % provider.getTickInterval() != 0) continue;
                provider.tick(server, tickCounter, profiler);
            }
        }
    }

    protected void registerEnabledPacketHandlers() {
        for (IDataProvider provider : this.providersImmutable) {
            this.updatePacketHandlerRegistration(provider);
        }
    }

    protected void updatePacketHandlerRegistration(IDataProvider provider) {
        if (provider.isEnabled()) {
            provider.registerHandler();
        } else {
            provider.unregisterHandler();
        }
    }

    public void onCaptureImmutable(@Nonnull class_5455.class_6890 immutable) {
        this.immutable = immutable;
    }

    public class_5455.class_6890 getRegistryManager() {
        return this.immutable;
    }

    public void onServerTickEndPre() {
        for (IDataProvider provider : this.providersImmutable) {
            provider.onTickEndPre();
        }
    }

    public void onServerTickEndPost() {
        for (IDataProvider provider : this.providersImmutable) {
            provider.onTickEndPost();
        }
    }

    public Optional<IDataProvider> getProviderByName(String providerName) {
        return Optional.ofNullable(this.providers.get(providerName));
    }

    @Nullable
    public IServuxSetting<?> getSettingByName(String name) {
        block4: {
            block3: {
                if (!name.contains(":")) break block3;
                String[] parts = name.split(":");
                String providerName = parts[0];
                String settingName = parts[1];
                IDataProvider provider = this.providers.get(providerName);
                if (provider == null) break block4;
                for (IServuxSetting<?> setting : provider.getSettings()) {
                    if (!setting.name().equalsIgnoreCase(settingName)) continue;
                    return setting;
                }
                break block4;
            }
            for (IDataProvider provider : this.providersImmutable) {
                for (IServuxSetting<?> setting : provider.getSettings()) {
                    if (!setting.name().equalsIgnoreCase(name)) continue;
                    return setting;
                }
            }
        }
        return null;
    }

    public void readFromConfig() {
        JsonElement el = JsonUtils.parseJsonFileAsPath(this.getConfigFile());
        JsonObject obj = null;
        Servux.debugLog("DataProviderManager#readFromConfig()", new Object[0]);
        if (el != null && el.isJsonObject()) {
            JsonObject root = el.getAsJsonObject();
            if (JsonUtils.hasObject(root, "DataProviderToggles")) {
                obj = JsonUtils.getNestedObject(root, "DataProviderToggles", false);
            }
            for (IDataProvider provider : this.providersImmutable) {
                String name = provider.getName();
                if (!JsonUtils.hasObject(root, name)) continue;
                provider.fromJson(JsonUtils.getNestedObject(root, name, false));
            }
            for (IDataProvider provider : this.providersImmutable) {
                if (obj != null) {
                    this.setProviderEnabled(provider, JsonUtils.getBooleanOrDefault(obj, provider.getName(), false));
                } else {
                    this.setProviderEnabled(provider, false);
                }
                if (!provider.getName().equals("servux_main") || provider.isEnabled()) continue;
                this.setProviderEnabled(provider, true);
            }
        } else {
            UnmodifiableIterator unmodifiableIterator = this.providersImmutable.iterator();
            while (unmodifiableIterator.hasNext()) {
                IDataProvider provider;
                this.setProviderEnabled(provider, !(provider = (IDataProvider)unmodifiableIterator.next()).getName().equals("debug_data"));
            }
        }
    }

    public void writeToConfig() {
        String name;
        JsonObject root = new JsonObject();
        JsonObject objToggles = new JsonObject();
        Servux.debugLog("DataProviderManager#writeToConfig()", new Object[0]);
        for (IDataProvider provider : this.providersImmutable) {
            name = provider.getName();
            objToggles.add(name, (JsonElement)new JsonPrimitive(Boolean.valueOf(provider.isEnabled())));
        }
        root.add("DataProviderToggles", (JsonElement)objToggles);
        for (IDataProvider provider : this.providersImmutable) {
            name = provider.getName();
            root.add(name, (JsonElement)provider.toJson());
        }
        JsonUtils.writeJsonToFileAsPath(root, this.getConfigFile());
    }

    protected Path getConfigFile() {
        if (this.configDir == null) {
            this.configDir = Reference.DEFAULT_CONFIG_DIR;
        }
        if (!Files.exists(this.configDir, new LinkOption[0])) {
            try {
                Files.createDirectory(this.configDir, new FileAttribute[0]);
            }
            catch (Exception err) {
                Servux.LOGGER.error("getConfigFile: Error creating config directory '{}'; {}", (Object)this.configDir.toAbsolutePath(), (Object)err.getMessage());
            }
        }
        return this.configDir.resolve("servux.json");
    }
}

