/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import carpet.utils.EvictingQueue;
import carpet.utils.Messenger;
import carpet.utils.WoolTool;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1317;
import net.minecraft.class_1767;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1948;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_3108;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3701;
import net.minecraft.class_3730;
import net.minecraft.class_4538;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5483;
import net.minecraft.class_5575;
import net.minecraft.class_5819;
import net.minecraft.class_6010;
import net.minecraft.class_6012;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SpawnReporter {
    private static final class_1311[] CACHED_MOBCATEGORY_VALUES = class_1311.values();
    public static boolean mockSpawns = false;
    public static final HashMap<class_5321<class_1937>, Integer> chunkCounts = new HashMap();
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, Object2LongOpenHashMap<class_1299<?>>> spawn_stats = new HashMap();
    public static double mobcap_exponent = 0.0;
    public static final Object2LongOpenHashMap<Pair<class_5321<class_1937>, class_1311>> spawn_attempts = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<class_5321<class_1937>, class_1311>> overall_spawn_ticks = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<class_5321<class_1937>, class_1311>> spawn_ticks_full = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<class_5321<class_1937>, class_1311>> spawn_ticks_fail = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<class_5321<class_1937>, class_1311>> spawn_ticks_succ = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<class_5321<class_1937>, class_1311>> spawn_ticks_spawns = new Object2LongOpenHashMap();
    public static final Object2LongOpenHashMap<Pair<class_5321<class_1937>, class_1311>> spawn_cap_count = new Object2LongOpenHashMap();
    public static final HashMap<Pair<class_5321<class_1937>, class_1311>, EvictingQueue<Pair<class_1299<?>, class_2338>>> spawned_mobs = new HashMap();
    public static final HashMap<class_1311, Integer> spawn_tries = new HashMap();
    private static int spawnTrackingStartTime = 0;
    private static class_3341 trackedSpawningArea = null;
    public static Object2LongOpenHashMap<class_1311> local_spawns = null;
    public static HashSet<class_1311> first_chunk_marker = null;
    public static final int MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);

    public static void registerSpawn(class_1308 mob, class_1311 cat, class_2338 pos) {
        if (trackedSpawningArea != null && !trackedSpawningArea.method_14662((class_2382)pos)) {
            return;
        }
        Pair key = Pair.of((Object)mob.method_37908().method_27983(), (Object)cat);
        spawn_stats.get(key).addTo((Object)mob.method_5864(), 1L);
        spawned_mobs.get(key).put(Pair.of((Object)mob.method_5864(), (Object)pos));
        if (!local_spawns.containsKey((Object)cat)) {
            CarpetSettings.LOG.error("Rogue spawn detected for category " + cat.method_6133() + " for mob " + mob.method_5864().method_5897().getString() + ". If you see this message let carpet peeps know about it on github issues.");
            local_spawns.put((Object)cat, 0L);
        }
        local_spawns.addTo((Object)cat, 1L);
    }

    public static List<class_2561> printMobcapsForDimension(class_3218 world, boolean multiline) {
        class_5321 dim = world.method_27983();
        String name = dim.method_29177().method_12832();
        ArrayList<class_2561> lst = new ArrayList<class_2561>();
        if (multiline) {
            lst.add(Messenger.s(String.format("Mobcaps for %s:", name)));
        }
        class_1948.class_5262 lastSpawner = world.method_14178().method_27908();
        Object2IntMap dimCounts = lastSpawner.method_27830();
        int chunkcount = chunkCounts.getOrDefault(dim, -1);
        if (dimCounts == null || chunkcount < 0) {
            lst.add(Messenger.c("g   --UNAVAILABLE--"));
            return lst;
        }
        ArrayList<Object> shortCodes = new ArrayList<Object>();
        for (class_1311 category : SpawnReporter.cachedMobCategories()) {
            int cur = dimCounts.getOrDefault((Object)category, -1);
            int max = (int)((double)chunkcount * ((double)category.method_6134() / (double)MAGIC_NUMBER));
            String color = Messenger.heatmap_color(cur, max);
            String mobColor = Messenger.creatureTypeColor(category);
            if (multiline) {
                int rounds = spawn_tries.get(category);
                lst.add(Messenger.c(String.format("w   %s: ", category.method_6133()), cur < 0 ? "g -" : color + " " + cur, "g  / ", mobColor + " " + max, rounds == 1 ? "w " : String.format("gi  (%d rounds/tick)", spawn_tries.get(category))));
                continue;
            }
            shortCodes.add(color + " " + String.valueOf(cur < 0 ? "-" : Integer.valueOf(cur)));
            shortCodes.add("g /");
            shortCodes.add(mobColor + " " + max);
            shortCodes.add("g ,");
        }
        if (!multiline) {
            if (shortCodes.size() > 0) {
                shortCodes.remove(shortCodes.size() - 1);
                lst.add(Messenger.c(shortCodes.toArray(new Object[0])));
            } else {
                lst.add(Messenger.c("g   --UNAVAILABLE--"));
            }
        }
        return lst;
    }

    public static List<class_2561> getRecentSpawns(class_1937 world, class_1311 category) {
        ArrayList<class_2561> lst = new ArrayList<class_2561>();
        if (!SpawnReporter.trackingSpawns()) {
            lst.add(Messenger.s("Spawn tracking not started"));
            return lst;
        }
        String categoryName = category.method_6133();
        lst.add(Messenger.s(String.format("Recent %s spawns:", categoryName)));
        for (Pair pair : spawned_mobs.get(Pair.of((Object)world.method_27983(), (Object)category)).keySet()) {
            lst.add(Messenger.c("w  - ", Messenger.tp("wb", (class_2338)pair.getRight()), String.format("w : %s", ((class_1299)pair.getLeft()).method_5897().getString())));
        }
        if (lst.size() == 1) {
            lst.add(Messenger.s(" - Nothing spawned yet, sorry."));
        }
        return lst;
    }

    public static List<class_2561> handleWoolAction(class_2338 pos, class_3218 worldIn) {
        class_1767 under = WoolTool.getWoolColorAtPosition((class_1937)worldIn, pos.method_10074());
        if (under == null) {
            if (SpawnReporter.trackingSpawns()) {
                return SpawnReporter.makeTrackingReport((class_1937)worldIn);
            }
            return SpawnReporter.printMobcapsForDimension(worldIn, true);
        }
        class_1311 category = SpawnReporter.getCategoryFromWoolColor(under);
        if (category != null) {
            if (SpawnReporter.trackingSpawns()) {
                return SpawnReporter.getRecentSpawns((class_1937)worldIn, category);
            }
            return SpawnReporter.printEntitiesByType(category, worldIn, true);
        }
        if (SpawnReporter.trackingSpawns()) {
            return SpawnReporter.makeTrackingReport((class_1937)worldIn);
        }
        return SpawnReporter.printMobcapsForDimension(worldIn, true);
    }

    public static class_1311 getCategoryFromWoolColor(class_1767 color) {
        return switch (color) {
            case class_1767.field_7964 -> class_1311.field_6302;
            case class_1767.field_7942 -> class_1311.field_6294;
            case class_1767.field_7966 -> class_1311.field_6300;
            case class_1767.field_7957 -> class_1311.field_6303;
            case class_1767.field_7955 -> class_1311.field_24460;
            default -> null;
        };
    }

    public static List<class_2561> printEntitiesByType(class_1311 cat, class_3218 worldIn, boolean all) {
        ArrayList<class_2561> lst = new ArrayList<class_2561>();
        lst.add(Messenger.s(String.format("Loaded entities for %s category:", cat)));
        for (class_1297 entity : worldIn.method_18198(class_5575.method_31795(class_1297.class), e -> e.method_5864().method_5891() == cat)) {
            class_1308 mob;
            boolean persistent;
            boolean bl = persistent = entity instanceof class_1308 && ((mob = (class_1308)entity).method_5947() || mob.method_17326());
            if (!all && persistent) continue;
            class_1299 type = entity.method_5864();
            class_2338 pos = entity.method_24515();
            lst.add(Messenger.c("w  - ", Messenger.tp(persistent ? "gb" : "wb", pos), String.format(persistent ? "g : %s" : "w : %s", type.method_5897().getString())));
        }
        if (lst.size() == 1) {
            lst.add(Messenger.s(" - Empty."));
        }
        return lst;
    }

    public static void initializeMocking() {
        mockSpawns = true;
    }

    public static void stopMocking() {
        mockSpawns = false;
    }

    public static void resetSpawnStats(MinecraftServer server, boolean full) {
        if (full) {
            for (class_1311 category : SpawnReporter.cachedMobCategories()) {
                spawn_tries.put(category, 1);
            }
        }
        overall_spawn_ticks.clear();
        spawn_attempts.clear();
        spawn_ticks_full.clear();
        spawn_ticks_fail.clear();
        spawn_ticks_succ.clear();
        spawn_ticks_spawns.clear();
        spawn_cap_count.clear();
        for (class_1311 category : SpawnReporter.cachedMobCategories()) {
            for (class_5321 world : server.method_29435()) {
                Pair key = Pair.of((Object)world, (Object)category);
                spawn_stats.put((Pair<class_5321<class_1937>, class_1311>)key, new Object2LongOpenHashMap());
                spawned_mobs.put((Pair<class_5321<class_1937>, class_1311>)key, new EvictingQueue());
            }
        }
        spawnTrackingStartTime = 0;
    }

    public static class_1311[] cachedMobCategories() {
        return CACHED_MOBCATEGORY_VALUES;
    }

    public static boolean trackingSpawns() {
        return (long)spawnTrackingStartTime != 0L;
    }

    public static void startTracking(MinecraftServer server, class_3341 trackedArea) {
        SpawnReporter.resetSpawnStats(server, false);
        spawnTrackingStartTime = server.method_3780();
        trackedSpawningArea = trackedArea;
    }

    public static void stopTracking(MinecraftServer server) {
        SpawnReporter.resetSpawnStats(server, false);
        spawnTrackingStartTime = 0;
        trackedSpawningArea = null;
    }

    private static String getWorldCode(class_5321<class_1937> world) {
        if (world == class_1937.field_25179) {
            return "";
        }
        return "(" + Character.toUpperCase(world.method_29177().method_12832().charAt("THE_".length())) + ")";
    }

    public static List<class_2561> makeTrackingReport(class_1937 worldIn) {
        ArrayList<class_2561> report = new ArrayList<class_2561>();
        if (!SpawnReporter.trackingSpawns()) {
            report.add(Messenger.c("w Spawn tracking is disabled, type '", "wi /spawn tracking start", "/spawn tracking start", "w ' to enable"));
            return report;
        }
        int duration = worldIn.method_8503().method_3780() - spawnTrackingStartTime;
        report.add(Messenger.c("bw --------------------"));
        String simulated = mockSpawns ? "[SIMULATED] " : "";
        String location = trackedSpawningArea != null ? String.format("[in (%d, %d, %d)x(%d, %d, %d)]", trackedSpawningArea.method_35415(), trackedSpawningArea.method_35416(), trackedSpawningArea.method_35417(), trackedSpawningArea.method_35418(), trackedSpawningArea.method_35419(), trackedSpawningArea.method_35420()) : "";
        report.add(Messenger.s(String.format("%sSpawn statistics %s: for %.1f min", simulated, location, (double)duration / 72000.0 * 60.0)));
        for (class_1311 category : SpawnReporter.cachedMobCategories()) {
            for (class_5321 dim : worldIn.method_8503().method_29435()) {
                Pair key = Pair.of((Object)dim, (Object)category);
                if (spawn_ticks_spawns.getLong((Object)key) <= 0L) continue;
                double hours = (double)overall_spawn_ticks.getLong((Object)key) / 72000.0;
                long spawnAttemptsForCategory = spawn_attempts.getLong((Object)key);
                report.add(Messenger.s(String.format(" > %s%s (%.1f min), %.1f m/t, %%{%.1fF %.1f- %.1f+}; %.2f s/att", category.method_6133().substring(0, 3), SpawnReporter.getWorldCode((class_5321<class_1937>)dim), 60.0 * hours, 1.0 * (double)spawn_cap_count.getLong((Object)key) / (double)spawnAttemptsForCategory, 100.0 * (double)spawn_ticks_full.getLong((Object)key) / (double)spawnAttemptsForCategory, 100.0 * (double)spawn_ticks_fail.getLong((Object)key) / (double)spawnAttemptsForCategory, 100.0 * (double)spawn_ticks_succ.getLong((Object)key) / (double)spawnAttemptsForCategory, 1.0 * (double)spawn_ticks_spawns.getLong((Object)key) / (double)(spawn_ticks_fail.getLong((Object)key) + spawn_ticks_succ.getLong((Object)key)))));
                for (Object2LongMap.Entry entry : spawn_stats.get(key).object2LongEntrySet()) {
                    report.add(Messenger.s(String.format("   - %s: %d spawns, %d per hour", ((class_1299)entry.getKey()).method_5897().getString(), entry.getLongValue(), 72000L * entry.getLongValue() / (long)duration)));
                }
            }
        }
        return report;
    }

    public static void killEntity(class_1309 entity) {
        if (entity.method_5765()) {
            entity.method_5854().method_31472();
        }
        if (entity.method_5782()) {
            for (class_1297 e : entity.method_5685()) {
                e.method_31472();
            }
        }
        if (entity instanceof class_3701) {
            for (class_1297 e : entity.method_5770().method_8335((class_1297)entity, entity.method_5829())) {
                e.method_31472();
            }
        }
        entity.method_31472();
    }

    private static class_6012<class_5483.class_1964> getSpawnEntries(class_3218 serverLevel, class_5138 structureManager, class_2794 chunkGenerator, class_1311 mobCategory, class_2338 blockPos, @Nullable class_6880<class_1959> holder) {
        return class_1948.method_38091((class_2338)blockPos, (class_3218)serverLevel, (class_1311)mobCategory, (class_5138)structureManager) ? class_3108.field_13705 : chunkGenerator.method_12113(holder != null ? holder : serverLevel.method_23753(blockPos), structureManager, mobCategory, blockPos);
    }

    public static List<class_2561> report(class_2338 pos, class_3218 worldIn) {
        ArrayList<class_2561> rep = new ArrayList<class_2561>();
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        class_2791 chunk = worldIn.method_22350(pos);
        int lc = chunk.method_12005(class_2902.class_2903.field_13202, x, z) + 1;
        String relativeHeight = y == lc ? "right at it." : String.format("%d blocks %s it.", class_3532.method_15382((int)(y - lc)), y >= lc ? "above" : "below");
        rep.add(Messenger.s(String.format("Maximum spawn Y value for (%+d, %+d) is %d. You are " + relativeHeight, x, z, lc)));
        rep.add(Messenger.s("Spawns:"));
        for (class_1311 category : SpawnReporter.cachedMobCategories()) {
            String categoryCode = String.valueOf(category).substring(0, 3);
            class_6012<class_5483.class_1964> lst = SpawnReporter.getSpawnEntries(worldIn, worldIn.method_27056(), worldIn.method_14178().method_12129(), category, pos, (class_6880<class_1959>)worldIn.method_23753(pos));
            if (lst == null || lst.method_34993()) continue;
            for (class_6010 wspawnEntry : lst.method_34994()) {
                class_1308 mob;
                class_5483.class_1964 spawnEntry = (class_5483.class_1964)wspawnEntry.comp_2542();
                if (class_1317.method_6159((class_1299)spawnEntry.comp_3488()) == null) continue;
                boolean canSpawn = class_1317.method_56558((class_1299)spawnEntry.comp_3488(), (class_4538)worldIn, (class_2338)pos);
                int willSpawn = -1;
                boolean fits = false;
                try {
                    mob = (class_1308)spawnEntry.comp_3488().method_5883((class_1937)worldIn, class_3730.field_16459);
                }
                catch (Exception e) {
                    CarpetSettings.LOG.warn("Exception while creating mob for spawn reporter", (Throwable)e);
                    return rep;
                }
                if (canSpawn) {
                    willSpawn = 0;
                    for (int attempt = 0; attempt < 50; ++attempt) {
                        float f = (float)x + 0.5f;
                        float f1 = (float)z + 0.5f;
                        mob.method_5808((double)f, (double)y, (double)f1, worldIn.field_9229.method_43057() * 360.0f, 0.0f);
                        fits = worldIn.method_17892((class_1297)mob);
                        class_1299 etype = mob.method_5864();
                        for (int i = 0; i < 20; ++i) {
                            if (!class_1317.method_20638((class_1299)etype, (class_5425)worldIn, (class_3730)class_3730.field_16459, (class_2338)pos, (class_5819)worldIn.field_9229) || !class_1317.method_56558((class_1299)etype, (class_4538)worldIn, (class_2338)pos) || !mob.method_5979((class_1936)worldIn, class_3730.field_16459)) continue;
                            if (etype == class_1299.field_6081) {
                                class_2680 blockState = worldIn.method_8320(pos.method_10074());
                                if (pos.method_10264() < worldIn.method_8615() || !blockState.method_27852(class_2246.field_10219) && !blockState.method_26164(class_3481.field_15503)) continue;
                            }
                            ++willSpawn;
                        }
                        mob.method_5943((class_5425)worldIn, worldIn.method_8404(mob.method_24515()), class_3730.field_16459, null);
                        fits = fits && worldIn.method_17892((class_1297)mob);
                        SpawnReporter.killEntity((class_1309)mob);
                        try {
                            mob = (class_1308)spawnEntry.comp_3488().method_5883((class_1937)worldIn, class_3730.field_16459);
                            continue;
                        }
                        catch (Exception e) {
                            CarpetSettings.LOG.warn("Exception while creating mob for spawn reporter", (Throwable)e);
                            return rep;
                        }
                    }
                }
                String mobTypeName = mob.method_5864().method_5897().getString();
                int weight = wspawnEntry.comp_2543();
                if (canSpawn) {
                    String color = fits && willSpawn > 0 ? "e" : "gi";
                    rep.add(Messenger.c(String.format("%s %s: %s (%d:%d-%d/%d), can: ", color, categoryCode, mobTypeName, weight, spawnEntry.comp_3489(), spawnEntry.comp_3490(), mob.method_5945()), "l YES", color + " , fit: ", fits ? "l YES" : "r NO", color + " , will: ", (willSpawn > 0 ? "l " : "r ") + Math.round((double)willSpawn) / 10L + "%"));
                } else {
                    rep.add(Messenger.c(String.format("gi %s: %s (%d:%d-%d/%d), can: ", categoryCode, mobTypeName, weight, spawnEntry.comp_3489(), spawnEntry.comp_3490(), mob.method_5945()), "n NO"));
                }
                SpawnReporter.killEntity((class_1309)mob);
            }
        }
        return rep;
    }
}

