/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.CarpetScriptServer;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.language.Sys;
import carpet.script.utils.ParticleParser;
import carpet.script.utils.shapes.ShapeDirection;
import carpet.script.value.AbstractListValue;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.google.common.collect.Sets;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2512;
import net.minecraft.class_2514;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5819;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_9848;
import net.minecraft.server.MinecraftServer;

public class ShapeDispatcher {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ShapeWithConfig fromFunctionArgs(MinecraftServer server, class_3218 world, List<Value> lv, Set<class_3222> playerSet) {
        List<Value> playerVals;
        Map<String, Value> params;
        if (lv.size() < 3) {
            throw new InternalExpressionException("'draw_shape' takes at least three parameters, shape name, duration, and its params");
        }
        String shapeType = lv.get(0).getString();
        NumericValue duration = NumericValue.asNumber(lv.get(1), "duration");
        if (lv.size() == 3) {
            Value paramValue = lv.get(2);
            if (paramValue instanceof MapValue) {
                MapValue map = (MapValue)paramValue;
                params = new HashMap<String, Value>();
                map.getMap().forEach((key, value) -> params.put(key.getString(), (Value)value));
            } else {
                if (!(paramValue instanceof ListValue)) throw new InternalExpressionException("Parameters for 'draw_shape' need to be defined either in a list or a map");
                ListValue list = (ListValue)paramValue;
                params = ShapeDispatcher.parseParams(list.getItems());
            }
        } else {
            ArrayList<Value> paramList = new ArrayList<Value>();
            for (int i = 2; i < lv.size(); ++i) {
                paramList.add(lv.get(i));
            }
            params = ShapeDispatcher.parseParams(paramList);
        }
        params.putIfAbsent("dim", new StringValue(world.method_27983().method_29177().toString()));
        params.putIfAbsent("duration", duration);
        if (!params.containsKey("player")) return new ShapeWithConfig(ShapeDispatcher.create(server, shapeType, params), params);
        Value players = params.get("player");
        if (players instanceof ListValue) {
            ListValue list = (ListValue)players;
            playerVals = list.getItems();
        } else {
            playerVals = Collections.singletonList(players);
        }
        for (Value pVal : playerVals) {
            class_3222 player = EntityValue.getPlayerByValue(server, pVal);
            if (player == null) {
                throw new InternalExpressionException("'player' parameter needs to represent an existing player, not " + pVal.getString());
            }
            playerSet.add(player);
        }
        params.remove("player");
        return new ShapeWithConfig(ShapeDispatcher.create(server, shapeType, params), params);
    }

    public static void sendShape(Collection<class_3222> players, List<ShapeWithConfig> shapes, class_5455 regs) {
        ArrayList<class_3222> clientPlayers = new ArrayList<class_3222>();
        ArrayList alternativePlayers = new ArrayList();
        for (class_3222 player : players) {
            (Carpet.isValidCarpetPlayer(player) ? clientPlayers : alternativePlayers).add(player);
        }
        if (!clientPlayers.isEmpty()) {
            class_2499 tag = new class_2499();
            int tagcount = 0;
            for (ShapeWithConfig s2 : shapes) {
                tag.add((Object)ExpiringShape.toTag(s2.config(), regs));
                if (tagcount++ <= 1000) continue;
                tagcount = 0;
                class_2499 finalTag = tag;
                clientPlayers.forEach(arg_0 -> ShapeDispatcher.lambda$sendShape$1((class_2520)finalTag, arg_0));
                tag = new class_2499();
            }
            class_2499 finalTag = tag;
            if (!tag.isEmpty()) {
                clientPlayers.forEach(arg_0 -> ShapeDispatcher.lambda$sendShape$2((class_2520)finalTag, arg_0));
            }
        }
        if (!alternativePlayers.isEmpty()) {
            ArrayList alternatives = new ArrayList();
            shapes.forEach(s -> alternatives.add(s.shape().alternative()));
            alternativePlayers.forEach(p -> alternatives.forEach(a -> a.accept(p)));
        }
    }

    public static class_2394 getParticleData(String name, class_5455 regs) {
        try {
            return ParticleParser.getEffect(name, regs);
        }
        catch (IllegalArgumentException e) {
            throw new ThrowStatement(name, Throwables.UNKNOWN_PARTICLE);
        }
    }

    public static Map<String, Value> parseParams(List<Value> items) {
        if (items.size() % 2 == 1) {
            throw new InternalExpressionException("Shape parameters list needs to be of even size");
        }
        HashMap<String, Value> param = new HashMap<String, Value>();
        for (int i = 0; i < items.size(); i += 2) {
            String name = items.get(i).getString();
            Value val = items.get(i + 1);
            param.put(name, val);
        }
        return param;
    }

    public static ExpiringShape create(MinecraftServer server, String shapeType, Map<String, Value> userParams) {
        userParams.put("shape", new StringValue(shapeType));
        userParams.keySet().forEach(key -> {
            Param param = Param.of.get(key);
            if (param == null) {
                throw new InternalExpressionException("Unknown feature for shape: " + key);
            }
            userParams.put((String)key, param.validate(userParams, server, (Value)userParams.get(key)));
        });
        BiFunction<Map<String, Value>, class_5455, ExpiringShape> factory = ExpiringShape.shapeProviders.get(shapeType);
        if (factory == null) {
            throw new InternalExpressionException("Unknown shape: " + shapeType);
        }
        return factory.apply(userParams, (class_5455)server.method_30611());
    }

    @Nullable
    public static ExpiringShape fromTag(class_2487 tag, class_1937 level) {
        HashMap<String, Value> options = new HashMap<String, Value>();
        for (String key : tag.method_10541()) {
            Param decoder = Param.of.get(key);
            if (decoder == null) {
                CarpetScriptServer.LOG.info("Unknown parameter for shape: " + key);
                return null;
            }
            Value decodedValue = decoder.decode(tag.method_10580(key), level);
            options.put(key, decodedValue);
        }
        Value shapeValue = (Value)options.get("shape");
        if (shapeValue == null) {
            CarpetScriptServer.LOG.info("Shape id missing in " + String.join((CharSequence)", ", tag.method_10541()));
            return null;
        }
        BiFunction<Map<String, Value>, class_5455, ExpiringShape> factory = ExpiringShape.shapeProviders.get(shapeValue.getString());
        if (factory == null) {
            CarpetScriptServer.LOG.info("Unknown shape: " + shapeValue.getString());
            return null;
        }
        try {
            return factory.apply(options, level.method_30349());
        }
        catch (InternalExpressionException exc) {
            CarpetScriptServer.LOG.info(exc.getMessage());
            return null;
        }
    }

    private static boolean isStraight(class_243 from, class_243 to, double density) {
        if (from.field_1352 == to.field_1352 && from.field_1351 == to.field_1351 || from.field_1352 == to.field_1352 && from.field_1350 == to.field_1350 || from.field_1351 == to.field_1351 && from.field_1350 == to.field_1350) {
            return from.method_1022(to) / density > 20.0;
        }
        return false;
    }

    private static int drawOptimizedParticleLine(List<class_3222> playerList, class_2394 particle, class_243 from, class_243 to, double density) {
        double distance = from.method_1022(to);
        int particles = (int)(distance / density);
        class_243 towards = to.method_1020(from);
        int parts = 0;
        for (class_3222 player : playerList) {
            class_3218 world = player.method_51469();
            world.method_14166(player, particle, true, true, towards.field_1352 / 2.0 + from.field_1352, towards.field_1351 / 2.0 + from.field_1351, towards.field_1350 / 2.0 + from.field_1350, particles / 3, towards.field_1352 / 6.0, towards.field_1351 / 6.0, towards.field_1350 / 6.0, 0.0);
            world.method_14166(player, particle, true, true, from.field_1352, from.field_1351, from.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            world.method_14166(player, particle, true, true, to.field_1352, to.field_1351, to.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            parts += particles / 3 + 2;
        }
        int divider = 6;
        while (particles / divider > 1) {
            int center = divider * 2 / 3;
            int dev = 2 * divider;
            for (class_3222 player : playerList) {
                class_3218 world = player.method_51469();
                world.method_14166(player, particle, true, true, towards.field_1352 / (double)center + from.field_1352, towards.field_1351 / (double)center + from.field_1351, towards.field_1350 / (double)center + from.field_1350, particles / divider, towards.field_1352 / (double)dev, towards.field_1351 / (double)dev, towards.field_1350 / (double)dev, 0.0);
                world.method_14166(player, particle, true, true, towards.field_1352 * (1.0 - 1.0 / (double)center) + from.field_1352, towards.field_1351 * (1.0 - 1.0 / (double)center) + from.field_1351, towards.field_1350 * (1.0 - 1.0 / (double)center) + from.field_1350, particles / divider, towards.field_1352 / (double)dev, towards.field_1351 / (double)dev, towards.field_1350 / (double)dev, 0.0);
            }
            parts += 2 * particles / divider;
            divider = 2 * divider;
        }
        return parts;
    }

    public static int drawParticleLine(List<class_3222> players, class_2394 particle, class_243 from, class_243 to, double density) {
        double distance = from.method_1025(to);
        if (distance == 0.0) {
            return 0;
        }
        int pcount = 0;
        if (distance < 100.0) {
            class_5819 rand = players.get((int)0).method_37908().field_9229;
            int particles = (int)(distance / density) + 1;
            class_243 towards = to.method_1020(from);
            for (int i = 0; i < particles; ++i) {
                class_243 at = from.method_1019(towards.method_1021(rand.method_43058()));
                for (class_3222 player : players) {
                    player.method_51469().method_14166(player, particle, true, true, at.field_1352, at.field_1351, at.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    ++pcount;
                }
            }
            return pcount;
        }
        if (ShapeDispatcher.isStraight(from, to, density)) {
            return ShapeDispatcher.drawOptimizedParticleLine(players, particle, from, to, density);
        }
        class_243 incvec = to.method_1020(from).method_1021(2.0 * density / Math.sqrt(distance));
        class_243 delta = new class_243(0.0, 0.0, 0.0);
        while (delta.method_1027() < distance) {
            for (class_3222 player : players) {
                player.method_51469().method_14166(player, particle, true, true, delta.field_1352 + from.field_1352, delta.field_1351 + from.field_1351, delta.field_1350 + from.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                ++pcount;
            }
            delta = delta.method_1019(incvec.method_1021((double)Sys.randomizer.nextFloat()));
        }
        return pcount;
    }

    private static /* synthetic */ void lambda$sendShape$2(class_2520 finalTag, class_3222 p) {
        Vanilla.sendScarpetShapesDataToPlayer(p, finalTag);
    }

    private static /* synthetic */ void lambda$sendShape$1(class_2520 finalTag, class_3222 p) {
        Vanilla.sendScarpetShapesDataToPlayer(p, finalTag);
    }

    public record ShapeWithConfig(ExpiringShape shape, Map<String, Value> config) {
    }

    public static abstract class ExpiringShape {
        public static final Map<String, BiFunction<Map<String, Value>, class_5455, ExpiringShape>> shapeProviders = new HashMap<String, BiFunction<Map<String, Value>, class_5455, ExpiringShape>>(){
            {
                this.put("line", ExpiringShape.creator(Line::new));
                this.put("box", ExpiringShape.creator(Box::new));
                this.put("sphere", ExpiringShape.creator(Sphere::new));
                this.put("cylinder", ExpiringShape.creator(Cylinder::new));
                this.put("label", ExpiringShape.creator(DisplayedText::new));
                this.put("polygon", ExpiringShape.creator(Polyface::new));
                this.put("block", ExpiringShape.creator(() -> new DisplayedSprite(false)));
                this.put("item", ExpiringShape.creator(() -> new DisplayedSprite(true)));
            }
        };
        float lineWidth;
        protected float r;
        protected float g;
        protected float b;
        protected float a;
        protected int color;
        protected float fr;
        protected float fg;
        protected float fb;
        protected float fa;
        protected int fillColor;
        protected int duration = 0;
        private long key;
        protected int followEntity;
        protected String snapTo;
        protected boolean snapX;
        protected boolean snapY;
        protected boolean snapZ;
        protected boolean discreteX;
        protected boolean discreteY;
        protected boolean discreteZ;
        protected class_5321<class_1937> shapeDimension;
        protected boolean debug;
        private static final double xdif = new Random(120L).nextDouble();
        private static final double ydif = new Random(121L).nextDouble();
        private static final double zdif = new Random(122L).nextDouble();
        private final Set<String> required = Set.of("duration", "shape", "dim");
        private final Map<String, Value> optional = Map.of("color", new NumericValue(-1L), "follow", new NumericValue(-1L), "line", new NumericValue(2.0), "debug", Value.FALSE, "fill", new NumericValue(-256L), "snap", new StringValue("xyz"));

        private static BiFunction<Map<String, Value>, class_5455, ExpiringShape> creator(Supplier<ExpiringShape> shapeFactory) {
            return (o, regs) -> {
                ExpiringShape shape = (ExpiringShape)shapeFactory.get();
                shape.fromOptions((Map<String, Value>)o, (class_5455)regs);
                return shape;
            };
        }

        protected ExpiringShape() {
        }

        public static class_2487 toTag(Map<String, Value> params, class_5455 regs) {
            class_2487 tag = new class_2487();
            params.forEach((k, v) -> {
                class_2520 valTag = Param.of.get(k).toTag((Value)v, regs);
                if (valTag != null) {
                    tag.method_10566(k, valTag);
                }
            });
            return tag;
        }

        private void fromOptions(Map<String, Value> options, class_5455 regs) {
            Set<String> requiredParams;
            Set<String> optionalParams = this.optionalParams();
            Sets.SetView all = Sets.union(optionalParams, requiredParams = this.requiredParams());
            if (!all.containsAll(options.keySet())) {
                throw new InternalExpressionException("Received unexpected parameters for shape: " + String.valueOf(Sets.difference(options.keySet(), (Set)all)));
            }
            if (!options.keySet().containsAll(requiredParams)) {
                throw new InternalExpressionException("Missing required parameters for shape: " + String.valueOf(Sets.difference(requiredParams, options.keySet())));
            }
            options.keySet().forEach(k -> {
                if (!this.canTake((String)k)) {
                    throw new InternalExpressionException("Parameter " + k + " doesn't apply for shape " + ((Value)options.get("shape")).getString());
                }
            });
            this.init(options, regs);
        }

        protected void init(Map<String, Value> options, class_5455 regs) {
            this.duration = NumericValue.asNumber(options.get("duration")).getInt();
            this.lineWidth = NumericValue.asNumber(options.getOrDefault("line", this.optional.get("line"))).getFloat();
            this.fillColor = NumericValue.asNumber(options.getOrDefault("fill", this.optional.get("fill"))).getInt();
            this.fr = (float)(this.fillColor >> 24 & 0xFF) / 255.0f;
            this.fg = (float)(this.fillColor >> 16 & 0xFF) / 255.0f;
            this.fb = (float)(this.fillColor >> 8 & 0xFF) / 255.0f;
            this.fa = (float)(this.fillColor & 0xFF) / 255.0f;
            this.color = NumericValue.asNumber(options.getOrDefault("color", this.optional.get("color"))).getInt();
            this.r = (float)(this.color >> 24 & 0xFF) / 255.0f;
            this.g = (float)(this.color >> 16 & 0xFF) / 255.0f;
            this.b = (float)(this.color >> 8 & 0xFF) / 255.0f;
            this.a = (float)(this.color & 0xFF) / 255.0f;
            this.debug = false;
            if (options.containsKey("debug")) {
                this.debug = options.get("debug").getBoolean();
            }
            this.key = 0L;
            this.followEntity = -1;
            this.shapeDimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)options.get("dim").getString()));
            if (options.containsKey("follow")) {
                this.followEntity = NumericValue.asNumber(options.getOrDefault("follow", this.optional.get("follow"))).getInt();
                this.snapTo = options.getOrDefault("snap", this.optional.get("snap")).getString().toLowerCase(Locale.ROOT);
                this.snapX = this.snapTo.contains("x");
                this.snapY = this.snapTo.contains("y");
                this.snapZ = this.snapTo.contains("z");
                this.discreteX = this.snapTo.contains("dx");
                this.discreteY = this.snapTo.contains("dy");
                this.discreteZ = this.snapTo.contains("dz");
            }
        }

        public int getExpiry() {
            return this.duration;
        }

        public class_243 toAbsolute(class_1297 e, class_243 vec, float partialTick) {
            return vec.method_1031(this.snapX ? (this.discreteX ? (double)class_3532.method_15357((double)e.method_23317()) : class_3532.method_16436((double)partialTick, (double)e.field_6014, (double)e.method_23317())) : 0.0, this.snapY ? (this.discreteY ? (double)class_3532.method_15357((double)e.method_23318()) : class_3532.method_16436((double)partialTick, (double)e.field_6036, (double)e.method_23318())) : 0.0, this.snapZ ? (this.discreteZ ? (double)class_3532.method_15357((double)e.method_23321()) : class_3532.method_16436((double)partialTick, (double)e.field_5969, (double)e.method_23321())) : 0.0);
        }

        public class_243 relativiseRender(class_1937 world, class_243 vec, float partialTick) {
            if (this.followEntity < 0) {
                return vec;
            }
            class_1297 e = world.method_8469(this.followEntity);
            if (e == null) {
                return vec;
            }
            return this.toAbsolute(e, vec, partialTick);
        }

        public class_243 vecFromValue(Value value) {
            if (!(value instanceof ListValue)) {
                throw new InternalExpressionException("decoded value of " + value.getPrettyString() + " is not a triple");
            }
            ListValue list = (ListValue)value;
            List<Value> elements = list.getItems();
            return new class_243(NumericValue.asNumber(elements.get(0)).getDouble(), NumericValue.asNumber(elements.get(1)).getDouble(), NumericValue.asNumber(elements.get(2)).getDouble());
        }

        protected class_2394 replacementParticle(class_5455 regs) {
            boolean bg = this.fa == 0.0f;
            return new class_2390(class_9848.method_61318((float)1.0f, (float)(bg ? this.r : this.fr), (float)(bg ? this.r : this.fr), (float)(bg ? this.r : this.fr)), 1.0f);
        }

        public abstract Consumer<class_3222> alternative();

        public long key(class_5455 regs) {
            if (this.key != 0L) {
                return this.key;
            }
            this.key = this.calcKey(regs);
            return this.key;
        }

        protected long calcKey(class_5455 regs) {
            long hash = -3750763034362895579L;
            hash ^= (long)this.shapeDimension.hashCode();
            hash *= 1099511628211L;
            hash ^= (long)this.color;
            hash *= 1099511628211L;
            hash ^= (long)this.followEntity;
            hash *= 1099511628211L;
            hash ^= (long)Boolean.hashCode(this.debug);
            hash *= 1099511628211L;
            if (this.followEntity >= 0) {
                hash ^= (long)this.snapTo.hashCode();
                hash *= 1099511628211L;
            }
            hash ^= (long)Float.hashCode(this.lineWidth);
            hash *= 1099511628211L;
            if ((double)this.fa != 0.0) {
                hash = 31L * hash + (long)this.fillColor;
                hash *= 1099511628211L;
            }
            return hash;
        }

        int vec3dhash(class_243 vec) {
            return vec.method_1031(xdif, ydif, zdif).hashCode();
        }

        protected Set<String> requiredParams() {
            return this.required;
        }

        protected Set<String> optionalParams() {
            return this.optional.keySet();
        }

        private boolean canTake(String param) {
            return this.requiredParams().contains(param) || this.optionalParams().contains(param);
        }
    }

    public static abstract class Param {
        public static final Map<String, Param> of = new HashMap<String, Param>(){
            {
                this.put("mode", new StringChoiceParam("mode", "polygon", "strip", "triangles"));
                this.put("relative", new OptionalBoolListParam("relative"));
                this.put("inner", new BoolParam("inner"));
                this.put("shape", new ShapeParam());
                this.put("dim", new DimensionParam());
                this.put("duration", new NonNegativeIntParam("duration"));
                this.put("color", new ColorParam("color"));
                this.put("follow", new EntityParam("follow"));
                this.put("variant", new StringChoiceParam(this, "variant", new String[]{"NONE", "THIRD_PERSON_LEFT_HAND", "THIRD_PERSON_RIGHT_HAND", "FIRST_PERSON_LEFT_HAND", "FIRST_PERSON_RIGHT_HAND", "HEAD", "GUI", "GROUND", "FIXED"}){

                    @Override
                    public Value validate(Map<String, Value> o, MinecraftServer s, Value v) {
                        return super.validate(o, s, new StringValue(v.getString().toUpperCase(Locale.ROOT)));
                    }
                });
                this.put("snap", new StringChoiceParam("snap", "xyz", "xz", "yz", "xy", "x", "y", "z", "dxdydz", "dxdz", "dydz", "dxdy", "dx", "dy", "dz", "xdz", "dxz", "ydz", "dyz", "xdy", "dxy", "xydz", "xdyz", "xdydz", "dxyz", "dxydz", "dxdyz"));
                this.put("line", new PositiveFloatParam("line"));
                this.put("fill", new ColorParam("fill"));
                this.put("from", new Vec3Param("from", false));
                this.put("to", new Vec3Param("to", true));
                this.put("center", new Vec3Param("center", false));
                this.put("pos", new Vec3Param("pos", false));
                this.put("radius", new PositiveFloatParam("radius"));
                this.put("level", new PositiveIntParam("level"));
                this.put("height", new FloatParam("height"));
                this.put("width", new FloatParam("width"));
                this.put("scale", new Vec3Param(this, "scale", false){

                    @Override
                    public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
                        if (value instanceof NumericValue) {
                            NumericValue vn = (NumericValue)value;
                            value = ListValue.of(vn, vn, vn);
                        }
                        return super.validate(options, server, value);
                    }
                });
                this.put("axis", new StringChoiceParam("axis", "x", "y", "z"));
                this.put("points", new PointsParam("points"));
                this.put("text", new FormattedTextParam("text"));
                this.put("value", new FormattedTextParam("value"));
                this.put("size", new PositiveIntParam("size"));
                this.put("align", new StringChoiceParam("align", "center", "left", "right"));
                this.put("block", new BlockParam("block"));
                this.put("item", new ItemParam("item"));
                this.put("blocklight", new NonNegativeIntParam("blocklight"));
                this.put("skylight", new NonNegativeIntParam("skylight"));
                this.put("indent", new FloatParam("indent"));
                this.put("raise", new FloatParam("raise"));
                this.put("tilt", new FloatParam("tilt"));
                this.put("lean", new FloatParam("lean"));
                this.put("turn", new FloatParam("turn"));
                this.put("facing", new StringChoiceParam("facing", "player", "camera", "north", "south", "east", "west", "up", "down"));
                this.put("doublesided", new BoolParam("doublesided"));
                this.put("debug", new BoolParam("debug"));
            }
        };
        protected String id;

        protected Param(String id) {
            this.id = id;
        }

        @Nullable
        public abstract class_2520 toTag(Value var1, class_5455 var2);

        public abstract Value validate(Map<String, Value> var1, MinecraftServer var2, Value var3);

        public abstract Value decode(class_2520 var1, class_1937 var2);
    }

    public static class EntityParam
    extends Param {
        protected EntityParam(String id) {
            super(id);
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return class_2497.method_23247((int)NumericValue.asNumber(value, this.id).getInt());
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            if (value instanceof EntityValue) {
                EntityValue ev = (EntityValue)value;
                return new NumericValue(ev.getEntity().method_5628());
            }
            class_3222 player = EntityValue.getPlayerByValue(server, value);
            if (player == null) {
                throw new InternalExpressionException(this.id + " parameter needs to represent an entity or player");
            }
            return new NumericValue(player.method_5628());
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return new NumericValue(((class_2497)tag).method_10701());
        }
    }

    public static class ColorParam
    extends NumericParam {
        protected ColorParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return new NumericValue(((class_2497)tag).method_10701());
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return class_2497.method_23247((int)NumericValue.asNumber(value, this.id).getInt());
        }
    }

    public static class PointsParam
    extends Param {
        public PointsParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            if (!(value instanceof ListValue)) {
                throw new InternalExpressionException(this.id + " parameter should be a list");
            }
            ListValue list = (ListValue)value;
            ArrayList<Value> points = new ArrayList<Value>();
            for (Value point : list.getItems()) {
                points.add(Vec3Param.validate(this, options, point, false));
            }
            return ListValue.wrap(points);
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            class_2499 ltag = (class_2499)tag;
            ArrayList<Value> points = new ArrayList<Value>();
            int ll = ltag.size();
            for (int i = 0; i < ll; ++i) {
                class_2499 ptag = (class_2499)ltag.method_10603(i).orElseThrow();
                points.add(ListValue.of(new NumericValue((Double)ptag.method_10611(0).orElseThrow()), new NumericValue((Double)ptag.method_10611(1).orElseThrow()), new NumericValue((Double)ptag.method_10611(2).orElseThrow())));
            }
            return ListValue.wrap(points);
        }

        @Override
        public class_2520 toTag(Value pointsValue, class_5455 regs) {
            List<Value> lv = ((ListValue)pointsValue).getItems();
            class_2499 ltag = new class_2499();
            for (Value value : lv) {
                List<Value> coords = ((ListValue)value).getItems();
                class_2499 tag = new class_2499();
                tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(coords.get(0), "x").getDouble()));
                tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(coords.get(1), "y").getDouble()));
                tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(coords.get(2), "z").getDouble()));
                ltag.add((Object)tag);
            }
            return ltag;
        }
    }

    public static class Vec3Param
    extends Param {
        private final boolean roundsUpForBlocks;

        protected Vec3Param(String id, boolean doesRoundUpForBlocks) {
            super(id);
            this.roundsUpForBlocks = doesRoundUpForBlocks;
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            return Vec3Param.validate(this, options, value, this.roundsUpForBlocks);
        }

        public static Value validate(Param p, Map<String, Value> options, Value value, boolean roundsUp) {
            if (value instanceof BlockValue) {
                BlockValue bv = (BlockValue)value;
                if (options.containsKey("follow")) {
                    throw new InternalExpressionException(p.id + " parameter cannot use blocks as positions for relative positioning due to 'follow' attribute being present");
                }
                class_2338 pos = bv.getPos();
                int offset = roundsUp ? 1 : 0;
                return ListValue.of(new NumericValue(pos.method_10263() + offset), new NumericValue(pos.method_10264() + offset), new NumericValue(pos.method_10260() + offset));
            }
            if (value instanceof ListValue) {
                ListValue list = (ListValue)value;
                List<Value> values = list.getItems();
                if (values.size() != 3) {
                    throw new InternalExpressionException("'" + p.id + "' requires 3 numerical values");
                }
                for (Value component : values) {
                    if (component instanceof NumericValue) continue;
                    throw new InternalExpressionException("'" + p.id + "' requires 3 numerical values");
                }
                return value;
            }
            if (value instanceof EntityValue) {
                EntityValue ev = (EntityValue)value;
                if (options.containsKey("follow")) {
                    throw new InternalExpressionException(p.id + " parameter cannot use entity as positions for relative positioning due to 'follow' attribute being present");
                }
                class_1297 e = ev.getEntity();
                return ListValue.of(new NumericValue(e.method_23317()), new NumericValue(e.method_23318()), new NumericValue(e.method_23321()));
            }
            CarpetScriptServer.LOG.error("Value: " + value.getString());
            throw new InternalExpressionException("'" + p.id + "' requires a triple, block or entity to indicate position");
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            class_2499 ctag = (class_2499)tag;
            return ListValue.of(new NumericValue((Double)ctag.method_10611(0).orElseThrow()), new NumericValue((Double)ctag.method_10611(1).orElseThrow()), new NumericValue((Double)ctag.method_10611(2).orElseThrow()));
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            List<Value> lv = ((ListValue)value).getItems();
            class_2499 tag = new class_2499();
            tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(lv.get(0), "x").getDouble()));
            tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(lv.get(1), "y").getDouble()));
            tag.add((Object)class_2489.method_23241((double)NumericValue.asNumber(lv.get(2), "z").getDouble()));
            return tag;
        }
    }

    public static class NonNegativeFloatParam
    extends NumericParam {
        protected NonNegativeFloatParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return new NumericValue(((class_2494)tag).method_10700());
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return class_2494.method_23244((float)NumericValue.asNumber(value, this.id).getFloat());
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            Value ret = super.validate(options, server, value);
            if (((NumericValue)ret).getDouble() < 0.0) {
                throw new InternalExpressionException("'" + this.id + "' should be non-negative");
            }
            return ret;
        }
    }

    public static class NonNegativeIntParam
    extends NumericParam {
        protected NonNegativeIntParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return new NumericValue(((class_2497)tag).method_10701());
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return class_2497.method_23247((int)NumericValue.asNumber(value, this.id).getInt());
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            Value ret = super.validate(options, server, value);
            if (((NumericValue)ret).getDouble() < 0.0) {
                throw new InternalExpressionException("'" + this.id + "' should be non-negative");
            }
            return ret;
        }
    }

    public static class PositiveIntParam
    extends PositiveParam {
        protected PositiveIntParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return new NumericValue(((class_2497)tag).method_10701());
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return class_2497.method_23247((int)NumericValue.asNumber(value, this.id).getInt());
        }
    }

    public static class PositiveFloatParam
    extends PositiveParam {
        protected PositiveFloatParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return new NumericValue(((class_2494)tag).method_10700());
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return class_2494.method_23244((float)NumericValue.asNumber(value, this.id).getFloat());
        }
    }

    public static abstract class PositiveParam
    extends NumericParam {
        protected PositiveParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            Value ret = super.validate(options, server, value);
            if (((NumericValue)ret).getDouble() <= 0.0) {
                throw new InternalExpressionException("'" + this.id + "' should be positive");
            }
            return ret;
        }
    }

    public static class FloatParam
    extends NumericParam {
        protected FloatParam(String id) {
            super(id);
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return new NumericValue(((class_2494)tag).method_10700());
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return class_2494.method_23244((float)NumericValue.asNumber(value, this.id).getFloat());
        }
    }

    public static class BoolParam
    extends NumericParam {
        protected BoolParam(String id) {
            super(id);
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return class_2481.method_23234((boolean)value.getBoolean());
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return BooleanValue.of(((class_2481)tag).method_10698() > 0);
        }
    }

    public static abstract class NumericParam
    extends Param {
        protected NumericParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            if (!(value instanceof NumericValue)) {
                throw new InternalExpressionException("'" + this.id + "' needs to be a number");
            }
            return value;
        }
    }

    public static class ShapeParam
    extends StringParam {
        protected ShapeParam() {
            super("shape");
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            String shape = value.getString();
            if (!ExpiringShape.shapeProviders.containsKey(shape)) {
                throw new InternalExpressionException("Unknown shape: " + shape);
            }
            return value;
        }
    }

    public static class DimensionParam
    extends StringParam {
        protected DimensionParam() {
            super("dim");
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            return value;
        }
    }

    public static class StringChoiceParam
    extends StringParam {
        private final Set<String> options;

        public StringChoiceParam(String id, String ... options) {
            super(id);
            this.options = Sets.newHashSet((Object[])options);
        }

        @Override
        @Nullable
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            if (this.options.contains(value.getString())) {
                return value;
            }
            return null;
        }
    }

    public static class FormattedTextParam
    extends StringParam {
        protected FormattedTextParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            if (!(value instanceof FormattedTextValue)) {
                value = new FormattedTextValue((class_2561)class_2561.method_43470((String)value.getString()));
            }
            return value;
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            if (!(value instanceof FormattedTextValue)) {
                value = new FormattedTextValue((class_2561)class_2561.method_43470((String)value.getString()));
            }
            return class_2519.method_23256((String)((FormattedTextValue)value).serialize(regs));
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return FormattedTextValue.deserialize((String)tag.method_68658().get(), level.method_30349());
        }
    }

    public static class TextParam
    extends StringParam {
        protected TextParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            return value;
        }
    }

    public static class ItemParam
    extends Param {
        protected ItemParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            class_1799 item = ValueConversions.getItemStackFromValue(value, true, (class_5455)server.method_30611());
            return new NBTSerializableValue(class_1799.field_24671.encodeStart((DynamicOps)server.method_30611().method_57093((DynamicOps)class_2509.field_11560), (Object)item).result().orElse(null));
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return ((NBTSerializableValue)value).getTag();
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return new NBTSerializableValue(tag);
        }
    }

    public static class BlockParam
    extends Param {
        protected BlockParam(String id) {
            super(id);
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            if (value instanceof BlockValue) {
                return value;
            }
            return BlockValue.fromString(value.getString(), server.method_30002());
        }

        @Override
        @Nullable
        public class_2520 toTag(Value value, class_5455 regs) {
            if (value instanceof BlockValue) {
                BlockValue blv = (BlockValue)value;
                class_2487 com = class_2512.method_10686((class_2680)blv.getBlockState());
                class_2487 dataTag = blv.getData();
                if (dataTag != null) {
                    com.method_10566("TileEntityData", (class_2520)dataTag);
                }
                return com;
            }
            return null;
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            class_2680 bs = class_2512.method_10681((class_7871)level.method_45448(class_7924.field_41254), (class_2487)((class_2487)tag));
            class_2487 compoundTag2 = null;
            if (((class_2487)tag).method_10545("TileEntityData")) {
                compoundTag2 = (class_2487)((class_2487)tag).method_10562("TileEntityData").get();
            }
            return new BlockValue(bs, compoundTag2);
        }
    }

    public static abstract class StringParam
    extends Param {
        protected StringParam(String id) {
            super(id);
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return class_2519.method_23256((String)value.getString());
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            return new StringValue((String)tag.method_68658().get());
        }
    }

    public static class OptionalBoolListParam
    extends Param {
        public OptionalBoolListParam(String id) {
            super(id);
        }

        @Override
        public class_2520 toTag(Value value, class_5455 regs) {
            return value.toTag(true, regs);
        }

        @Override
        public Value decode(class_2520 tag, class_1937 level) {
            if (tag instanceof class_2499) {
                class_2499 list = (class_2499)tag;
                return ListValue.wrap(list.stream().map(x -> BooleanValue.of(((class_2514)x).method_10697() != 0.0)));
            }
            if (tag instanceof class_2481) {
                class_2481 booltag = (class_2481)tag;
                return BooleanValue.of(booltag.method_10698() != 0);
            }
            return Value.NULL;
        }

        @Override
        public Value validate(Map<String, Value> options, MinecraftServer server, Value value) {
            if (value instanceof AbstractListValue) {
                AbstractListValue lv = (AbstractListValue)value;
                return ListValue.wrap(lv.unpack().stream().map(Value::getBoolean).map(BooleanValue::of));
            }
            if (value instanceof BooleanValue || value.isNull()) {
                return value;
            }
            return BooleanValue.of(value.getBoolean());
        }
    }

    public static class Cylinder
    extends ExpiringShape {
        private final Set<String> required = Set.of("center", "radius");
        private final Map<String, Value> optional = Map.of("level", Value.ZERO, "height", Value.ZERO, "axis", new StringValue("y"));
        class_243 center;
        float height;
        float radius;
        int level;
        int subdivisions;
        class_2350.class_2351 axis;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        private Cylinder() {
        }

        @Override
        protected void init(Map<String, Value> options, class_5455 regs) {
            super.init(options, regs);
            this.center = this.vecFromValue(options.get("center"));
            this.radius = NumericValue.asNumber(options.get("radius")).getFloat();
            this.subdivisions = this.level = NumericValue.asNumber(options.getOrDefault("level", this.optional.get("level"))).getInt();
            if (this.subdivisions <= 0) {
                this.subdivisions = Math.max(10, (int)(10.0 * Math.sqrt(this.radius)));
            }
            this.height = NumericValue.asNumber(options.getOrDefault("height", this.optional.get("height"))).getFloat();
            this.axis = class_2350.class_2351.method_10177((String)options.getOrDefault("axis", this.optional.get("axis")).getString());
        }

        @Override
        public Consumer<class_3222> alternative() {
            return p -> {
                int partno = (int)Math.min(1000.0, Math.sqrt((float)(20 * this.subdivisions) * (1.0f + this.height)));
                class_5819 rand = p.method_37908().method_8409();
                class_3218 world = p.method_51469();
                class_2394 particle = this.replacementParticle(world.method_30349());
                class_243 ccenter = this.relativiseRender((class_1937)world, this.center, 0.0f);
                double ccx = ccenter.field_1352;
                double ccy = ccenter.field_1351;
                double ccz = ccenter.field_1350;
                if (this.axis == class_2350.class_2351.field_11052) {
                    for (int i = 0; i < partno; ++i) {
                        float d = rand.method_43057() * this.height;
                        float phi = (float)(Math.PI * 2 * rand.method_43058());
                        double x = this.radius * class_3532.method_15362((float)phi);
                        double y = d;
                        double z = this.radius * class_3532.method_15374((float)phi);
                        world.method_14166(p, particle, true, true, x + ccx, y + ccy, z + ccz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                } else if (this.axis == class_2350.class_2351.field_11048) {
                    for (int i = 0; i < partno; ++i) {
                        float d = rand.method_43057() * this.height;
                        float phi = (float)(Math.PI * 2 * rand.method_43058());
                        double x = d;
                        double y = this.radius * class_3532.method_15362((float)phi);
                        double z = this.radius * class_3532.method_15374((float)phi);
                        world.method_14166(p, particle, true, true, x + ccx, y + ccy, z + ccz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                } else {
                    for (int i = 0; i < partno; ++i) {
                        float d = rand.method_43057() * this.height;
                        float phi = (float)(Math.PI * 2 * rand.method_43058());
                        double x = this.radius * class_3532.method_15374((float)phi);
                        double y = this.radius * class_3532.method_15362((float)phi);
                        double z = d;
                        world.method_14166(p, particle, true, true, x + ccx, y + ccy, z + ccz, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            };
        }

        @Override
        public long calcKey(class_5455 regs) {
            long hash = super.calcKey(regs);
            hash ^= 4L;
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.center);
            hash *= 1099511628211L;
            hash ^= (long)Double.hashCode(this.radius);
            hash *= 1099511628211L;
            hash ^= (long)Double.hashCode(this.height);
            hash *= 1099511628211L;
            hash ^= (long)this.level;
            return hash *= 1099511628211L;
        }
    }

    public static class Sphere
    extends ExpiringShape {
        private final Set<String> required = Set.of("center", "radius");
        private final Map<String, Value> optional = Map.of("level", Value.ZERO);
        class_243 center;
        float radius;
        int level;
        int subdivisions;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        private Sphere() {
        }

        @Override
        protected void init(Map<String, Value> options, class_5455 regs) {
            super.init(options, regs);
            this.center = this.vecFromValue(options.get("center"));
            this.radius = NumericValue.asNumber(options.get("radius")).getFloat();
            this.subdivisions = this.level = NumericValue.asNumber(options.getOrDefault("level", this.optional.get("level"))).getInt();
            if (this.subdivisions <= 0) {
                this.subdivisions = Math.max(10, (int)(10.0 * Math.sqrt(this.radius)));
            }
        }

        @Override
        public Consumer<class_3222> alternative() {
            return p -> {
                int partno = Math.min(1000, 20 * this.subdivisions);
                class_5819 rand = p.method_37908().method_8409();
                class_3218 world = p.method_51469();
                class_2394 particle = this.replacementParticle(world.method_30349());
                class_243 ccenter = this.relativiseRender((class_1937)world, this.center, 0.0f);
                double ccx = ccenter.field_1352;
                double ccy = ccenter.field_1351;
                double ccz = ccenter.field_1350;
                for (int i = 0; i < partno; ++i) {
                    float theta = (float)Math.asin(rand.method_43058() * 2.0 - 1.0);
                    float phi = (float)(Math.PI * 2 * rand.method_43058());
                    double x = this.radius * class_3532.method_15362((float)theta) * class_3532.method_15362((float)phi);
                    double y = this.radius * class_3532.method_15362((float)theta) * class_3532.method_15374((float)phi);
                    double z = this.radius * class_3532.method_15374((float)theta);
                    world.method_14166(p, particle, true, true, x + ccx, y + ccy, z + ccz, 1, 0.0, 0.0, 0.0, 0.0);
                }
            };
        }

        @Override
        public long calcKey(class_5455 regs) {
            long hash = super.calcKey(regs);
            hash ^= 3L;
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.center);
            hash *= 1099511628211L;
            hash ^= (long)Double.hashCode(this.radius);
            hash *= 1099511628211L;
            hash ^= (long)this.level;
            return hash *= 1099511628211L;
        }
    }

    public static class Line
    extends ExpiringShape {
        private final Set<String> required = Set.of("from", "to");
        private final Map<String, Value> optional = Map.of();
        class_243 from;
        class_243 to;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        private Line() {
        }

        @Override
        protected void init(Map<String, Value> options, class_5455 regs) {
            super.init(options, regs);
            this.from = this.vecFromValue(options.get("from"));
            this.to = this.vecFromValue(options.get("to"));
        }

        @Override
        public Consumer<class_3222> alternative() {
            double density = Math.max(2.0, this.from.method_1022(this.to) / 50.0) / ((double)this.a + 0.1);
            return p -> {
                if (p.method_37908().method_27983() == this.shapeDimension) {
                    ShapeDispatcher.drawParticleLine(Collections.singletonList(p), this.replacementParticle(p.method_37908().method_30349()), this.relativiseRender(p.method_37908(), this.from, 0.0f), this.relativiseRender(p.method_37908(), this.to, 0.0f), density);
                }
            };
        }

        @Override
        public long calcKey(class_5455 regs) {
            long hash = super.calcKey(regs);
            hash ^= 2L;
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.from);
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.to);
            return hash *= 1099511628211L;
        }
    }

    public static class Polyface
    extends ExpiringShape {
        ArrayList<class_243> alterPoint = null;
        final Random random = new Random();
        boolean doublesided;
        private final Set<String> required = Set.of("points");
        private final Map<String, Value> optional = Map.ofEntries(Map.entry("relative", Value.NULL), Map.entry("mode", new StringValue("polygon")), Map.entry("inner", Value.TRUE), Map.entry("doublesided", Value.TRUE));
        ArrayList<class_243> vertexList = new ArrayList();
        int mode;
        ArrayList<Boolean> relative = new ArrayList();
        boolean inneredges;

        @Override
        public long calcKey(class_5455 regs) {
            long hash = super.calcKey(regs);
            hash ^= 6L;
            hash *= 1099511628211L;
            hash ^= (long)this.mode;
            hash *= 1099511628211L;
            hash ^= (long)this.relative.hashCode();
            hash *= 1099511628211L;
            for (class_243 i : this.vertexList) {
                hash ^= (long)this.vec3dhash(i);
                hash *= 1099511628211L;
            }
            hash ^= (long)Boolean.hashCode(this.doublesided);
            hash *= 1099511628211L;
            hash ^= (long)Integer.hashCode(this.vertexList.size());
            hash *= 1099511628211L;
            hash ^= (long)Boolean.hashCode(this.inneredges);
            return hash *= 1099511628211L;
        }

        ArrayList<class_243> getAlterPoint(class_3222 p) {
            if (this.alterPoint != null) {
                return this.alterPoint;
            }
            this.alterPoint = new ArrayList();
            switch (this.mode) {
                case 4: {
                    for (int i = 0; i < this.vertexList.size(); ++i) {
                        class_243 vecA = this.vertexList.get(i);
                        if (this.relative.get(i).booleanValue()) {
                            vecA = this.relativiseRender(p.method_37908(), vecA, 0.0f);
                        }
                        class_243 vecB = this.vertexList.get(++i);
                        if (this.relative.get(i).booleanValue()) {
                            vecB = this.relativiseRender(p.method_37908(), vecB, 0.0f);
                        }
                        class_243 vecC = this.vertexList.get(++i);
                        if (this.relative.get(i).booleanValue()) {
                            vecC = this.relativiseRender(p.method_37908(), vecC, 0.0f);
                        }
                        this.alterDrawTriangles(vecA, vecB, vecC);
                    }
                    break;
                }
                case 6: {
                    class_243 vec0 = this.vertexList.get(0);
                    if (this.relative.get(0).booleanValue()) {
                        vec0 = this.relativiseRender(p.method_37908(), vec0, 0.0f);
                    }
                    class_243 vec1 = this.vertexList.get(1);
                    if (this.relative.get(1).booleanValue()) {
                        vec1 = this.relativiseRender(p.method_37908(), vec1, 0.0f);
                    }
                    for (int i = 2; i < this.vertexList.size(); ++i) {
                        class_243 vec = this.vertexList.get(i);
                        if (this.relative.get(i).booleanValue()) {
                            vec = this.relativiseRender(p.method_37908(), vec, 0.0f);
                        }
                        this.alterDrawTriangles(vec0, vec1, vec);
                        vec1 = vec;
                    }
                    break;
                }
                case 5: {
                    class_243 vecA = this.vertexList.get(0);
                    if (this.relative.get(0).booleanValue()) {
                        vecA = this.relativiseRender(p.method_37908(), vecA, 0.0f);
                    }
                    class_243 vecB = this.vertexList.get(1);
                    if (this.relative.get(1).booleanValue()) {
                        vecB = this.relativiseRender(p.method_37908(), vecB, 0.0f);
                    }
                    for (int i = 2; i < this.vertexList.size(); ++i) {
                        class_243 vec = this.vertexList.get(i);
                        if (this.relative.get(i).booleanValue()) {
                            vec = this.relativiseRender(p.method_37908(), vec, 0.0f);
                        }
                        this.alterDrawTriangles(vecA, vecB, vec);
                        vecA = vecB;
                        vecB = vec;
                    }
                    break;
                }
            }
            return this.alterPoint;
        }

        void alterDrawTriangles(class_243 a, class_243 b, class_243 c) {
            class_243 bb = b.method_1020(a);
            class_243 cc = c.method_1020(a);
            int i = 0;
            while ((double)(i / 8) < bb.method_1036(cc).method_1033()) {
                double x = this.random.nextDouble();
                double y = this.random.nextDouble();
                this.alterPoint.add(a.method_1019(bb.method_1021(x / 2.0)).method_1019(cc.method_1021(y / 2.0)));
                if (x + y < 1.0) {
                    this.alterPoint.add(a.method_1019(bb.method_1021((x + 1.0) / 2.0)).method_1019(cc.method_1021(y / 2.0)));
                } else {
                    x = 1.0 - x;
                    y = 1.0 - y;
                    this.alterPoint.add(a.method_1019(bb.method_1021(x / 2.0)).method_1019(cc.method_1021((y + 1.0) / 2.0)));
                }
                ++i;
            }
        }

        @Override
        public Consumer<class_3222> alternative() {
            return p -> {
                if (p.method_37908().method_27983() != this.shapeDimension) {
                    return;
                }
                if (this.fa > 0.0f) {
                    class_2390 locparticledata = new class_2390(class_9848.method_61318((float)1.0f, (float)this.fr, (float)this.fg, (float)this.fb), 1.0f);
                    for (class_243 v : this.getAlterPoint((class_3222)p)) {
                        p.method_51469().method_14166(p, (class_2394)locparticledata, true, true, v.field_1352, v.field_1351, v.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
                    }
                }
            };
        }

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        @Override
        protected void init(Map<String, Value> options, class_5455 regs) {
            super.init(options, regs);
            this.doublesided = options.getOrDefault("doublesided", this.optional.get("doublesided")).getBoolean();
            Value value = options.get("points");
            if (value instanceof AbstractListValue) {
                AbstractListValue abl = (AbstractListValue)value;
                abl.forEach(x -> this.vertexList.add(this.vecFromValue((Value)x)));
            }
            String modeOption = options.getOrDefault("mode", this.optional.get("mode")).getString();
            this.inneredges = options.getOrDefault("inner", this.optional.get("inner")).getBoolean();
            if (this.vertexList.size() < 3) {
                throw new IllegalArgumentException("Unexpected vertex list size: " + this.vertexList.size());
            }
            if (this.vertexList.size() < 4) {
                this.inneredges = false;
            }
            if ("polygon".equals(modeOption)) {
                this.mode = 6;
            } else if ("strip".equals(modeOption)) {
                this.mode = 5;
            } else if ("triangles".equals(modeOption)) {
                this.mode = 4;
                if (this.vertexList.size() % 3 != 0) {
                    throw new IllegalArgumentException("Unexpected vertex list size: " + this.vertexList.size());
                }
            }
            Value value2 = options.getOrDefault("relative", this.optional.get("relative"));
            if (value2 instanceof AbstractListValue) {
                AbstractListValue abl = (AbstractListValue)value2;
                it = abl.iterator();
                for (long i = 0L; i < (long)this.vertexList.size(); ++i) {
                    this.relative.add(it.hasNext() && ((Value)it.next()).getBoolean());
                }
            } else {
                it = options.getOrDefault("relative", this.optional.get("relative"));
                if (it instanceof BooleanValue) {
                    BooleanValue boolv = (BooleanValue)it;
                    for (long i = 0L; i < (long)this.vertexList.size(); ++i) {
                        this.relative.add(boolv.getBoolean());
                    }
                } else {
                    for (long i = 0L; i < (long)this.vertexList.size(); ++i) {
                        this.relative.add(true);
                    }
                }
            }
        }
    }

    public static class Box
    extends ExpiringShape {
        private final Set<String> required = Set.of("from", "to");
        private final Map<String, Value> optional = Map.of();
        class_243 from;
        class_243 to;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        @Override
        protected void init(Map<String, Value> options, class_5455 regs) {
            super.init(options, regs);
            this.from = this.vecFromValue(options.get("from"));
            this.to = this.vecFromValue(options.get("to"));
        }

        @Override
        public Consumer<class_3222> alternative() {
            double density = Math.max(2.0, this.from.method_1022(this.to) / 50.0 / ((double)this.a + 0.1));
            return p -> {
                if (p.method_37908().method_27983() == this.shapeDimension) {
                    Box.particleMesh(Collections.singletonList(p), this.replacementParticle(p.method_37908().method_30349()), density, this.relativiseRender(p.method_37908(), this.from, 0.0f), this.relativiseRender(p.method_37908(), this.to, 0.0f));
                }
            };
        }

        @Override
        public long calcKey(class_5455 regs) {
            long hash = super.calcKey(regs);
            hash ^= 1L;
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.from);
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.to);
            return hash *= 1099511628211L;
        }

        public static int particleMesh(List<class_3222> playerList, class_2394 particle, double density, class_243 from, class_243 to) {
            double x1 = from.field_1352;
            double y1 = from.field_1351;
            double z1 = from.field_1350;
            double x2 = to.field_1352;
            double y2 = to.field_1351;
            double z2 = to.field_1350;
            return ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y1, z1), new class_243(x1, y2, z1), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y2, z1), new class_243(x2, y2, z1), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y2, z1), new class_243(x2, y1, z1), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y1, z1), new class_243(x1, y1, z1), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y1, z2), new class_243(x1, y2, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y2, z2), new class_243(x2, y2, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y2, z2), new class_243(x2, y1, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y1, z2), new class_243(x1, y1, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y1, z1), new class_243(x1, y1, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x1, y2, z1), new class_243(x1, y2, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y2, z1), new class_243(x2, y2, z2), density) + ShapeDispatcher.drawParticleLine(playerList, particle, new class_243(x2, y1, z1), new class_243(x2, y1, z2), density);
        }
    }

    public static class DisplayedSprite
    extends ExpiringShape {
        private final Set<String> required = Set.of("pos");
        private final Map<String, Value> optional = Map.ofEntries(Map.entry("facing", new StringValue("north")), Map.entry("tilt", new NumericValue(0L)), Map.entry("lean", new NumericValue(0L)), Map.entry("turn", new NumericValue(0L)), Map.entry("scale", ListValue.fromTriple(1, 1, 1)), Map.entry("blocklight", new NumericValue(-1L)), Map.entry("skylight", new NumericValue(-1L)));
        private final boolean isitem;
        class_243 pos;
        ShapeDirection facing;
        float tilt;
        float lean;
        float turn;
        int blockLight;
        int skyLight;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        float scaleZ = 1.0f;
        class_2487 blockEntity;
        class_2680 blockState;
        class_1799 item = null;
        String itemTransformType;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union((Set)Sets.union(super.requiredParams(), this.required), Set.of(this.isitem ? "item" : "block"));
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union((Set)Sets.union(super.optionalParams(), this.optional.keySet()), this.isitem ? Set.of("variant") : Set.of());
        }

        public DisplayedSprite(boolean i) {
            this.isitem = i;
        }

        @Override
        protected void init(Map<String, Value> options, class_5455 regs) {
            super.init(options, regs);
            this.pos = this.vecFromValue(options.get("pos"));
            if (!this.isitem) {
                BlockValue block = (BlockValue)options.get("block");
                this.blockState = block.getBlockState();
                this.blockEntity = block.getData();
            } else {
                this.item = class_1799.field_24671.parse((DynamicOps)regs.method_57093((DynamicOps)class_2509.field_11560), (Object)((NBTSerializableValue)options.get("item")).getCompoundTag()).result().orElse(null);
            }
            this.blockLight = NumericValue.asNumber(options.getOrDefault("blocklight", this.optional.get("blocklight"))).getInt();
            if (this.blockLight > 15) {
                this.blockLight = 15;
            }
            this.skyLight = NumericValue.asNumber(options.getOrDefault("skylight", this.optional.get("skylight"))).getInt();
            if (this.skyLight > 15) {
                this.skyLight = 15;
            }
            this.itemTransformType = "none";
            if (options.containsKey("variant")) {
                this.itemTransformType = options.get("variant").getString().toLowerCase(Locale.ROOT);
            }
            String dir = options.getOrDefault("facing", this.optional.get("facing")).getString();
            this.facing = ShapeDirection.fromString(dir);
            this.tilt = NumericValue.asNumber(options.getOrDefault("tilt", this.optional.get("tilt"))).getFloat();
            this.lean = NumericValue.asNumber(options.getOrDefault("lean", this.optional.get("lean"))).getFloat();
            this.turn = NumericValue.asNumber(options.getOrDefault("turn", this.optional.get("turn"))).getFloat();
            List<Value> scale = ((ListValue)options.getOrDefault("scale", this.optional.get("scale"))).unpack();
            this.scaleY = NumericValue.asNumber(scale.get(1)).getFloat();
            this.scaleX = NumericValue.asNumber(scale.get(0)).getFloat();
            this.scaleZ = NumericValue.asNumber(scale.get(2)).getFloat();
        }

        @Override
        public Consumer<class_3222> alternative() {
            return p -> {
                class_2394 particle;
                class_2378 blocks = p.method_5682().method_30611().method_30530(class_7924.field_41254);
                if (this.isitem) {
                    if (class_2248.method_9503((class_1792)this.item.method_7909()).method_9564().method_26215()) {
                        return;
                    }
                    particle = ShapeDispatcher.getParticleData("block_marker " + String.valueOf(blocks.method_10221((Object)class_2248.method_9503((class_1792)this.item.method_7909()))), p.method_37908().method_30349());
                } else {
                    particle = ShapeDispatcher.getParticleData("block_marker " + String.valueOf(blocks.method_10221((Object)this.blockState.method_26204())), p.method_37908().method_30349());
                }
                class_243 v = this.relativiseRender(p.method_37908(), this.pos, 0.0f);
                p.method_51469().method_14166(p, particle, true, true, v.field_1352, v.field_1351, v.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            };
        }

        @Override
        public long calcKey(class_5455 regs) {
            long hash = super.calcKey(regs);
            hash ^= 7L;
            hash *= 1099511628211L;
            hash ^= (long)Boolean.hashCode(this.isitem);
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.pos);
            hash *= 1099511628211L;
            if (this.facing != null) {
                hash ^= (long)this.facing.hashCode();
            }
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.tilt);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.lean);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.turn);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.scaleY);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.scaleZ);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.scaleX);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.skyLight);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.blockLight);
            hash *= 1099511628211L;
            if (this.blockEntity != null) {
                hash ^= (long)this.blockEntity.toString().hashCode();
            }
            hash *= 1099511628211L;
            if (this.blockState != null) {
                hash ^= (long)this.blockState.hashCode();
            }
            hash *= 1099511628211L;
            hash ^= (long)ValueConversions.of(this.item, regs).getString().hashCode();
            hash *= 1099511628211L;
            hash ^= (long)this.itemTransformType.hashCode();
            return hash *= 1099511628211L;
        }
    }

    public static class DisplayedText
    extends ExpiringShape {
        private final Set<String> required = Set.of("pos", "text");
        private final Map<String, Value> optional = Map.ofEntries(Map.entry("facing", new StringValue("player")), Map.entry("raise", new NumericValue(0L)), Map.entry("tilt", new NumericValue(0L)), Map.entry("lean", new NumericValue(0L)), Map.entry("turn", new NumericValue(0L)), Map.entry("indent", new NumericValue(0L)), Map.entry("height", new NumericValue(0L)), Map.entry("align", new StringValue("center")), Map.entry("size", new NumericValue(10L)), Map.entry("value", Value.NULL), Map.entry("doublesided", new NumericValue(0L)));
        class_243 pos;
        String text;
        int textcolor;
        int textbck;
        ShapeDirection facing;
        float raise;
        float tilt;
        float lean;
        float turn;
        float size;
        float indent;
        int align;
        float height;
        class_2561 value;
        boolean doublesided;

        @Override
        protected Set<String> requiredParams() {
            return Sets.union(super.requiredParams(), this.required);
        }

        @Override
        protected Set<String> optionalParams() {
            return Sets.union(super.optionalParams(), this.optional.keySet());
        }

        @Override
        protected void init(Map<String, Value> options, class_5455 regs) {
            super.init(options, regs);
            this.pos = this.vecFromValue(options.get("pos"));
            this.value = ((FormattedTextValue)options.get("text")).getText();
            this.text = this.value.getString();
            if (options.containsKey("value")) {
                this.value = ((FormattedTextValue)options.get("value")).getText();
            }
            this.textcolor = this.rgba2argb(this.color);
            this.textbck = this.rgba2argb(this.fillColor);
            String dir = options.getOrDefault("facing", this.optional.get("facing")).getString();
            this.facing = ShapeDirection.fromString(dir);
            this.align = 0;
            if (options.containsKey("align")) {
                String alignStr = options.get("align").getString();
                if ("right".equalsIgnoreCase(alignStr)) {
                    this.align = 1;
                } else if ("left".equalsIgnoreCase(alignStr)) {
                    this.align = -1;
                }
            }
            this.doublesided = false;
            if (options.containsKey("doublesided")) {
                this.doublesided = options.get("doublesided").getBoolean();
            }
            this.raise = NumericValue.asNumber(options.getOrDefault("raise", this.optional.get("raise"))).getFloat();
            this.tilt = NumericValue.asNumber(options.getOrDefault("tilt", this.optional.get("tilt"))).getFloat();
            this.lean = NumericValue.asNumber(options.getOrDefault("lean", this.optional.get("lean"))).getFloat();
            this.turn = NumericValue.asNumber(options.getOrDefault("turn", this.optional.get("turn"))).getFloat();
            this.indent = NumericValue.asNumber(options.getOrDefault("indent", this.optional.get("indent"))).getFloat();
            this.height = NumericValue.asNumber(options.getOrDefault("height", this.optional.get("height"))).getFloat();
            this.size = NumericValue.asNumber(options.getOrDefault("size", this.optional.get("size"))).getFloat();
        }

        private int rgba2argb(int color) {
            int r = Math.max(1, color >> 24 & 0xFF);
            int g = Math.max(1, color >> 16 & 0xFF);
            int b = Math.max(1, color >> 8 & 0xFF);
            int a = color & 0xFF;
            return (a << 24) + (r << 16) + (g << 8) + b;
        }

        @Override
        public Consumer<class_3222> alternative() {
            return s -> {};
        }

        @Override
        public long calcKey(class_5455 regs) {
            long hash = super.calcKey(regs);
            hash ^= 5L;
            hash *= 1099511628211L;
            hash ^= (long)this.vec3dhash(this.pos);
            hash *= 1099511628211L;
            hash ^= (long)this.text.hashCode();
            hash *= 1099511628211L;
            if (this.facing != null) {
                hash ^= (long)this.facing.hashCode();
            }
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.raise);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.tilt);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.lean);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.turn);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.indent);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.height);
            hash *= 1099511628211L;
            hash ^= (long)Float.hashCode(this.size);
            hash *= 1099511628211L;
            hash ^= (long)Integer.hashCode(this.align);
            hash *= 1099511628211L;
            hash ^= (long)Boolean.hashCode(this.doublesided);
            return hash *= 1099511628211L;
        }
    }
}

