/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.script.CarpetContext;
import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.ScriptHost;
import carpet.script.exception.IntegrityException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.InvalidCallbackException;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.utils.GlocalFlag;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3445;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_3988;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class CarpetEventServer {
    public final List<ScheduledCall> scheduledCalls = new LinkedList<ScheduledCall>();
    public final CarpetScriptServer scriptServer;
    private static final List<Value> NOARGS = Collections.emptyList();
    public final Map<String, Event> customEvents = new HashMap<String, Event>();
    public GlocalFlag handleEvents = new GlocalFlag(true);

    public CarpetEventServer(CarpetScriptServer scriptServer) {
        this.scriptServer = scriptServer;
        Event.clearAllBuiltinEvents();
    }

    public void tick() {
        if (!this.scriptServer.server.method_54833().method_54751()) {
            return;
        }
        Iterator<ScheduledCall> eventIterator = this.scheduledCalls.iterator();
        ArrayList<ScheduledCall> currentCalls = new ArrayList<ScheduledCall>();
        while (eventIterator.hasNext()) {
            ScheduledCall call = eventIterator.next();
            --call.dueTime;
            if (call.dueTime > 0L) continue;
            currentCalls.add(call);
            eventIterator.remove();
        }
        for (ScheduledCall call : currentCalls) {
            call.execute();
        }
    }

    public void scheduleCall(CarpetContext context, FunctionValue function, List<Value> args, long due) {
        this.scheduledCalls.add(new ScheduledCall(context, function, args, due));
    }

    public void runScheduledCall(class_2338 origin, class_2168 source, String hostname, CarpetScriptHost host, FunctionValue udf, List<Value> argv) {
        if (hostname != null && !this.scriptServer.modules.containsKey(hostname)) {
            return;
        }
        try {
            host.callUDF(origin, source, udf, argv);
        }
        catch (IntegrityException | InvalidCallbackException | NullPointerException exception) {
            // empty catch block
        }
    }

    public CallbackResult runEventCall(class_2168 sender, String hostname, String optionalTarget, FunctionValue udf, List<Value> argv) {
        CarpetScriptHost appHost = this.scriptServer.getAppHostByName(hostname);
        if (appHost == null) {
            return CallbackResult.FAIL;
        }
        if (appHost.isPerUser() && optionalTarget == null) {
            return CallbackResult.PASS;
        }
        class_3222 target = null;
        if (optionalTarget != null && (target = sender.method_9211().method_3760().method_14566(optionalTarget)) == null) {
            return CallbackResult.FAIL;
        }
        class_2168 source = sender.method_9206(Vanilla.MinecraftServer_getRunPermissionLevel(sender.method_9211()));
        CarpetScriptHost executingHost = appHost.retrieveForExecution(sender, target);
        if (executingHost == null) {
            return CallbackResult.FAIL;
        }
        try {
            Value returnValue = executingHost.callUDF(source, udf, argv);
            return returnValue instanceof StringValue && returnValue.getString().equals("cancel") ? CallbackResult.CANCEL : CallbackResult.SUCCESS;
        }
        catch (IntegrityException | InvalidCallbackException | NullPointerException error) {
            CarpetScriptServer.LOG.error("Got exception when running event call ", (Throwable)error);
            return CallbackResult.FAIL;
        }
    }

    public boolean addEventFromCommand(class_2168 source, String event, String host, String funName) {
        Event ev = Event.getEvent(event, this.scriptServer);
        if (ev == null) {
            return false;
        }
        boolean added = ev.handler.addFromExternal(source, host, funName, h -> this.onEventAddedToHost(ev, (ScriptHost)h), this.scriptServer);
        if (added) {
            Carpet.Messenger_message(source, "gi Added " + funName + " to " + event);
        }
        return added;
    }

    public void addBuiltInEvent(String event, ScriptHost host, FunctionValue function, List<Value> args) {
        Event ev = Event.byName.get(event);
        this.onEventAddedToHost(ev, host);
        boolean success = ev.handler.addEventCallInternal(host, function, args == null ? NOARGS : args);
        if (!success) {
            throw new InternalExpressionException("Global event " + event + " requires " + ev.handler.reqArgs + ", not " + (function.getNumParams() - (args == null ? 0 : args.size())));
        }
    }

    public boolean handleCustomEvent(String event, CarpetScriptHost host, FunctionValue function, List<Value> args) {
        Event ev = Event.getOrCreateCustom(event, this.scriptServer);
        this.onEventAddedToHost(ev, host);
        return ev.handler.addEventCallInternal(host, function, args == null ? NOARGS : args);
    }

    public int signalEvent(String event, CarpetContext cc, @Nullable class_3222 target, List<Value> callArgs) {
        Event ev = Event.getEvent(event, ((CarpetScriptHost)cc.host).scriptServer());
        return ev == null ? -1 : ev.handler.signal(cc.source(), target, callArgs);
    }

    private void onEventAddedToHost(Event event, ScriptHost host) {
        if (event.deprecated()) {
            host.issueDeprecation(event.name + " event");
        }
        event.handler.sortByPriority(this.scriptServer);
    }

    public boolean removeEventFromCommand(class_2168 source, String event, String funName) {
        Event ev = Event.getEvent(event, this.scriptServer);
        if (ev == null) {
            Carpet.Messenger_message(source, "r Unknown event: " + event);
            return false;
        }
        Callback.Signature call = Callback.fromString(funName);
        ev.handler.removeEventCall(call.host, call.target, call.function);
        Carpet.Messenger_message(source, "gi Removed event: " + funName + " from " + event);
        return true;
    }

    public boolean removeBuiltInEvent(String event, CarpetScriptHost host) {
        Event ev = Event.getEvent(event, host.scriptServer());
        if (ev == null) {
            return false;
        }
        ev.handler.removeAllCalls(host);
        return true;
    }

    public void removeBuiltInEvent(String event, CarpetScriptHost host, String funName) {
        Event ev = Event.getEvent(event, host.scriptServer());
        if (ev != null) {
            ev.handler.removeEventCall(host.getName(), host.user, funName);
        }
    }

    public void removeAllHostEvents(CarpetScriptHost host) {
        Event.removeAllHostEvents(host);
        if (host.isPerUser()) {
            for (ScriptHost child : host.userHosts.values()) {
                Event.removeAllHostEvents((CarpetScriptHost)child);
            }
        }
        this.scheduledCalls.removeIf(sc -> sc.host != null && sc.host.equals(host.getName()));
    }

    public static class Event {
        public static final Map<String, Event> byName = new HashMap<String, Event>();
        public static final Event START;
        public static final Event SHUTDOWN;
        public static final Event TICK;
        public static final Event NETHER_TICK;
        public static final Event ENDER_TICK;
        public static final Event CHUNK_GENERATED;
        public static final Event CHUNK_LOADED;
        public static final Event CHUNK_UNLOADED;
        public static final Event PLAYER_JUMPS;
        public static final Event PLAYER_DEPLOYS_ELYTRA;
        public static final Event PLAYER_WAKES_UP;
        public static final Event PLAYER_ESCAPES_SLEEP;
        public static final Event PLAYER_RIDES;
        public static final Event PLAYER_USES_ITEM;
        public static final Event PLAYER_CLICKS_BLOCK;
        public static final Event PLAYER_RIGHT_CLICKS_BLOCK;
        public static final Event PLAYER_INTERACTS_WITH_BLOCK;
        public static final Event PLAYER_PLACING_BLOCK;
        public static final Event PLAYER_PLACES_BLOCK;
        public static final Event PLAYER_BREAK_BLOCK;
        public static final Event PLAYER_INTERACTS_WITH_ENTITY;
        public static final Event PLAYER_TRADES;
        public static final Event PLAYER_PICKS_UP_ITEM;
        public static final Event PLAYER_ATTACKS_ENTITY;
        public static final Event PLAYER_STARTS_SNEAKING;
        public static final Event PLAYER_STOPS_SNEAKING;
        public static final Event PLAYER_STARTS_SPRINTING;
        public static final Event PLAYER_STOPS_SPRINTING;
        public static final Event PLAYER_RELEASED_ITEM;
        public static final Event PLAYER_FINISHED_USING_ITEM;
        public static final Event PLAYER_DROPS_ITEM;
        public static final Event PLAYER_DROPS_STACK;
        public static final Event PLAYER_CHOOSES_RECIPE;
        public static final Event PLAYER_SWITCHES_SLOT;
        public static final Event PLAYER_SWAPS_HANDS;
        public static final Event PLAYER_SWINGS_HAND;
        public static final Event PLAYER_TAKES_DAMAGE;
        public static final Event PLAYER_DEALS_DAMAGE;
        public static final Event PLAYER_COLLIDES_WITH_ENTITY;
        public static final Event PLAYER_DIES;
        public static final Event PLAYER_RESPAWNS;
        public static final Event PLAYER_CHANGES_DIMENSION;
        public static final Event PLAYER_CONNECTS;
        public static final Event PLAYER_DISCONNECTS;
        public static final Event PLAYER_MESSAGE;
        public static final Event PLAYER_COMMAND;
        public static final Event STATISTICS;
        public static final Event LIGHTNING;
        public static final Event EXPLOSION_OUTCOME;
        public static final Event EXPLOSION;
        @Deprecated
        public static final Map<class_1299<? extends class_1297>, Event> ENTITY_LOAD;
        public static final Map<class_1299<? extends class_1297>, Event> ENTITY_HANDLER;
        public final String name;
        public final CallbackList handler;
        public final boolean isPublic;

        public static List<Event> publicEvents(CarpetScriptServer server) {
            List<Event> events = byName.values().stream().filter(e -> e.isPublic).collect(Collectors.toList());
            if (server != null) {
                events.addAll(server.events.customEvents.values());
            }
            return events;
        }

        private static class_1309 getExplosionCausingEntity(class_1297 entity) {
            class_1676 p;
            class_1297 owner;
            if (entity == null) {
                return null;
            }
            if (entity instanceof class_1541) {
                class_1541 tnt = (class_1541)entity;
                return tnt.method_6970();
            }
            if (entity instanceof class_1309) {
                class_1309 le = (class_1309)entity;
                return le;
            }
            if (entity instanceof class_1676 && (owner = (p = (class_1676)entity).method_24921()) instanceof class_1309) {
                class_1309 le = (class_1309)owner;
                return le;
            }
            return null;
        }

        @Deprecated
        public static String getEntityLoadEventName(class_1299<? extends class_1297> et) {
            return "entity_loaded_" + ValueConversions.of(class_7923.field_41177.method_10221(et)).getString();
        }

        public static String getEntityHandlerEventName(class_1299<? extends class_1297> et) {
            return "entity_handler_" + ValueConversions.of(class_7923.field_41177.method_10221(et)).getString();
        }

        public Event(String name, int reqArgs, boolean isGlobalOnly) {
            this(name, reqArgs, isGlobalOnly, true);
        }

        public Event(String name, int reqArgs, boolean isGlobalOnly, boolean isPublic) {
            this.name = name;
            this.handler = new CallbackList(reqArgs, true, isGlobalOnly);
            this.isPublic = isPublic;
            byName.put(name, this);
        }

        public static List<Event> getAllEvents(CarpetScriptServer server, Predicate<Event> predicate) {
            ArrayList<Event> eventList = new ArrayList<Event>(byName.values());
            eventList.addAll(server.events.customEvents.values());
            if (predicate == null) {
                return eventList;
            }
            return eventList.stream().filter(predicate).toList();
        }

        public static Event getEvent(String name, CarpetScriptServer server) {
            if (byName.containsKey(name)) {
                return byName.get(name);
            }
            return server.events.customEvents.get(name);
        }

        public static Event getOrCreateCustom(String name, CarpetScriptServer server) {
            Event event = Event.getEvent(name, server);
            if (event != null) {
                return event;
            }
            return new Event(name, server);
        }

        public static void removeAllHostEvents(CarpetScriptHost host) {
            byName.values().forEach(e -> e.handler.removeAllCalls(host));
            host.scriptServer().events.customEvents.values().forEach(e -> e.handler.removeAllCalls(host));
        }

        public static void transferAllHostEventsToChild(CarpetScriptHost host) {
            byName.values().forEach(e -> e.handler.createChildEvents(host));
            host.scriptServer().events.customEvents.values().forEach(e -> e.handler.createChildEvents(host));
        }

        public static void clearAllBuiltinEvents() {
            byName.values().forEach(e -> e.handler.clearEverything());
        }

        private Event(String name, CarpetScriptServer server) {
            this.name = name;
            this.handler = new CallbackList(1, false, false);
            this.isPublic = true;
            server.events.customEvents.put(name, this);
        }

        public boolean isNeeded() {
            return this.handler.callList.size() > 0;
        }

        public boolean deprecated() {
            return false;
        }

        public void onTick(MinecraftServer server) {
        }

        public void onChunkEvent(class_3218 world, class_1923 chPos, boolean generated) {
        }

        public boolean onPlayerEvent(class_3222 player) {
            return false;
        }

        public boolean onPlayerMessage(class_3222 player, String message) {
            return false;
        }

        public void onPlayerStatistic(class_3222 player, class_3445<?> stat, int amount) {
        }

        public void onMountControls(class_3222 player, float strafeSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
        }

        public boolean onItemAction(class_3222 player, class_1268 enumhand, class_1799 itemstack) {
            return false;
        }

        public boolean onBlockAction(class_3222 player, class_2338 blockpos, class_2350 facing) {
            return false;
        }

        public boolean onBlockHit(class_3222 player, class_1268 enumhand, class_3965 hitRes) {
            return false;
        }

        public boolean onBlockBroken(class_3222 player, class_2338 pos, class_2680 previousBS) {
            return false;
        }

        public boolean onBlockPlaced(class_3222 player, class_2338 pos, class_1268 enumhand, class_1799 itemstack) {
            return false;
        }

        public boolean onEntityHandAction(class_3222 player, class_1297 entity, class_1268 enumhand) {
            return false;
        }

        public void onHandAction(class_3222 player, class_1268 enumhand) {
        }

        public void onEntityAction(class_1297 entity, boolean created) {
        }

        public void onDimensionChange(class_3222 player, class_243 from, class_243 to, class_5321<class_1937> fromDim, class_5321<class_1937> dimTo) {
        }

        public boolean onDamage(class_1297 target, float amount, class_1282 source) {
            return false;
        }

        public boolean onRecipeSelected(class_3222 player, class_2960 recipe, boolean fullStack) {
            return false;
        }

        public void onSlotSwitch(class_3222 player, int from, int to) {
        }

        public void onTrade(class_3222 player, class_1915 merchant, class_1914 tradeOffer) {
        }

        public boolean onExplosion(class_3218 world, class_1297 e, Supplier<class_1309> attacker, class_243 center, float power, boolean createFire, List<class_2338> affectedBlocks, List<class_1297> affectedEntities, class_1927.class_4179 type) {
            return false;
        }

        public void onWorldEvent(class_3218 world, class_2338 pos) {
        }

        public void onWorldEventFlag(class_3218 world, class_2338 pos, int flag) {
        }

        public void handleAny(Object ... args) {
        }

        public void onCustomPlayerEvent(class_3222 player, Object ... args) {
            if (this.handler.reqArgs != args.length + 1) {
                throw new InternalExpressionException("Expected " + this.handler.reqArgs + " arguments for " + this.name + ", got " + (args.length + 1));
            }
            this.handler.call(() -> {
                ArrayList<Value> valArgs = new ArrayList<Value>();
                valArgs.add(EntityValue.of((class_1297)player));
                for (Object o : args) {
                    valArgs.add(ValueConversions.guess(player.method_51469(), o));
                }
                return valArgs;
            }, () -> ((class_3222)player).method_64396());
        }

        public void onCustomWorldEvent(class_3218 world, Object ... args) {
            if (this.handler.reqArgs != args.length) {
                throw new InternalExpressionException("Expected " + this.handler.reqArgs + " arguments for " + this.name + ", got " + args.length);
            }
            this.handler.call(() -> {
                ArrayList<Value> valArgs = new ArrayList<Value>();
                for (Object o : args) {
                    valArgs.add(ValueConversions.guess(world, o));
                }
                return valArgs;
            }, () -> world.method_8503().method_3739().method_9227(world));
        }

        static {
            Carpet.initCarpetEvents();
            START = new Event("server_starts", 0, true){

                @Override
                public void onTick(MinecraftServer server) {
                    this.handler.call(Collections::emptyList, () -> ((MinecraftServer)server).method_3739());
                }
            };
            SHUTDOWN = new Event("server_shuts_down", 0, true){

                @Override
                public void onTick(MinecraftServer server) {
                    this.handler.call(Collections::emptyList, () -> ((MinecraftServer)server).method_3739());
                }
            };
            TICK = new Event("tick", 0, true){

                @Override
                public void onTick(MinecraftServer server) {
                    this.handler.call(Collections::emptyList, () -> ((MinecraftServer)server).method_3739());
                }
            };
            NETHER_TICK = new Event("tick_nether", 0, true){

                @Override
                public boolean deprecated() {
                    return true;
                }

                @Override
                public void onTick(MinecraftServer server) {
                    this.handler.call(Collections::emptyList, () -> server.method_3739().method_9227(server.method_3847(class_1937.field_25180)));
                }
            };
            ENDER_TICK = new Event("tick_ender", 0, true){

                @Override
                public boolean deprecated() {
                    return true;
                }

                @Override
                public void onTick(MinecraftServer server) {
                    this.handler.call(Collections::emptyList, () -> server.method_3739().method_9227(server.method_3847(class_1937.field_25181)));
                }
            };
            CHUNK_GENERATED = new Event("chunk_generated", 2, true){

                @Override
                public void onChunkEvent(class_3218 world, class_1923 chPos, boolean generated) {
                    this.handler.call(() -> Arrays.asList(new NumericValue(chPos.field_9181 << 4), new NumericValue(chPos.field_9180 << 4)), () -> world.method_8503().method_3739().method_9227(world));
                }
            };
            CHUNK_LOADED = new Event("chunk_loaded", 2, true){

                @Override
                public void onChunkEvent(class_3218 world, class_1923 chPos, boolean generated) {
                    this.handler.call(() -> Arrays.asList(new NumericValue(chPos.field_9181 << 4), new NumericValue(chPos.field_9180 << 4)), () -> world.method_8503().method_3739().method_9227(world));
                }
            };
            CHUNK_UNLOADED = new Event("chunk_unloaded", 2, true){

                @Override
                public void onChunkEvent(class_3218 world, class_1923 chPos, boolean generated) {
                    this.handler.call(() -> Arrays.asList(new NumericValue(chPos.field_9181 << 4), new NumericValue(chPos.field_9180 << 4)), () -> world.method_8503().method_3739().method_9227(world));
                }
            };
            PLAYER_JUMPS = new Event("player_jumps", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_DEPLOYS_ELYTRA = new Event("player_deploys_elytra", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_WAKES_UP = new Event("player_wakes_up", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_ESCAPES_SLEEP = new Event("player_escapes_sleep", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_RIDES = new Event("player_rides", 5, false){

                @Override
                public void onMountControls(class_3222 player, float strafeSpeed, float forwardSpeed, boolean jumping, boolean sneaking) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new NumericValue(forwardSpeed), new NumericValue(strafeSpeed), BooleanValue.of(jumping), BooleanValue.of(sneaking)), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_USES_ITEM = new Event("player_uses_item", 3, false){

                @Override
                public boolean onItemAction(class_3222 player, class_1268 enumhand, class_1799 itemstack) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ValueConversions.of(itemstack, player.method_37908().method_30349()), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand")), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_CLICKS_BLOCK = new Event("player_clicks_block", 3, false){

                @Override
                public boolean onBlockAction(class_3222 player, class_2338 blockpos, class_2350 facing) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new BlockValue(null, player.method_51469(), blockpos), StringValue.of(facing.method_10151())), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_RIGHT_CLICKS_BLOCK = new Event("player_right_clicks_block", 6, false){

                @Override
                public boolean onBlockHit(class_3222 player, class_1268 enumhand, class_3965 hitRes) {
                    return this.handler.call(() -> {
                        class_1799 itemstack = player.method_5998(enumhand);
                        class_2338 blockpos = hitRes.method_17777();
                        class_2350 enumfacing = hitRes.method_17780();
                        class_243 vec3d = hitRes.method_17784().method_1023((double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260());
                        return Arrays.asList(new EntityValue((class_1297)player), ValueConversions.of(itemstack, player.method_37908().method_30349()), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand"), new BlockValue(null, player.method_51469(), blockpos), StringValue.of(enumfacing.method_10151()), ListValue.of(new NumericValue(vec3d.field_1352), new NumericValue(vec3d.field_1351), new NumericValue(vec3d.field_1350)));
                    }, () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_INTERACTS_WITH_BLOCK = new Event("player_interacts_with_block", 5, false){

                @Override
                public boolean onBlockHit(class_3222 player, class_1268 enumhand, class_3965 hitRes) {
                    this.handler.call(() -> {
                        class_2338 blockpos = hitRes.method_17777();
                        class_2350 enumfacing = hitRes.method_17780();
                        class_243 vec3d = hitRes.method_17784().method_1023((double)blockpos.method_10263(), (double)blockpos.method_10264(), (double)blockpos.method_10260());
                        return Arrays.asList(new EntityValue((class_1297)player), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand"), new BlockValue(null, player.method_51469(), blockpos), StringValue.of(enumfacing.method_10151()), ListValue.of(new NumericValue(vec3d.field_1352), new NumericValue(vec3d.field_1351), new NumericValue(vec3d.field_1350)));
                    }, () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_PLACING_BLOCK = new Event("player_placing_block", 4, false){

                @Override
                public boolean onBlockPlaced(class_3222 player, class_2338 pos, class_1268 enumhand, class_1799 itemstack) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ValueConversions.of(itemstack, player.method_37908().method_30349()), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand"), new BlockValue(null, player.method_51469(), pos)), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_PLACES_BLOCK = new Event("player_places_block", 4, false){

                @Override
                public boolean onBlockPlaced(class_3222 player, class_2338 pos, class_1268 enumhand, class_1799 itemstack) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ValueConversions.of(itemstack, player.method_37908().method_30349()), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand"), new BlockValue(null, player.method_51469(), pos)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_BREAK_BLOCK = new Event("player_breaks_block", 2, false){

                @Override
                public boolean onBlockBroken(class_3222 player, class_2338 pos, class_2680 previousBS) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new BlockValue(previousBS, player.method_51469(), pos)), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_INTERACTS_WITH_ENTITY = new Event("player_interacts_with_entity", 3, false){

                @Override
                public boolean onEntityHandAction(class_3222 player, class_1297 entity, class_1268 enumhand) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new EntityValue(entity), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand")), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_TRADES = new Event("player_trades", 5, false){

                @Override
                public void onTrade(class_3222 player, class_1915 merchant, class_1914 tradeOffer) {
                    class_5455 regs = player.method_37908().method_30349();
                    this.handler.call(() -> {
                        Value value;
                        Value[] valueArray = new Value[5];
                        valueArray[0] = new EntityValue((class_1297)player);
                        if (merchant instanceof class_3988) {
                            class_3988 villager = (class_3988)merchant;
                            value = new EntityValue((class_1297)villager);
                        } else {
                            value = Value.NULL;
                        }
                        valueArray[1] = value;
                        valueArray[2] = ValueConversions.of(tradeOffer.method_8246(), regs);
                        valueArray[3] = ValueConversions.of(tradeOffer.method_8247(), regs);
                        valueArray[4] = ValueConversions.of(tradeOffer.method_8250(), regs);
                        return Arrays.asList(valueArray);
                    }, () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_PICKS_UP_ITEM = new Event("player_picks_up_item", 2, false){

                @Override
                public boolean onItemAction(class_3222 player, class_1268 enumhand, class_1799 itemstack) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ValueConversions.of(itemstack, player.method_37908().method_30349())), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_ATTACKS_ENTITY = new Event("player_attacks_entity", 2, false){

                @Override
                public boolean onEntityHandAction(class_3222 player, class_1297 entity, class_1268 enumhand) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new EntityValue(entity)), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_STARTS_SNEAKING = new Event("player_starts_sneaking", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_STOPS_SNEAKING = new Event("player_stops_sneaking", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_STARTS_SPRINTING = new Event("player_starts_sprinting", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_STOPS_SPRINTING = new Event("player_stops_sprinting", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_RELEASED_ITEM = new Event("player_releases_item", 3, false){

                @Override
                public boolean onItemAction(class_3222 player, class_1268 enumhand, class_1799 itemstack) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ValueConversions.of(itemstack, player.method_37908().method_30349()), StringValue.of(enumhand == class_1268.field_5808 ? "mainhand" : "offhand")), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_FINISHED_USING_ITEM = new Event("player_finishes_using_item", 3, false){

                @Override
                public boolean onItemAction(class_3222 player, class_1268 enumhand, class_1799 itemstack) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), ValueConversions.of(itemstack, player.method_37908().method_30349()), new StringValue(enumhand == class_1268.field_5808 ? "mainhand" : "offhand")), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_DROPS_ITEM = new Event("player_drops_item", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    return this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_DROPS_STACK = new Event("player_drops_stack", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    return this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_CHOOSES_RECIPE = new Event("player_chooses_recipe", 3, false){

                @Override
                public boolean onRecipeSelected(class_3222 player, class_2960 recipe, boolean fullStack) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), NBTSerializableValue.nameFromRegistryId(recipe), BooleanValue.of(fullStack)), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_SWITCHES_SLOT = new Event("player_switches_slot", 3, false){

                @Override
                public void onSlotSwitch(class_3222 player, int from, int to) {
                    if (from == to) {
                        return;
                    }
                    this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new NumericValue(from), new NumericValue(to)), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_SWAPS_HANDS = new Event("player_swaps_hands", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    return this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_SWINGS_HAND = new Event("player_swings_hand", 2, false){

                @Override
                public void onHandAction(class_3222 player, class_1268 hand) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), StringValue.of(hand == class_1268.field_5808 ? "mainhand" : "offhand")), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_TAKES_DAMAGE = new Event("player_takes_damage", 4, false){

                @Override
                public boolean onDamage(class_1297 target, float amount, class_1282 source) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue(target), new NumericValue(amount), StringValue.of(source.method_5525()), source.method_5529() == null ? Value.NULL : new EntityValue(source.method_5529())), () -> target.method_5682().method_3739());
                }
            };
            PLAYER_DEALS_DAMAGE = new Event("player_deals_damage", 3, false){

                @Override
                public boolean onDamage(class_1297 target, float amount, class_1282 source) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue(source.method_5529()), new NumericValue(amount), new EntityValue(target)), () -> source.method_5529().method_5682().method_3739());
                }
            };
            PLAYER_COLLIDES_WITH_ENTITY = new Event("player_collides_with_entity", 2, false){

                @Override
                public boolean onEntityHandAction(class_3222 player, class_1297 entity, class_1268 enumhand) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new EntityValue(entity)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_DIES = new Event("player_dies", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_RESPAWNS = new Event("player_respawns", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_CHANGES_DIMENSION = new Event("player_changes_dimension", 5, false){

                @Override
                public void onDimensionChange(class_3222 player, class_243 from, class_243 to, class_5321<class_1937> fromDim, class_5321<class_1937> dimTo) {
                    Value fromValue = ListValue.fromTriple(from.field_1352, from.field_1351, from.field_1350);
                    NullValue toValue = to == null ? Value.NULL : ListValue.fromTriple(to.field_1352, to.field_1351, to.field_1350);
                    Value fromDimStr = NBTSerializableValue.nameFromRegistryId(fromDim.method_29177());
                    Value toDimStr = NBTSerializableValue.nameFromRegistryId(dimTo.method_29177());
                    this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), fromValue, fromDimStr, toValue, toDimStr), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_CONNECTS = new Event("player_connects", 1, false){

                @Override
                public boolean onPlayerEvent(class_3222 player) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue((class_1297)player)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_DISCONNECTS = new Event("player_disconnects", 2, false){

                @Override
                public boolean onPlayerMessage(class_3222 player, String message) {
                    this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new StringValue(message)), () -> ((class_3222)player).method_64396());
                    return false;
                }
            };
            PLAYER_MESSAGE = new Event("player_message", 2, false){

                @Override
                public boolean onPlayerMessage(class_3222 player, String message) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new StringValue(message)), () -> ((class_3222)player).method_64396());
                }
            };
            PLAYER_COMMAND = new Event("player_command", 2, false){

                @Override
                public boolean onPlayerMessage(class_3222 player, String message) {
                    return this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), new StringValue(message)), () -> ((class_3222)player).method_64396());
                }
            };
            STATISTICS = new Event("statistic", 4, false){
                private final Set<class_2960> skippedStats = Set.of(class_3468.field_15400, class_3468.field_15429, class_3468.field_15417, class_3468.field_33558);

                private <T> class_2960 getStatId(class_3445<T> stat) {
                    return stat.method_14949().method_14959().method_10221(stat.method_14951());
                }

                @Override
                public void onPlayerStatistic(class_3222 player, class_3445<?> stat, int amount) {
                    class_2960 id = this.getStatId(stat);
                    if (this.skippedStats.contains(id)) {
                        return;
                    }
                    class_2378 registry = player.method_37908().method_30349().method_30530(class_7924.field_41226);
                    this.handler.call(() -> Arrays.asList(new EntityValue((class_1297)player), NBTSerializableValue.nameFromRegistryId(registry.method_10221((Object)stat.method_14949())), NBTSerializableValue.nameFromRegistryId(id), new NumericValue(amount)), () -> ((class_3222)player).method_64396());
                }
            };
            LIGHTNING = new Event("lightning", 2, true){

                @Override
                public void onWorldEventFlag(class_3218 world, class_2338 pos, int flag) {
                    this.handler.call(() -> Arrays.asList(new BlockValue(null, world, pos), flag > 0 ? Value.TRUE : Value.FALSE), () -> world.method_8503().method_3739().method_9227(world));
                }
            };
            EXPLOSION_OUTCOME = new Event("explosion_outcome", 8, true){

                @Override
                public boolean onExplosion(class_3218 world, class_1297 e, Supplier<class_1309> attacker, class_243 center, float power, boolean createFire, List<class_2338> affectedBlocks, List<class_1297> affectedEntities, class_1927.class_4179 type) {
                    this.handler.call(() -> Arrays.asList(ValueConversions.of(center), NumericValue.of(Float.valueOf(power)), EntityValue.of(e), EntityValue.of((class_1297)(attacker != null ? (class_1297)attacker.get() : Event.getExplosionCausingEntity(e))), StringValue.of(type.name().toLowerCase(Locale.ROOT)), BooleanValue.of(createFire), ListValue.wrap(affectedBlocks.stream().filter(b -> !world.method_22347(b)).map(b -> new BlockValue(world.method_8320(b), world, (class_2338)b))), ListValue.wrap(affectedEntities.stream().map(EntityValue::of))), () -> world.method_8503().method_3739().method_9227(world));
                    return false;
                }
            };
            EXPLOSION = new Event("explosion", 6, true){

                @Override
                public boolean onExplosion(class_3218 world, class_1297 e, Supplier<class_1309> attacker, class_243 center, float power, boolean createFire, List<class_2338> affectedBlocks, List<class_1297> affectedEntities, class_1927.class_4179 type) {
                    return this.handler.call(() -> Arrays.asList(ValueConversions.of(center), NumericValue.of(Float.valueOf(power)), EntityValue.of(e), EntityValue.of((class_1297)(attacker != null ? (class_1297)attacker.get() : Event.getExplosionCausingEntity(e))), StringValue.of(type.name().toLowerCase(Locale.ROOT)), BooleanValue.of(createFire)), () -> world.method_8503().method_3739().method_9227(world));
                }
            };
            ENTITY_LOAD = class_7923.field_41177.method_10220().map(et -> Map.entry(et, new Event(Event.getEntityLoadEventName((class_1299<? extends class_1297>)et), 1, true, false){

                @Override
                public void onEntityAction(class_1297 entity, boolean created) {
                    this.handler.call(() -> Collections.singletonList(new EntityValue(entity)), () -> entity.method_5682().method_3739().method_9227((class_3218)entity.method_37908()).method_9206(Vanilla.MinecraftServer_getRunPermissionLevel(entity.method_5682())));
                }
            })).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
            ENTITY_HANDLER = class_7923.field_41177.method_10220().map(et -> Map.entry(et, new Event(Event.getEntityHandlerEventName((class_1299<? extends class_1297>)et), 2, true, false){

                @Override
                public void onEntityAction(class_1297 entity, boolean created) {
                    this.handler.call(() -> Arrays.asList(new EntityValue(entity), BooleanValue.of(created)), () -> entity.method_5682().method_3739().method_9227((class_3218)entity.method_37908()).method_9206(Vanilla.MinecraftServer_getRunPermissionLevel(entity.method_5682())));
                }
            })).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }

    public static class ScheduledCall
    extends Callback {
        private final CarpetContext ctx;
        public long dueTime;

        public ScheduledCall(CarpetContext context, FunctionValue function, List<Value> args, long dueTime) {
            super(context.host.getName(), null, function, args, (CarpetScriptServer)context.scriptServer());
            this.ctx = context.duplicate();
            this.dueTime = dueTime;
        }

        public void execute() {
            this.scriptServer.events.runScheduledCall(this.ctx.origin(), this.ctx.source(), this.host, (CarpetScriptHost)this.ctx.host, this.function, this.parametrizedArgs);
        }
    }

    public static enum CallbackResult {
        SUCCESS,
        PASS,
        FAIL,
        CANCEL;

    }

    public static class CallbackList {
        private List<Callback> callList = new ArrayList<Callback>();
        private final List<Callback> removedCalls = new ArrayList<Callback>();
        private boolean inCall = false;
        private boolean inSignal = false;
        public final int reqArgs;
        final boolean isSystem;
        final boolean perPlayerDistribution;

        public CallbackList(int reqArgs, boolean isSystem, boolean isGlobalOnly) {
            this.reqArgs = reqArgs;
            this.isSystem = isSystem;
            this.perPlayerDistribution = isSystem && !isGlobalOnly;
        }

        public List<Callback> inspectCurrentCalls() {
            return new ArrayList<Callback>(this.callList);
        }

        private void removeCallsIf(Predicate<Callback> when) {
            if (!this.inCall && !this.inSignal) {
                this.callList.removeIf(when);
                return;
            }
            for (int i = 0; i < this.callList.size(); ++i) {
                Callback call = this.callList.get(i);
                if (!when.test(call)) continue;
                this.removedCalls.add(call);
            }
        }

        public boolean call(Supplier<List<Value>> argumentSupplier, Supplier<class_2168> cmdSourceSupplier) {
            class_2168 source;
            if (this.callList.isEmpty()) {
                return false;
            }
            try {
                source = cmdSourceSupplier.get();
            }
            catch (NullPointerException noReference) {
                return false;
            }
            CarpetScriptServer scriptServer = Vanilla.MinecraftServer_getScriptServer(source.method_9211());
            if (scriptServer.stopAll) {
                return false;
            }
            Boolean isCancelled = scriptServer.events.handleEvents.runIfEnabled(() -> {
                String nameCheck;
                Runnable profilerToken = Carpet.startProfilerSection("Scarpet events");
                List argv = (List)argumentSupplier.get();
                String string = nameCheck = this.perPlayerDistribution ? source.method_9214() : null;
                assert (argv.size() == this.reqArgs);
                boolean cancelled = false;
                try {
                    this.inCall = true;
                    for (int i = 0; i < this.callList.size(); ++i) {
                        Callback call = this.callList.get(i);
                        if (nameCheck != null && call.optionalTarget != null && !nameCheck.equals(call.optionalTarget)) continue;
                        CallbackResult result = call.execute(source, argv);
                        if (result == CallbackResult.CANCEL) {
                            cancelled = true;
                            break;
                        }
                        if (result != CallbackResult.FAIL) continue;
                        this.removedCalls.add(call);
                    }
                }
                finally {
                    this.inCall = false;
                }
                for (Callback call : this.removedCalls) {
                    this.callList.remove(call);
                }
                this.removedCalls.clear();
                profilerToken.run();
                return cancelled;
            });
            return isCancelled != null && isCancelled != false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int signal(class_2168 sender, @Nullable class_3222 recipient, List<Value> callArg) {
            if (this.callList.isEmpty()) {
                return 0;
            }
            int successes = 0;
            try {
                this.inSignal = true;
                for (int i = 0; i < this.callList.size(); ++i) {
                    if (this.callList.get(i).signal(sender, recipient, callArg) != CallbackResult.SUCCESS) continue;
                    ++successes;
                }
            }
            finally {
                this.inSignal = false;
            }
            return successes;
        }

        public boolean addFromExternal(class_2168 source, String hostName, String funName, Consumer<ScriptHost> hostOnEventHandler, CarpetScriptServer scriptServer) {
            CarpetScriptHost host = scriptServer.getAppHostByName(hostName);
            if (host == null) {
                Carpet.Messenger_message(source, "r Unknown app " + hostName);
                return false;
            }
            hostOnEventHandler.accept(host);
            FunctionValue udf = host.getFunction(funName);
            if (udf == null || udf.getArguments().size() != this.reqArgs) {
                Carpet.Messenger_message(source, "r Callback doesn't expect required number of arguments: " + this.reqArgs);
                return false;
            }
            String target = null;
            if (host.isPerUser()) {
                try {
                    target = source.method_9207().method_5820();
                }
                catch (CommandSyntaxException e) {
                    Carpet.Messenger_message(source, "r Cannot add event to a player scoped app from a command without a player context");
                    return false;
                }
            }
            this.removeEventCall(hostName, target, udf.getString());
            this.callList.add(new Callback(hostName, target, udf, null, scriptServer));
            return true;
        }

        public boolean addEventCallInternal(ScriptHost host, FunctionValue function, List<Value> args) {
            if (function == null || function.getArguments().size() - args.size() != this.reqArgs) {
                return false;
            }
            this.removeEventCall(host.getName(), host.user, function.getString());
            this.callList.add(new Callback(host.getName(), host.user, function, args, (CarpetScriptServer)host.scriptServer()));
            return true;
        }

        public void removeEventCall(String hostName, String target, String funName) {
            this.removeCallsIf(c -> c.function.getString().equals(funName) && Objects.equals(c.host, hostName) && Objects.equals(c.optionalTarget, target));
        }

        public void removeAllCalls(CarpetScriptHost host) {
            this.removeCallsIf(c -> Objects.equals(c.host, host.getName()) && Objects.equals(c.optionalTarget, host.user));
        }

        public void createChildEvents(CarpetScriptHost host) {
            ArrayList copyCalls = new ArrayList();
            this.callList.forEach(c -> {
                if (Objects.equals(c.host, host.getName()) && c.optionalTarget == null) {
                    copyCalls.add(new Callback(c.host, host.user, c.function, c.parametrizedArgs, host.scriptServer()));
                }
            });
            this.callList.addAll(copyCalls);
        }

        public void clearEverything() {
            if (this.inSignal || this.inCall) {
                this.callList = new ArrayList<Callback>();
            }
            this.callList.clear();
        }

        public void sortByPriority(CarpetScriptServer scriptServer) {
            this.callList.sort(Comparator.comparingDouble(c -> -scriptServer.getAppHostByName((String)c.host).eventPriority));
        }
    }

    public static class Callback {
        public final String host;
        @Nullable
        public final String optionalTarget;
        public final FunctionValue function;
        public final List<Value> parametrizedArgs;
        public final CarpetScriptServer scriptServer;

        public Callback(String host, @Nullable String target, FunctionValue function, List<Value> parametrizedArgs, CarpetScriptServer scriptServer) {
            this.host = host;
            this.function = function;
            this.optionalTarget = target;
            this.parametrizedArgs = parametrizedArgs == null ? NOARGS : parametrizedArgs;
            this.scriptServer = scriptServer;
        }

        public CallbackResult execute(class_2168 sender, List<Value> runtimeArgs) {
            if (!this.parametrizedArgs.isEmpty()) {
                runtimeArgs = new ArrayList<Value>(runtimeArgs);
                runtimeArgs.addAll(this.parametrizedArgs);
            }
            if (this.scriptServer.stopAll) {
                return CallbackResult.FAIL;
            }
            return this.scriptServer.events.runEventCall(sender.method_9206(Vanilla.MinecraftServer_getRunPermissionLevel(sender.method_9211())), this.host, this.optionalTarget, this.function, runtimeArgs);
        }

        public CallbackResult signal(class_2168 sender, @Nullable class_3222 recipient, List<Value> runtimeArgs) {
            return recipient != null && !recipient.method_5820().equals(this.optionalTarget) ? CallbackResult.FAIL : this.execute(sender, runtimeArgs);
        }

        public String toString() {
            return this.function.getString() + (String)(this.host == null ? "" : "(from " + this.host + (String)(this.optionalTarget == null ? "" : "/" + this.optionalTarget) + ")");
        }

        public static Signature fromString(String str) {
            Pattern find = Pattern.compile("(\\w+)(?:\\(from (\\w+)(?:/(\\w+))?\\))?");
            Matcher matcher = find.matcher(str);
            if (matcher.matches()) {
                return new Signature(matcher.group(1), matcher.group(2), matcher.group(3));
            }
            return new Signature(str, null, null);
        }

        public record Signature(String function, String host, String target) {
        }
    }
}

