/*
 * Decompiled with CFR 0.152.
 */
package carpet.network;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.api.settings.CarpetRule;
import carpet.api.settings.RuleHelper;
import carpet.fakes.ServerGamePacketListenerImplInterface;
import carpet.network.CarpetClient;
import carpet.script.utils.SnoopyCommandSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ServerNetworkHandler {
    private static final Map<class_3222, String> remoteCarpetPlayers = new HashMap<class_3222, String>();
    private static final Set<class_3222> validCarpetPlayers = new HashSet<class_3222>();
    private static final Map<String, BiConsumer<class_3222, class_2520>> dataHandlers = Map.of("420", (p, t) -> ServerNetworkHandler.onHello(p, (String)t.method_68658().orElseThrow()), "clientCommand", (p, t) -> ServerNetworkHandler.handleClientCommand(p, (class_2487)t));

    public static void onPlayerJoin(class_3222 playerEntity) {
        if (!((ServerGamePacketListenerImplInterface)playerEntity.field_13987).getConnection().method_10756()) {
            class_2487 data = new class_2487();
            data.method_10582("69", CarpetSettings.carpetVersion);
            playerEntity.field_13987.method_14364((class_2596)new class_2658((class_8710)new CarpetClient.CarpetPayload(data)));
        } else {
            validCarpetPlayers.add(playerEntity);
        }
    }

    public static void onHello(class_3222 playerEntity, String version) {
        validCarpetPlayers.add(playerEntity);
        remoteCarpetPlayers.put(playerEntity, version);
        if (version.equals(CarpetSettings.carpetVersion)) {
            CarpetSettings.LOG.info("Player " + playerEntity.method_5477().getString() + " joined with a matching carpet client");
        } else {
            CarpetSettings.LOG.warn("Player " + playerEntity.method_5477().getString() + " joined with another carpet version: " + version);
        }
        DataBuilder data = DataBuilder.create(playerEntity.field_13995);
        CarpetServer.forEachManager(sm -> sm.getCarpetRules().forEach(data::withRule));
        playerEntity.field_13987.method_14364((class_2596)data.build());
    }

    public static void sendPlayerLevelData(class_3222 player, class_3218 level) {
        if (CarpetSettings.superSecretSetting || !validCarpetPlayers.contains(player)) {
            // empty if block
        }
    }

    private static void handleClientCommand(class_3222 player, class_2487 commandData) {
        String command = (String)commandData.method_10558("command").orElseThrow();
        String id = (String)commandData.method_10558("id").orElseThrow();
        ArrayList<class_2561> output = new ArrayList<class_2561>();
        class_2561[] error = new class_2561[]{null};
        int[] returnValue = new int[]{0};
        if (player.method_5682() == null) {
            error[0] = class_2561.method_43470((String)"No Server");
        } else {
            player.method_5682().method_3734().method_44252((class_2168)new SnoopyCommandSource(player, error, output, returnValue), command);
        }
        class_2487 result = new class_2487();
        result.method_10582("id", id);
        if (error[0] != null) {
            result.method_10582("error", error[0].method_10851().toString());
        }
        result.method_10569("return", returnValue[0]);
        class_2499 outputResult = new class_2499();
        for (class_2561 line : output) {
            outputResult.add((Object)class_2519.method_23256((String)class_2561.class_2562.method_10867((class_2561)line, (class_7225.class_7874)player.method_56673())));
        }
        if (!output.isEmpty()) {
            result.method_10566("output", (class_2520)outputResult);
        }
        player.field_13987.method_14364((class_2596)DataBuilder.create(player.field_13995).withCustomNbt("clientCommand", (class_2520)result).build());
    }

    public static void onClientData(class_3222 player, class_2487 compound) {
        for (String key : compound.method_10541()) {
            if (dataHandlers.containsKey(key)) {
                dataHandlers.get(key).accept(player, compound.method_10580(key));
                continue;
            }
            CarpetSettings.LOG.warn("Unknown carpet client data: " + key);
        }
    }

    public static void updateRuleWithConnectedClients(CarpetRule<?> rule) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (class_3222 player : remoteCarpetPlayers.keySet()) {
            player.field_13987.method_14364((class_2596)DataBuilder.create(player.field_13995).withRule(rule).build());
        }
    }

    public static void broadcastCustomCommand(String command, class_2520 data) {
        if (CarpetSettings.superSecretSetting) {
            return;
        }
        for (class_3222 player : validCarpetPlayers) {
            player.field_13987.method_14364((class_2596)DataBuilder.create(player.field_13995).withCustomNbt(command, data).build());
        }
    }

    public static void sendCustomCommand(class_3222 player, String command, class_2520 data) {
        if (ServerNetworkHandler.isValidCarpetPlayer(player)) {
            player.field_13987.method_14364((class_2596)DataBuilder.create(player.field_13995).withCustomNbt(command, data).build());
        }
    }

    public static void onPlayerLoggedOut(class_3222 player) {
        validCarpetPlayers.remove(player);
        if (!((ServerGamePacketListenerImplInterface)player.field_13987).getConnection().method_10756()) {
            remoteCarpetPlayers.remove(player);
        }
    }

    public static void close() {
        remoteCarpetPlayers.clear();
        validCarpetPlayers.clear();
    }

    public static boolean isValidCarpetPlayer(class_3222 player) {
        if (CarpetSettings.superSecretSetting) {
            return false;
        }
        return validCarpetPlayers.contains(player);
    }

    public static String getPlayerStatus(class_3222 player) {
        if (remoteCarpetPlayers.containsKey(player)) {
            return "carpet " + remoteCarpetPlayers.get(player);
        }
        if (validCarpetPlayers.contains(player)) {
            return "carpet " + CarpetSettings.carpetVersion;
        }
        return "vanilla";
    }

    private static class DataBuilder {
        private class_2487 tag = new class_2487();
        private MinecraftServer server;

        private static DataBuilder create(MinecraftServer server) {
            return new DataBuilder(server);
        }

        private DataBuilder(MinecraftServer server) {
            this.server = server;
        }

        private DataBuilder withRule(CarpetRule<?> rule) {
            class_2487 rules = (class_2487)this.tag.method_10580("Rules");
            if (rules == null) {
                rules = new class_2487();
                this.tag.method_10566("Rules", (class_2520)rules);
            }
            String identifier = rule.settingsManager().identifier();
            Object key = rule.name();
            while (rules.method_10545((String)key)) {
                key = (String)key + "2";
            }
            class_2487 ruleNBT = new class_2487();
            ruleNBT.method_10582("Value", RuleHelper.toRuleString(rule.value()));
            ruleNBT.method_10582("Manager", identifier);
            ruleNBT.method_10582("Rule", rule.name());
            rules.method_10566((String)key, (class_2520)ruleNBT);
            return this;
        }

        public DataBuilder withCustomNbt(String key, class_2520 value) {
            this.tag.method_10566(key, value);
            return this;
        }

        private class_2658 build() {
            return new class_2658((class_8710)new CarpetClient.CarpetPayload(this.tag));
        }
    }
}

