/*
 * Decompiled with CFR 0.152.
 */
package carpetextra.dispenser;

import carpetextra.CarpetExtraSettings;
import carpetextra.dispenser.behaviors.BlazePowderDispenserBehavior;
import carpetextra.dispenser.behaviors.CarvePumpkinDispenserBehavior;
import carpetextra.dispenser.behaviors.CauldronEmptyingDispenserBehavior;
import carpetextra.dispenser.behaviors.CauldronFillingDispenserBehavior;
import carpetextra.dispenser.behaviors.CauldronWaterDispenserBehavior;
import carpetextra.dispenser.behaviors.DragonBreathDispenserBehavior;
import carpetextra.dispenser.behaviors.FeedAnimalDispenserBehavior;
import carpetextra.dispenser.behaviors.FeedMooshroomDispenserBehavior;
import carpetextra.dispenser.behaviors.FillMinecartDispenserBehavior;
import carpetextra.dispenser.behaviors.FireChargeDispenserBehavior;
import carpetextra.dispenser.behaviors.FlowerPotDispenserBehavior;
import carpetextra.dispenser.behaviors.MilkAnimalDispenserBehavior;
import carpetextra.dispenser.behaviors.MilkMooshroomDispenserBehavior;
import carpetextra.dispenser.behaviors.PlaceBoatOnIceDispenserBehavior;
import carpetextra.dispenser.behaviors.ShearChickenDispenserBehavior;
import carpetextra.dispenser.behaviors.StripBlocksDispenserBehavior;
import carpetextra.dispenser.behaviors.TillSoilDispenserBehavior;
import carpetextra.dispenser.behaviors.ToggleBlockDispenserBehavior;
import carpetextra.helpers.FlowerPotHelper;
import java.util.Map;
import net.minecraft.class_10730;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1429;
import net.minecraft.class_1438;
import net.minecraft.class_1688;
import net.minecraft.class_1743;
import net.minecraft.class_1749;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1820;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2275;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2362;
import net.minecraft.class_238;
import net.minecraft.class_2601;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_5575;
import net.minecraft.class_6053;

public class CarpetExtraDispenserBehaviors {
    public static final class_2357 BLAZE_MEAL = new BlazePowderDispenserBehavior();
    public static final class_2357 SHEAR_CHICKEN = new ShearChickenDispenserBehavior();
    public static final class_2357 CARVE_PUMPKIN = new CarvePumpkinDispenserBehavior();
    public static final class_2357 FEED_ANIMAL = new FeedAnimalDispenserBehavior();
    public static final class_2357 FEED_MOOSHROOM = new FeedMooshroomDispenserBehavior();
    public static final class_2357 FILL_MINECART_CHEST = new FillMinecartDispenserBehavior((class_1299<? extends class_1688>)class_1299.field_6126);
    public static final class_2357 FILL_MINECART_FURNACE = new FillMinecartDispenserBehavior((class_1299<? extends class_1688>)class_1299.field_6080);
    public static final class_2357 FILL_MINECART_TNT = new FillMinecartDispenserBehavior((class_1299<? extends class_1688>)class_1299.field_6053);
    public static final class_2357 FILL_MINECART_HOPPER = new FillMinecartDispenserBehavior((class_1299<? extends class_1688>)class_1299.field_6058);
    public static final class_2357 MILK_ANIMAL = new MilkAnimalDispenserBehavior();
    public static final class_2357 MILK_MOOSHROOM = new MilkMooshroomDispenserBehavior();
    public static final class_2357 FILL_FLOWER_POT = new FlowerPotDispenserBehavior();
    public static final class_2357 STRIP_BLOCK = new StripBlocksDispenserBehavior();
    public static final class_2357 TILL_SOIL = new TillSoilDispenserBehavior();
    public static final class_2357 TOGGLE_BLOCK = new ToggleBlockDispenserBehavior();
    public static final class_2357 CAULDRON_FILLING_BUCKET = new CauldronFillingDispenserBehavior();
    public static final class_2357 CAULDRON_EMPTYING_BUCKET = new CauldronEmptyingDispenserBehavior();
    public static final class_2357 CAULDRON_WATER = new CauldronWaterDispenserBehavior();
    public static final class_2357 DRAGON_BREATH_ENDSTONE = new DragonBreathDispenserBehavior();
    public static final class_2357 FIRE_CHARGE_NETHERRACK = new FireChargeDispenserBehavior();
    public static final class_2357 PLACE_BOAT_ON_ICE = new PlaceBoatOnIceDispenserBehavior();

    public static class_2357 getCustomDispenserBehavior(class_3218 world, class_2338 pos, class_2342 pointer, class_2601 dispenserBlockEntity, class_1799 stack, Map<class_1792, class_2357> VANILLA_BEHAVIORS) {
        class_2338 blockBelowFrontBlockPos;
        class_1792 item = stack.method_7909();
        class_2350 dispenserFacing = (class_2350)pointer.comp_1969().method_11654((class_2769)class_2315.field_10918);
        class_2338 frontBlockPos = pos.method_10093(dispenserFacing);
        class_2680 frontBlockState = world.method_8320(frontBlockPos);
        class_2248 frontBlock = frontBlockState.method_26204();
        class_238 frontBlockBox = new class_238(frontBlockPos);
        if (CarpetExtraSettings.blazeMeal && item == class_1802.field_8183 && frontBlock == class_2246.field_9974) {
            return BLAZE_MEAL;
        }
        if (CarpetExtraSettings.chickenShearing && item == class_1802.field_8868) {
            boolean hasShearableChickens;
            boolean bl = hasShearableChickens = !world.method_18023((class_5575)class_1299.field_6132, frontBlockBox, class_1301.field_6157.and(chickenEntity -> !((class_1429)chickenEntity).method_6109())).isEmpty();
            if (hasShearableChickens) {
                return SHEAR_CHICKEN;
            }
        }
        if (CarpetExtraSettings.dispensersCarvePumpkins && item instanceof class_1820 && frontBlock == class_2246.field_46282) {
            return CARVE_PUMPKIN;
        }
        if (CarpetExtraSettings.dispensersFeedAnimals) {
            boolean hasFeedableMooshrooms;
            boolean hasFeedableAnimals;
            boolean bl = hasFeedableAnimals = !world.method_8390(class_1429.class, frontBlockBox, class_1301.field_6157.and(animalEntity -> ((class_1429)animalEntity).method_6481(stack))).isEmpty();
            if (hasFeedableAnimals) {
                return FEED_ANIMAL;
            }
            boolean bl2 = hasFeedableMooshrooms = !world.method_18023((class_5575)class_1299.field_6143, frontBlockBox, class_1301.field_6157.and(mooshroomEntity -> ((class_1438)mooshroomEntity).method_47847() == class_1438.class_4053.field_18110)).isEmpty();
            if (hasFeedableMooshrooms && stack.method_31573(class_3489.field_15543)) {
                return FEED_MOOSHROOM;
            }
        }
        if (CarpetExtraSettings.dispensersFillMinecarts) {
            boolean hasMinecarts;
            boolean bl = hasMinecarts = !world.method_18023((class_5575)class_1299.field_6096, frontBlockBox, class_1301.field_6153).isEmpty();
            if (hasMinecarts) {
                if (item == class_1802.field_8106) {
                    return FILL_MINECART_CHEST;
                }
                if (item == class_1802.field_8732) {
                    return FILL_MINECART_FURNACE;
                }
                if (item == class_1802.field_8626) {
                    return FILL_MINECART_TNT;
                }
                if (item == class_1802.field_8239) {
                    return FILL_MINECART_HOPPER;
                }
            }
        }
        if (CarpetExtraSettings.dispensersMilkAnimals) {
            if (item == class_1802.field_8550) {
                boolean hasMilkable;
                boolean bl = hasMilkable = !world.method_8390(class_1429.class, frontBlockBox, class_1301.field_6157.and(animalEntity -> animalEntity instanceof class_10730 || animalEntity instanceof class_6053)).isEmpty();
                if (hasMilkable) {
                    return MILK_ANIMAL;
                }
            } else if (item == class_1802.field_8428) {
                boolean hasMooshroom;
                boolean bl = hasMooshroom = !world.method_18023((class_5575)class_1299.field_6143, frontBlockBox, class_1301.field_6157).isEmpty();
                if (hasMooshroom) {
                    return MILK_MOOSHROOM;
                }
            }
        }
        if (CarpetExtraSettings.dispensersPotPlants && frontBlock instanceof class_2362 && FlowerPotHelper.isPottable(item)) {
            return FILL_FLOWER_POT;
        }
        if (CarpetExtraSettings.dispensersStripBlocks && item instanceof class_1743 && (StripBlocksDispenserBehavior.canStrip(frontBlock) || StripBlocksDispenserBehavior.isStripResult(frontBlock))) {
            return STRIP_BLOCK;
        }
        if (CarpetExtraSettings.dispensersTillSoil && item instanceof class_1794) {
            for (int i = 0; i < 2; ++i) {
                class_2338 hoeBlockPos = frontBlockPos.method_10087(i);
                class_2248 hoeBlock = world.method_8320(hoeBlockPos).method_26204();
                if (!TillSoilDispenserBehavior.TILLED_BLOCKS.contains(hoeBlock) && hoeBlock != class_2246.field_10362) continue;
                return TILL_SOIL;
            }
        }
        if (CarpetExtraSettings.dispensersToggleThings && item == class_1802.field_8600 && ToggleBlockDispenserBehavior.TOGGLEABLE_BLOCKS.contains(frontBlock)) {
            return TOGGLE_BLOCK;
        }
        if (CarpetExtraSettings.dispensersUseCauldrons && frontBlock instanceof class_2275) {
            if (item == class_1802.field_8550) {
                return CAULDRON_EMPTYING_BUCKET;
            }
            if (item == class_1802.field_8187 || item == class_1802.field_8705 || item == class_1802.field_27876) {
                return CAULDRON_FILLING_BUCKET;
            }
            if (CauldronWaterDispenserBehavior.isWaterCauldronItem(stack)) {
                return CAULDRON_WATER;
            }
        }
        if (CarpetExtraSettings.renewableEndstone && item == class_1802.field_8613 && frontBlock == class_2246.field_10445) {
            return DRAGON_BREATH_ENDSTONE;
        }
        if (CarpetExtraSettings.renewableNetherrack && item == class_1802.field_8814 && frontBlock == class_2246.field_10445) {
            return FIRE_CHARGE_NETHERRACK;
        }
        if (CarpetExtraSettings.dispensersPlaceBoatsOnIce && item instanceof class_1749 && frontBlock == class_2246.field_10124 && world.method_8320(blockBelowFrontBlockPos = frontBlockPos.method_10074()).method_26164(class_3481.field_15467)) {
            return PLACE_BOAT_ON_ICE;
        }
        return null;
    }
}

