/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import it.unimi.dsi.fastutil.shorts.ShortList;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.ticks.LevelChunkTicks;
import org.jetbrains.annotations.Nullable;

public class ChunkLoader {
    private static final AtomicBoolean ZERO_CHUNK_POS_ERROR_LOGGED_REF = new AtomicBoolean(false);
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.codecRW((IdMap)Block.BLOCK_STATE_REGISTRY, (Codec)BlockState.CODEC, (PalettedContainer.Strategy)PalettedContainer.Strategy.SECTION_STATES, (Object)Blocks.AIR.defaultBlockState());
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG_18 = "block_ticks";
    private static final String FLUID_TICKS_TAG_18 = "fluid_ticks";
    private static final String BLOCK_TICKS_TAG_PRE18 = "TileTicks";
    private static final String FLUID_TICKS_TAG_PRE18 = "LiquidTicks";
    private static final ConfigBasedLogger LOGGER = BatchGenerationEnvironment.LOAD_LOGGER;
    private static boolean lightingSectionErrorLogged = false;
    private static final ConcurrentHashMap<String, Object> LOGGED_ERROR_MESSAGE_MAP = new ConcurrentHashMap();

    public static LevelChunk read(WorldGenLevel level, ChunkPos chunkPos, CompoundTag chunkData) {
        int chunkZ;
        CompoundTag tagLevel = chunkData;
        int chunkX = ChunkLoader.tagGetInt(tagLevel, "xPos");
        ChunkPos actualPos = new ChunkPos(chunkX, chunkZ = ChunkLoader.tagGetInt(tagLevel, "zPos"));
        if (!Objects.equals(chunkPos, actualPos)) {
            if (chunkX == 0 && chunkZ == 0) {
                if (!ZERO_CHUNK_POS_ERROR_LOGGED_REF.getAndSet(true)) {
                    LOGGER.warn("Chunk file at [" + chunkPos.toString() + "] doesn't have a chunk pos. \nThis might happen if the world was created using an external program. \nDH will attempt to parse the chunk anyway and won't log this message again.\nIf issues arise please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen.", new Object[0]);
                }
            } else {
                LOGGER.error("Chunk file at [" + chunkPos.toString() + "] is in the wrong location. \nPlease try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen. \n(Expected pos: [" + chunkPos.toString() + "], actual [" + actualPos.toString() + "])", new Object[0]);
                return null;
            }
        }
        ChunkType chunkType = ChunkLoader.readChunkType(tagLevel);
        BlendingData blendingData = ChunkLoader.readBlendingData(tagLevel);
        if (chunkType == ChunkType.PROTOCHUNK && blendingData == null) {
            return null;
        }
        long inhabitedTime = ChunkLoader.tagGetLong(tagLevel, "InhabitedTime");
        UpgradeData upgradeData = tagLevel.contains(TAG_UPGRADE_DATA) ? new UpgradeData(ChunkLoader.tagGetCompoundTag(tagLevel, TAG_UPGRADE_DATA), (LevelHeightAccessor)level) : UpgradeData.EMPTY;
        boolean isLightOn = ChunkLoader.tagGetBoolean(tagLevel, "isLightOn");
        LevelChunkTicks blockTicks = new LevelChunkTicks();
        LevelChunkTicks fluidTicks = new LevelChunkTicks();
        LevelChunkSection[] levelChunkSections = ChunkLoader.readSections((LevelAccessor)level, chunkPos, tagLevel);
        LevelChunk chunk = new LevelChunk((Level)level, chunkPos, upgradeData, blockTicks, fluidTicks, inhabitedTime, levelChunkSections, null, blendingData);
        chunk.setLightCorrect(isLightOn);
        ChunkLoader.readHeightmaps(chunk, chunkData);
        ChunkLoader.readPostPocessings(chunk, chunkData);
        return chunk;
    }

    private static LevelChunkSection[] readSections(LevelAccessor level, ChunkPos chunkPos, CompoundTag chunkData) {
        Registry biomes = level.registryAccess().lookupOrThrow(Registries.BIOME);
        Codec biomeCodec = PalettedContainer.codecRW((IdMap)biomes.asHolderIdMap(), (Codec)biomes.holderByNameCodec(), (PalettedContainer.Strategy)PalettedContainer.Strategy.SECTION_BIOMES, (Object)biomes.getOrThrow(Biomes.PLAINS));
        int sectionYIndex = level.getSectionsCount();
        LevelChunkSection[] chunkSections = new LevelChunkSection[sectionYIndex];
        ListTag tagSections = ChunkLoader.tagGetListTag(chunkData, "Sections", 10);
        if (tagSections == null || tagSections.isEmpty()) {
            tagSections = ChunkLoader.tagGetListTag(chunkData, "sections", 10);
        }
        if (tagSections != null) {
            for (int j = 0; j < tagSections.size(); ++j) {
                CompoundTag tagSection = ChunkLoader.tagGetCompoundTag(tagSections, j);
                byte sectionYPos = ChunkLoader.tagGetByte(tagSection, "Y");
                int sectionId = level.getSectionIndexFromSectionY((int)sectionYPos);
                if (sectionId < 0 || sectionId >= chunkSections.length) continue;
                boolean containsBlockStates = tagSection.contains("block_states");
                PalettedContainer blockStateContainer = containsBlockStates ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)ChunkLoader.tagGetCompoundTag(tagSection, "block_states")).promotePartial(string -> ChunkLoader.logBlockDeserializationWarning(chunkPos, sectionYPos, string)).getOrThrow(message -> ChunkLoader.logErrorAndReturnException(message)) : new PalettedContainer((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)Blocks.AIR.defaultBlockState(), PalettedContainer.Strategy.SECTION_STATES);
                boolean containsBiomes = tagSection.contains("biomes");
                PalettedContainer biomeContainer = containsBiomes ? (PalettedContainer)biomeCodec.parse((DynamicOps)NbtOps.INSTANCE, (Object)ChunkLoader.tagGetCompoundTag(tagSection, "biomes")).promotePartial(string -> ChunkLoader.logBiomeDeserializationWarning(chunkPos, sectionYIndex, string)).getOrThrow(message -> ChunkLoader.logErrorAndReturnException(message)) : new PalettedContainer(biomes.asHolderIdMap(), (Object)biomes.getOrThrow(Biomes.PLAINS), PalettedContainer.Strategy.SECTION_BIOMES);
                chunkSections[sectionId] = new LevelChunkSection(blockStateContainer, (PalettedContainerRO)biomeContainer);
            }
        }
        return chunkSections;
    }

    private static ChunkType readChunkType(CompoundTag tagLevel) {
        ChunkStatus chunkStatus = ChunkStatus.byName((String)ChunkLoader.tagGetString(tagLevel, "Status"));
        if (chunkStatus != null) {
            return chunkStatus.getChunkType();
        }
        return ChunkType.PROTOCHUNK;
    }

    private static void readHeightmaps(LevelChunk chunk, CompoundTag chunkData) {
        CompoundTag tagHeightmaps = ChunkLoader.tagGetCompoundTag(chunkData, "Heightmaps");
        for (Heightmap.Types type2 : ChunkStatus.FULL.heightmapsAfter()) {
            Optional optionalHeightmap;
            String heightmap = type2.getSerializationKey();
            if (!tagHeightmaps.contains(heightmap) || !(optionalHeightmap = tagHeightmaps.getLongArray(heightmap)).isPresent()) continue;
            chunk.setHeightmap(type2, (long[])optionalHeightmap.get());
        }
        Heightmap.primeHeightmaps((ChunkAccess)chunk, (Set)ChunkStatus.FULL.heightmapsAfter());
    }

    private static void readPostPocessings(LevelChunk chunk, CompoundTag chunkData) {
        ListTag tagPostProcessings = ChunkLoader.tagGetListTag(chunkData, "PostProcessing", 9);
        for (int i = 0; i < tagPostProcessings.size(); ++i) {
            ListTag listTag3 = ChunkLoader.tagGetListTag(tagPostProcessings, i);
            for (int j = 0; j < listTag3.size(); ++j) {
                chunk.addPackedPostProcess(ShortList.of((short)ChunkLoader.tagGetShort(listTag3, j)), i);
            }
        }
    }

    private static BlendingData readBlendingData(CompoundTag chunkData) {
        BlendingData blendingData = null;
        boolean containsBlendingData = chunkData.contains("blending_data");
        if (containsBlendingData) {
            Dynamic blendingDataTag = new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)chunkData.getCompound("blending_data"));
            try {
                blendingData = BlendingData.unpack((BlendingData.Packed)BlendingData.Packed.CODEC.parse(blendingDataTag).resultOrPartial(message -> ChunkLoader.logParsingWarningOnce(message)).orElse(null));
            }
            catch (Exception e) {
                String message2 = e.getMessage();
                if (message2 == null || message2.trim().isEmpty()) {
                    message2 = "Failed to parse blending data";
                }
                ChunkLoader.logParsingWarningOnce(message2, e);
            }
        }
        return blendingData;
    }

    public static CombinedChunkLightStorage readLight(ChunkAccess chunk, CompoundTag chunkData) {
        CombinedChunkLightStorage combinedStorage = new CombinedChunkLightStorage(ChunkWrapper.getInclusiveMinBuildHeight(chunk), ChunkWrapper.getExclusiveMaxBuildHeight(chunk));
        ChunkLightStorage blockLightStorage = combinedStorage.blockLightStorage;
        ChunkLightStorage skyLightStorage = combinedStorage.skyLightStorage;
        boolean foundSkyLight = false;
        Tag chunkSectionTags = chunkData.get("sections");
        if (chunkSectionTags == null) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("No sections found for chunk at pos [" + String.valueOf(chunk.getPos()) + "] chunk data may be out of date.", new Object[0]);
            }
            return null;
        }
        if (!(chunkSectionTags instanceof ListTag)) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("Chunk section tag list have unexpected type [" + chunkSectionTags.getClass().getName() + "], expected [" + ListTag.class.getName() + "].", new Object[0]);
            }
            return null;
        }
        ListTag chunkSectionListTag = (ListTag)chunkSectionTags;
        for (int sectionIndex = 0; sectionIndex < chunkSectionListTag.size(); ++sectionIndex) {
            Tag chunkSectionTag = chunkSectionListTag.get(sectionIndex);
            if (!(chunkSectionTag instanceof CompoundTag)) {
                if (!lightingSectionErrorLogged) {
                    lightingSectionErrorLogged = true;
                    LOGGER.error("Chunk section tag has an unexpected type [" + chunkSectionTag.getClass().getName() + "], expected [" + CompoundTag.class.getName() + "].", new Object[0]);
                }
                return null;
            }
            CompoundTag chunkSectionCompoundTag = (CompoundTag)chunkSectionTag;
            byte[] blockLightNibbleArray = ChunkLoader.tagGetByteArray(chunkSectionCompoundTag, "BlockLight");
            byte[] skyLightNibbleArray = ChunkLoader.tagGetByteArray(chunkSectionCompoundTag, "SkyLight");
            if (blockLightNibbleArray == null || skyLightNibbleArray == null) continue;
            if (skyLightNibbleArray.length != 0) {
                foundSkyLight = true;
            }
            for (int relX = 0; relX < 16; ++relX) {
                for (int relZ = 0; relZ < 16; ++relZ) {
                    for (int relY = 0; relY < 16; ++relY) {
                        int skyLight;
                        int blockPosIndex = relY * 16 * 16 + relZ * 16 + relX;
                        byte blockLight = blockLightNibbleArray.length == 0 ? (byte)0 : ChunkLoader.getNibbleAtIndex(blockLightNibbleArray, blockPosIndex);
                        int n = skyLight = skyLightNibbleArray.length == 0 ? 0 : ChunkLoader.getNibbleAtIndex(skyLightNibbleArray, blockPosIndex);
                        if (skyLightNibbleArray.length == 0 && foundSkyLight) {
                            skyLight = 15;
                        }
                        int y = relY + sectionIndex * 16 + ChunkWrapper.getInclusiveMinBuildHeight(chunk);
                        blockLightStorage.set(relX, y, relZ, blockLight);
                        skyLightStorage.set(relX, y, relZ, skyLight);
                    }
                }
            }
        }
        return combinedStorage;
    }

    private static byte getNibbleAtIndex(byte[] arr, int index) {
        if (index % 2 == 0) {
            return (byte)(arr[index / 2] & 0xF);
        }
        return (byte)(arr[index / 2] >> 4 & 0xF);
    }

    private static void logBlockDeserializationWarning(ChunkPos chunkPos, int sectionYIndex, String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Unable to deserialize blocks for chunk section [" + chunkPos.x + ", " + sectionYIndex + ", " + chunkPos.z + "], error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
    }

    private static void logBiomeDeserializationWarning(ChunkPos chunkPos, int sectionYIndex, String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Unable to deserialize biomes for chunk section [" + chunkPos.x + ", " + sectionYIndex + ", " + chunkPos.z + "], error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
    }

    private static void logParsingWarningOnce(String message) {
        ChunkLoader.logParsingWarningOnce(message, null);
    }

    private static void logParsingWarningOnce(String message, Exception e) {
        if (message == null) {
            return;
        }
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Parsing error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", e);
            return newMessage;
        });
    }

    private static RuntimeException logErrorAndReturnException(String message) {
        LOGGED_ERROR_MESSAGE_MAP.computeIfAbsent(message, newMessage -> {
            LOGGER.warn("Parsing error: [" + newMessage + "]. This can probably be ignored, although if your world looks wrong, optimizing it via the single player menu then deleting your DH database(s) should fix the problem.", new Object[0]);
            return newMessage;
        });
        return null;
    }

    private static boolean tagGetBoolean(CompoundTag tag, String key) {
        return tag.getBoolean(key).orElse(false);
    }

    private static byte tagGetByte(CompoundTag tag, String key) {
        return tag.getByte(key).orElse((byte)0);
    }

    private static short tagGetShort(ListTag tag, int index) {
        return tag.getShort(index).orElse((short)0);
    }

    private static int tagGetInt(CompoundTag tag, String key) {
        return tag.getInt(key).orElse(0);
    }

    private static long tagGetLong(CompoundTag tag, String key) {
        return tag.getLong(key).orElse(0L);
    }

    private static String tagGetString(CompoundTag tag, String key) {
        return tag.getString(key).orElse(null);
    }

    private static byte[] tagGetByteArray(CompoundTag tag, String key) {
        return tag.getByteArray(key).orElse(null);
    }

    @Nullable
    private static CompoundTag tagGetCompoundTag(CompoundTag tag, String key) {
        return tag.getCompound(key).orElse(null);
    }

    @Nullable
    private static CompoundTag tagGetCompoundTag(ListTag tag, int index) {
        return tag.getCompound(index).orElse(null);
    }

    @Nullable
    private static ListTag tagGetListTag(CompoundTag tag, String key, int elementType) {
        return tag.getList(key).orElse(null);
    }

    @Nullable
    private static ListTag tagGetListTag(ListTag tag, int index) {
        return tag.getList(index).orElse(null);
    }

    public static class CombinedChunkLightStorage {
        public ChunkLightStorage blockLightStorage;
        public ChunkLightStorage skyLightStorage;

        public CombinedChunkLightStorage(int minY, int maxY) {
            this.blockLightStorage = ChunkLightStorage.createBlockLightStorage(minY, maxY);
            this.skyLightStorage = ChunkLightStorage.createSkyLightStorage(minY, maxY);
        }
    }
}

