/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pos;

import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;

public class DhLodUnit {
    public final byte detailLevel;
    public final int numberOfLodSectionsWide;

    public DhLodUnit(byte detailLevel, int numberOfLodSectionsWide) {
        this.detailLevel = detailLevel;
        this.numberOfLodSectionsWide = numberOfLodSectionsWide;
    }

    public int toBlockWidth() {
        return BitShiftUtil.pow(this.numberOfLodSectionsWide, this.detailLevel);
    }

    public static DhLodUnit fromBlockWidth(int blockWidth, byte targetDetailLevel) {
        return new DhLodUnit(targetDetailLevel, Math.floorDiv(blockWidth, BitShiftUtil.powerOfTwo(targetDetailLevel)));
    }

    public DhLodUnit createFromDetailLevel(byte targetDetailLevel) {
        if (this.detailLevel == targetDetailLevel) {
            return this;
        }
        if (this.detailLevel > targetDetailLevel) {
            return new DhLodUnit(targetDetailLevel, this.numberOfLodSectionsWide * BitShiftUtil.powerOfTwo(this.detailLevel - targetDetailLevel));
        }
        return new DhLodUnit(targetDetailLevel, Math.floorDiv(this.numberOfLodSectionsWide, BitShiftUtil.powerOfTwo(targetDetailLevel - this.detailLevel)));
    }
}

