/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.impl.client;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Consumer;
import me.pepperbell.continuity.api.client.ProcessingDataKey;
import me.pepperbell.continuity.api.client.ProcessingDataKeyRegistry;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.impl.client.ProcessingDataKeyRegistryImpl;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;

public class ProcessingContextImpl
implements QuadProcessor.ProcessingContext {
    protected final List<Consumer<QuadEmitter>> emitterConsumers = new ObjectArrayList();
    protected final List<Mesh> meshes = new ObjectArrayList();
    protected final MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
    protected final Object[] processingData = new Object[ProcessingDataKeyRegistry.get().getRegisteredAmount()];
    protected boolean hasExtraQuads;

    @Override
    public void addEmitterConsumer(Consumer<QuadEmitter> consumer) {
        this.emitterConsumers.add(consumer);
    }

    @Override
    public void addMesh(Mesh mesh) {
        this.meshes.add(mesh);
    }

    @Override
    public QuadEmitter getExtraQuadEmitter() {
        return this.meshBuilder.getEmitter();
    }

    @Override
    public void markHasExtraQuads() {
        this.hasExtraQuads = true;
    }

    @Override
    public <T> T getData(ProcessingDataKey<T> key) {
        int index = key.getRawId();
        Object data = this.processingData[index];
        if (data == null) {
            this.processingData[index] = data = key.getValueSupplier().get();
        }
        return (T)data;
    }

    public <T> T getDataOrNull(ProcessingDataKey<T> key) {
        return (T)this.processingData[key.getRawId()];
    }

    public void accept(RenderContext context) {
        int i;
        int amount;
        if (!this.emitterConsumers.isEmpty()) {
            QuadEmitter quadEmitter = context.getEmitter();
            amount = this.emitterConsumers.size();
            for (i = 0; i < amount; ++i) {
                this.emitterConsumers.get(i).accept(quadEmitter);
            }
        }
        if (!this.meshes.isEmpty()) {
            Consumer meshConsumer = context.meshConsumer();
            amount = this.meshes.size();
            for (i = 0; i < amount; ++i) {
                meshConsumer.accept(this.meshes.get(i));
            }
        }
        if (this.hasExtraQuads) {
            context.meshConsumer().accept(this.meshBuilder.build());
        }
    }

    public void prepare() {
        this.hasExtraQuads = false;
    }

    public void reset() {
        this.emitterConsumers.clear();
        this.meshes.clear();
        this.resetData();
    }

    protected void resetData() {
        List<ProcessingDataKey<?>> allResettable = ProcessingDataKeyRegistryImpl.INSTANCE.getAllResettable();
        int amount = allResettable.size();
        for (int i = 0; i < amount; ++i) {
            this.resetData(allResettable.get(i));
        }
    }

    protected <T> void resetData(ProcessingDataKey<T> key) {
        T value = this.getDataOrNull(key);
        if (value != null) {
            key.getValueResetAction().accept(value);
        }
    }
}

