/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import me.pepperbell.continuity.client.mixin.ReloadableResourceManagerImplAccessor;
import me.pepperbell.continuity.client.mixinterface.LifecycledResourceManagerImplExtension;
import me.pepperbell.continuity.client.resource.InvalidIdentifierStateHolder;
import me.pepperbell.continuity.client.util.BooleanState;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public class ResourceRedirectHandler {
    public static final String SPRITE_PATH_START = "continuity_reserved/";
    public static final String PATH_START = "textures/continuity_reserved/";
    public static final String PATH_END = ".png";
    public static final int PATH_START_LENGTH = "textures/continuity_reserved/".length();
    public static final int PATH_END_LENGTH = ".png".length();
    public static final int HEX_LENGTH = 8;
    public static final int HEX_END = PATH_START_LENGTH + 8;
    public static final int MIN_LENGTH = PATH_START_LENGTH + 8 + PATH_END_LENGTH;
    private static final char[] HEX_BUFFER = new char[8];
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final ObjectList<RedirectInfo> redirects = new ObjectArrayList();
    private final Object2IntMap<String> indexMap = new Object2IntOpenHashMap();
    private int nextIndex = 0;

    public ResourceRedirectHandler() {
        this.indexMap.defaultReturnValue(-1);
    }

    @Nullable
    public static ResourceRedirectHandler get(class_3300 resourceManager) {
        if (resourceManager instanceof ReloadableResourceManagerImplAccessor) {
            ReloadableResourceManagerImplAccessor accessor = (ReloadableResourceManagerImplAccessor)resourceManager;
            resourceManager = accessor.getActiveManager();
        }
        if (resourceManager instanceof LifecycledResourceManagerImplExtension) {
            LifecycledResourceManagerImplExtension extension = (LifecycledResourceManagerImplExtension)resourceManager;
            return extension.getRedirectHandler();
        }
        return null;
    }

    @Nullable
    public static ResourceRedirectHandler get() {
        return ResourceRedirectHandler.get(class_310.method_1551().method_1478());
    }

    public String getSourceSpritePath(String absolutePath) {
        int index = this.indexMap.getInt((Object)absolutePath);
        if (index == -1) {
            RedirectInfo info = RedirectInfo.of(absolutePath);
            index = this.nextIndex++;
            this.redirects.add((Object)info);
            this.indexMap.put((Object)absolutePath, index);
        }
        return SPRITE_PATH_START + ResourceRedirectHandler.toHex(index);
    }

    public class_2960 redirect(class_2960 id) {
        String newPath;
        String path = id.method_12832();
        if (!path.startsWith(PATH_START) || !path.endsWith(PATH_END)) {
            return id;
        }
        int length = path.length();
        if (length < MIN_LENGTH) {
            return id;
        }
        int index = ResourceRedirectHandler.parseHex(path, PATH_START_LENGTH);
        if (index < 0 || index >= this.redirects.size()) {
            return id;
        }
        RedirectInfo info = (RedirectInfo)this.redirects.get(index);
        if (length == MIN_LENGTH) {
            newPath = info.defaultPath;
        } else {
            String suffix = path.substring(HEX_END, length - PATH_END_LENGTH);
            newPath = info.createPath(suffix);
        }
        BooleanState invalidIdentifierState = InvalidIdentifierStateHolder.get();
        invalidIdentifierState.enable();
        class_2960 newId = new class_2960(id.method_12836(), newPath);
        invalidIdentifierState.disable();
        return newId;
    }

    public static int parseHex(String string, int startIndex) {
        int i = 0;
        int charPos = startIndex;
        int endIndex = startIndex + 8;
        while (charPos < endIndex) {
            char c;
            i <<= 4;
            if ((c = string.charAt(charPos++)) >= '0' && c <= '9') {
                i |= c - 48;
                continue;
            }
            if (c >= 'a' && c <= 'f') {
                i |= c - 97 + 10;
                continue;
            }
            return -1;
        }
        return i;
    }

    public static String toHex(int i) {
        int charPos = 8;
        do {
            ResourceRedirectHandler.HEX_BUFFER[--charPos] = HEX_DIGITS[i & 0xF];
            i >>>= 4;
        } while (charPos > 0);
        return new String(HEX_BUFFER);
    }

    private static abstract class RedirectInfo {
        public final String defaultPath;

        protected RedirectInfo(String defaultPath) {
            this.defaultPath = defaultPath;
        }

        public abstract String createPath(String var1);

        public static RedirectInfo of(final String path) {
            int extensionIndex = FilenameUtils.indexOfExtension((String)path);
            if (extensionIndex != -1) {
                final String pathStart = path.substring(0, extensionIndex);
                final String pathEnd = path.substring(extensionIndex);
                return new RedirectInfo(path){

                    @Override
                    public String createPath(String suffix) {
                        return pathStart + suffix + pathEnd;
                    }
                };
            }
            return new RedirectInfo(path){

                @Override
                public String createPath(String suffix) {
                    return path + suffix;
                }
            };
        }
    }
}

