/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.world;

import com.seibel.lod.core.enums.WorldType;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import forge.com.seibel.lod.common.wrappers.chunk.ChunkWrapper;
import forge.com.seibel.lod.common.wrappers.world.DimensionTypeWrapper;
import java.io.File;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import org.jetbrains.annotations.Nullable;

public class WorldWrapper
implements IWorldWrapper {
    private static final ConcurrentMap<LevelAccessor, WorldWrapper> worldWrapperMap = new ConcurrentHashMap<LevelAccessor, WorldWrapper>();
    private final LevelAccessor world;
    public final WorldType worldType;

    public WorldWrapper(LevelAccessor newWorld) {
        this.world = newWorld;
        this.worldType = this.world.getClass() == ServerLevel.class ? WorldType.ServerWorld : (this.world.getClass() == ClientLevel.class ? WorldType.ClientWorld : WorldType.Unknown);
    }

    @Nullable
    public static WorldWrapper getWorldWrapper(LevelAccessor world) {
        if (world == null) {
            return null;
        }
        if (worldWrapperMap.containsKey(world) && worldWrapperMap.get(world) != null) {
            return (WorldWrapper)worldWrapperMap.get(world);
        }
        WorldWrapper worldWrapper = new WorldWrapper(world);
        worldWrapperMap.put(world, worldWrapper);
        return worldWrapper;
    }

    public static void clearMap() {
        worldWrapperMap.clear();
    }

    @Override
    public WorldType getWorldType() {
        return this.worldType;
    }

    @Override
    public DimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.world.m_6042_());
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        return this.world.m_45517_(LightLayer.BLOCK, new BlockPos(x, y, z));
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        return this.world.m_45517_(LightLayer.SKY, new BlockPos(x, y, z));
    }

    public LevelAccessor getWorld() {
        return this.world;
    }

    @Override
    public boolean hasCeiling() {
        return this.world.m_6042_().f_63856_();
    }

    @Override
    public boolean hasSkyLight() {
        return this.world.m_6042_().f_223549_();
    }

    @Override
    public int getHeight() {
        return this.world.m_141928_();
    }

    @Override
    public short getMinHeight() {
        return (short)this.world.m_141937_();
    }

    @Override
    public File getSaveFolder() throws UnsupportedOperationException {
        if (this.worldType != WorldType.ServerWorld) {
            throw new UnsupportedOperationException("getSaveFolder can only be called for ServerWorlds.");
        }
        ServerChunkCache chunkSource = ((ServerLevel)this.world).m_7726_();
        return chunkSource.m_8483_().f_78146_;
    }

    public ServerLevel getServerWorld() throws UnsupportedOperationException {
        if (this.worldType != WorldType.ServerWorld) {
            throw new UnsupportedOperationException("getSaveFolder can only be called for ServerWorlds.");
        }
        return (ServerLevel)this.world;
    }

    @Override
    public int getSeaLevel() {
        return this.world.m_5736_();
    }

    @Override
    public IChunkWrapper tryGetChunk(AbstractChunkPosWrapper pos) {
        ChunkAccess chunk = this.world.m_6522_(pos.getX(), pos.getZ(), ChunkStatus.f_62314_, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, (LevelReader)this.world);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        ChunkSource source = this.world.m_7726_();
        return source.m_5563_(chunkX, chunkZ);
    }
}

