/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.world;

import com.google.common.collect.ImmutableBiMap;
import com.seibel.lod.core.wrapperInterfaces.world.IBiomeWrapper;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Blocks;

public class BiomeWrapper
implements IBiomeWrapper {
    public static final ConcurrentMap<Biome, BiomeWrapper> biomeWrapperMap = new ConcurrentHashMap<Biome, BiomeWrapper>();
    private final Biome biome;
    private static final ImmutableBiMap<Biome, Function<Biome, Integer>> BIOME_COLOR_MAP = ImmutableBiMap.builder().put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186761_), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48182_), BiomeWrapper::_colorIce).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48203_), BiomeWrapper::_colorSand).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48207_), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_220595_), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48205_), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48179_), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48149_), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48151_), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186762_), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186763_), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186764_), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48206_), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48152_), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186766_), BiomeWrapper::_colorGravel).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186767_), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48222_), BiomeWrapper::_colorFoliage).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48197_), BiomeWrapper::_colorBamboo).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48159_), BiomeWrapper::_colorRedSand).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48194_), BiomeWrapper::_colorRedSand).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186753_), BiomeWrapper::_colorStone).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186755_), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186756_), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186757_), BiomeWrapper::_colorIce).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186758_), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186759_), BiomeWrapper::_colorStone).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48208_), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48212_), BiomeWrapper::_colorIce).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48217_), BiomeWrapper::_colorSand).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48148_), BiomeWrapper::_colorSnow).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_186760_), BiomeWrapper::_colorStone).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48166_), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48167_), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48170_), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48174_), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48225_), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48168_), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48171_), BiomeWrapper::_colorWater).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48211_), BiomeWrapper::_colorIce).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48172_), BiomeWrapper::_colorIce).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48215_), BiomeWrapper::_colorMushoom).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_151784_), BiomeWrapper::_colorDripStone).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_151785_), BiomeWrapper::_colorMoss).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_220594_), BiomeWrapper::_colorSculk).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48209_), BiomeWrapper::_colorNether).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48201_), BiomeWrapper::_colorNether).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48200_), BiomeWrapper::_colorNether).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48199_), BiomeWrapper::_colorSoulSand).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48175_), BiomeWrapper::_colorBasalt).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48210_), BiomeWrapper::_colorEnd).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48164_), BiomeWrapper::_colorEnd).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48163_), BiomeWrapper::_colorEnd).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48162_), BiomeWrapper::_colorEnd).put((Object)BiomeWrapper._get((ResourceKey<Biome>)Biomes.f_48165_), BiomeWrapper::_colorEnd).build();

    public BiomeWrapper(Biome biome) {
        this.biome = biome;
    }

    public static IBiomeWrapper getBiomeWrapper(Biome biome) {
        if (biomeWrapperMap.containsKey(biome) && biomeWrapperMap.get(biome) != null) {
            return (IBiomeWrapper)biomeWrapperMap.get(biome);
        }
        BiomeWrapper biomeWrapper = new BiomeWrapper(biome);
        biomeWrapperMap.put(biome, biomeWrapper);
        return biomeWrapper;
    }

    private static int _colorEnd(Biome b) {
        return Blocks.f_50259_.m_60590_().f_76396_;
    }

    private static int _colorNether(Biome b) {
        return Blocks.f_50134_.m_60590_().f_76396_;
    }

    private static int _colorSand(Biome b) {
        return Blocks.f_49992_.m_60590_().f_76396_;
    }

    private static int _colorStone(Biome b) {
        return Blocks.f_50069_.m_60590_().f_76396_;
    }

    private static int _colorGravel(Biome b) {
        return Blocks.f_49994_.m_60590_().f_76396_;
    }

    private static int _colorDripStone(Biome b) {
        return Blocks.f_152537_.m_60590_().f_76396_;
    }

    private static int _colorMoss(Biome b) {
        return Blocks.f_152544_.m_60590_().f_76396_;
    }

    private static int _colorSculk(Biome b) {
        return Blocks.f_220855_.m_60590_().f_76396_;
    }

    private static int _colorMushoom(Biome b) {
        return Blocks.f_50195_.m_60590_().f_76396_;
    }

    private static int _colorBamboo(Biome b) {
        return Blocks.f_50571_.m_60590_().f_76396_;
    }

    private static int _colorSnow(Biome b) {
        return Blocks.f_50125_.m_60590_().f_76396_;
    }

    private static int _colorIce(Biome b) {
        return Blocks.f_50126_.m_60590_().f_76396_;
    }

    private static int _colorRedSand(Biome b) {
        return Blocks.f_49993_.m_60590_().f_76396_;
    }

    private static int _colorSoulSand(Biome b) {
        return Blocks.f_50135_.m_60590_().f_76396_;
    }

    private static int _colorBasalt(Biome b) {
        return Blocks.f_50137_.m_60590_().f_76396_;
    }

    private static int _colorWater(Biome b) {
        return b.m_47560_();
    }

    private static int _colorFoliage(Biome b) {
        return b.m_47542_();
    }

    private static Biome _get(ResourceKey<Biome> r) {
        return (Biome)BuiltinRegistries.f_123865_.m_123013_(r);
    }

    @Override
    public int getColorForBiome(int x, int z) {
        Function colorFunction = (Function)BIOME_COLOR_MAP.get((Object)this.biome);
        int colorInt = colorFunction != null ? ((Integer)colorFunction.apply(this.biome)).intValue() : this.biome.m_47464_((double)x, (double)z);
        return colorInt;
    }

    @Override
    public String getName() {
        return this.biome.toString();
    }

    @Override
    public int getGrassTint(int x, int z) {
        return this.biome.m_47464_((double)x, (double)z);
    }

    @Override
    public int getFolliageTint() {
        return this.biome.m_47542_();
    }

    @Override
    public int getWaterTint() {
        return this.biome.m_47560_();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BiomeWrapper)) {
            return false;
        }
        BiomeWrapper that = (BiomeWrapper)obj;
        return Objects.equals(this.biome, that.biome);
    }

    public int hashCode() {
        return Objects.hash(this.biome);
    }
}

