/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.config;

import com.mojang.blaze3d.vertex.PoseStack;
import com.seibel.lod.core.config.ConfigAnnotations;
import forge.com.seibel.lod.common.LodCommonMain;
import java.lang.invoke.StringConcatFactory;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import shaded.electronwill.nightconfig.core.file.CommentedFileConfig;

@Deprecated
public abstract class ConfigGui {
    private static final Pattern INTEGER_ONLY_REGEX = Pattern.compile("(-?[0-9]*)");
    private static final Pattern DECIMAL_ONLY_REGEX = Pattern.compile("-?([\\d]+\\.?[\\d]*|[\\d]*\\.?[\\d]+|\\.)");
    private static final List<EntryInfo> entries = new ArrayList<EntryInfo>();
    public static final Map<String, EntryInfo> entryMap = new HashMap<String, EntryInfo>();
    private static final String MOD_NAME = "DistantHorizons";
    private static final String MOD_NAME_READABLE = "Distant Horizons";
    private static final Logger LOGGER = LogManager.getLogger((String)"DistantHorizons");
    private static Path configFilePath;

    public static void init(Class<?> config) {
        Minecraft mc = Minecraft.m_91087_();
        configFilePath = mc.f_91069_.toPath().resolve("config").resolve("DistantHorizons.toml");
        ConfigGui.initNestedClass(config, "");
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(ConfigAnnotations.Entry.class)) continue;
            try {
                info.value = info.field.get(null);
                info.tempValue = info.value.toString();
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
        ConfigGui.loadFromFile();
    }

    private static void initNestedClass(Class<?> config, String category) {
        for (Field field : config.getFields()) {
            EntryInfo info = new EntryInfo();
            if (field.isAnnotationPresent(ConfigAnnotations.Entry.class) || field.isAnnotationPresent(ConfigAnnotations.Comment.class) || field.isAnnotationPresent(ConfigAnnotations.ScreenEntry.class)) {
                info.category = category;
                if (!LodCommonMain.serverSided) {
                    ConfigGui.initClient(field, info, category);
                }
            }
            if (field.isAnnotationPresent(ConfigAnnotations.Entry.class)) {
                entryMap.put((String)(!category.isEmpty() ? category + "." : "") + field.getName(), info);
                info.varClass = field.getType();
                try {
                    info.defaultValue = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            if (field.isAnnotationPresent(ConfigAnnotations.ScreenEntry.class)) {
                ConfigGui.initNestedClass(field.getType(), (String)(!category.isEmpty() ? category + "." : "") + field.getName());
            }
            if (field.isAnnotationPresent(ConfigAnnotations.FileComment.class)) {
                entryMap.put((String)(!category.isEmpty() ? category + "." : "") + field.getName(), info);
                info.fileComment = true;
                try {
                    info.value = info.defaultValue = field.get(null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            info.field = field;
        }
    }

    private static void initClient(Field field, EntryInfo info, String category) {
        Class<?> fieldClass = field.getType();
        ConfigAnnotations.Entry entry = field.getAnnotation(ConfigAnnotations.Entry.class);
        ConfigAnnotations.ScreenEntry screenEntry = field.getAnnotation(ConfigAnnotations.ScreenEntry.class);
        if (entry != null) {
            info.width = entry.width();
        } else if (screenEntry != null) {
            info.width = screenEntry.width();
        }
        if (entry != null) {
            if (!entry.name().equals("")) {
                info.name = Component.m_237115_((String)entry.name());
            }
            if (fieldClass == Integer.TYPE) {
                ConfigGui.textField(info, Integer::parseInt, INTEGER_ONLY_REGEX, entry.minValue(), entry.maxValue(), true);
            } else if (fieldClass == Double.TYPE) {
                ConfigGui.textField(info, Double::parseDouble, DECIMAL_ONLY_REGEX, entry.minValue(), entry.maxValue(), false);
            } else if (fieldClass == String.class || fieldClass == List.class) {
                info.max = entry.maxValue() == Double.MAX_VALUE ? Integer.MAX_VALUE : (int)entry.maxValue();
                ConfigGui.textField(info, String::length, null, Math.min(entry.minValue(), 0.0), Math.max(entry.maxValue(), 1.0), true);
            } else if (fieldClass == Boolean.TYPE) {
                Function<Object, Component> func = value -> Component.m_237115_((String)((Boolean)value != false ? "True" : "False")).m_130940_((Boolean)value != false ? ChatFormatting.GREEN : ChatFormatting.RED);
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    info.value = (Boolean)info.value == false;
                    button.m_93666_((Component)func.apply(info.value));
                }, func);
            } else if (fieldClass.isEnum()) {
                List<?> values = Arrays.asList(field.getType().getEnumConstants());
                Function<Object, Component> func = value -> Component.m_237115_((String)("DistantHorizons.config.enum." + fieldClass.getSimpleName() + "." + info.value.toString()));
                info.widget = new AbstractMap.SimpleEntry<Button.OnPress, Function<Object, Component>>(button -> {
                    int index = values.indexOf(info.value) + 1;
                    info.value = values.get(index >= values.size() ? 0 : index);
                    button.m_93666_((Component)func.apply(info.value));
                }, func);
            }
        } else if (screenEntry != null) {
            if (!screenEntry.name().equals("")) {
                info.name = Component.m_237115_((String)screenEntry.name());
            }
            info.screenButton = true;
            info.gotoScreen = (String)(!info.category.isEmpty() ? info.category + "." : "") + field.getName();
        }
        entries.add(info);
    }

    private static void textField(EntryInfo info, Function<String, Number> func, Pattern pattern, double minValue, double maxValue, boolean cast) {
        boolean isNumber = pattern != null;
        info.widget = (editBox, button) -> stringValue -> {
            if (!(stringValue = stringValue.trim()).isEmpty() && isNumber && !pattern.matcher((CharSequence)stringValue).matches()) {
                return false;
            }
            Number value = 0;
            boolean inLimits = false;
            info.error = null;
            if (isNumber && !stringValue.isEmpty() && !stringValue.equals("-") && !stringValue.equals(".")) {
                value = (Number)func.apply((String)stringValue);
                boolean bl = inLimits = value.doubleValue() >= minValue && value.doubleValue() <= maxValue;
                info.error = inLimits ? null : new AbstractMap.SimpleEntry<EditBox, MutableComponent>((EditBox)editBox, Component.m_237115_((String)(value.doubleValue() < minValue ? "\u00a7cMinimum length" + (cast ? " is " + (int)minValue : " is " + minValue) : "\u00a7cMaximum length" + (cast ? " is " + (int)maxValue : " is " + maxValue))));
            }
            info.tempValue = stringValue;
            editBox.m_94202_(inLimits ? -1 : -34953);
            info.inLimits = inLimits;
            button.f_93623_ = entries.stream().allMatch(e -> e.inLimits);
            if (inLimits && info.field.getType() != List.class) {
                info.value = value;
            } else if (inLimits) {
                if (((List)info.value).size() == info.index) {
                    ((List)info.value).add("");
                }
                ((List)info.value).set(info.index, (String)Arrays.stream(info.tempValue.replace("[", "").replace("]", "").split(", ")).collect(Collectors.toList()).get(0));
            }
            return true;
        };
    }

    public static void saveToFile() {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).build();
        try {
            if (!configFilePath.getParent().toFile().exists()) {
                Files.createDirectory(configFilePath.getParent(), new FileAttribute[0]);
            }
            if (!Files.exists(configFilePath, new LinkOption[0])) {
                Files.createFile(configFilePath, new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            LOGGER.info("Failed creating config file for Distant Horizons at the path [" + configFilePath.toString() + "].");
            e.printStackTrace();
        }
        ConfigGui.loadFileWithErrorCheck(config);
        config.set("_version", (Object)1);
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(ConfigAnnotations.Entry.class)) continue;
            editSingleOption.saveOption(info, config);
            if (editSingleOption.getEntry((String)(info.category.isEmpty() ? "" : info.category + ".") + "_" + info.field.getName()) == null) continue;
            config.setComment((String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName(), String.valueOf(editSingleOption.getEntry((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_\u0001"}, (String)(info.category.isEmpty() ? "" : StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001."}, (String)info.category)), (String)info.field.getName()))).defaultValue));
        }
        config.save();
        config.close();
    }

    public static void loadFromFile() {
        CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).autosave().build();
        if (!Files.exists(configFilePath, new LinkOption[0])) {
            LOGGER.info("Config file not found for Distant Horizons. Creating config...");
            ConfigGui.saveToFile();
            return;
        }
        ConfigGui.loadFileWithErrorCheck(config);
        config.set("_version", (Object)1);
        for (EntryInfo info : entries) {
            if (!info.field.isAnnotationPresent(ConfigAnnotations.Entry.class)) continue;
            editSingleOption.loadOption(info, config);
            if (editSingleOption.getEntry((String)(info.category.isEmpty() ? "" : info.category + ".") + "_" + info.field.getName()) == null) continue;
            config.setComment((String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName(), String.valueOf(editSingleOption.getEntry((String)((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001_\u0001"}, (String)(info.category.isEmpty() ? "" : StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001."}, (String)info.category)), (String)info.field.getName()))).defaultValue));
        }
        config.close();
    }

    public static void loadFileWithErrorCheck(CommentedFileConfig config) {
        try {
            config.load();
        }
        catch (Exception e) {
            LOGGER.info("Error loading config for Distant Horizons at the path [" + configFilePath.toString() + "].");
            LOGGER.info("Creating a new config...");
            try {
                Files.deleteIfExists(configFilePath);
                ConfigGui.saveToFile();
            }
            catch (Exception f) {
                LOGGER.info("Failed creating config file for Distant Horizons at the path [" + configFilePath.toString() + "].");
                f.printStackTrace();
            }
        }
    }

    public static Screen getScreen(Screen parent, String category) {
        return new ConfigScreen(parent, category);
    }

    public static class EntryInfo<T> {
        Field field;
        Object widget;
        int width = 0;
        int max;
        Map.Entry<EditBox, Component> error;
        Object defaultValue;
        Object value;
        String tempValue;
        boolean inLimits = true;
        Component name;
        int index;
        boolean hideOption = false;
        boolean screenButton = false;
        String gotoScreen = "";
        String category;
        Class<T> varClass;
        @Deprecated
        boolean fileComment = false;
    }

    public static class editSingleOption {
        public static EntryInfo getEntry(String name) {
            return entryMap.get(name);
        }

        public static void saveOption(String name) {
            editSingleOption.saveOption(entryMap.get(name));
        }

        public static void saveOption(EntryInfo info) {
            CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).autosave().build();
            ConfigGui.loadFileWithErrorCheck(config);
            editSingleOption.saveOption(info, config);
            config.close();
        }

        public static void saveOption(EntryInfo info, CommentedFileConfig config) {
            config.set((String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName(), info.value);
        }

        public static void loadOption(String name) {
            editSingleOption.loadOption(entryMap.get(name));
        }

        public static void loadOption(EntryInfo info) {
            CommentedFileConfig config = (CommentedFileConfig)CommentedFileConfig.builder(configFilePath.toFile()).autosave().build();
            ConfigGui.loadFileWithErrorCheck(config);
            editSingleOption.loadOption(info, config);
            config.close();
        }

        public static void loadOption(EntryInfo info, CommentedFileConfig config) {
            String itemPath = (String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName();
            if (config.contains(itemPath)) {
                if (info.field.getType().isEnum()) {
                    try {
                        info.value = config.getEnum(itemPath, info.varClass);
                    }
                    catch (IllegalArgumentException ignored) {
                        return;
                    }
                } else {
                    info.value = config.get(itemPath);
                }
            } else {
                config.set(itemPath, info.value);
            }
            try {
                info.field.set(null, info.value);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private static class ConfigScreen
    extends Screen {
        private final String translationPrefix;
        private final Screen parent;
        private final String category;
        private ConfigListWidget list;
        private boolean reload = false;

        protected ConfigScreen(Screen parent, String category) {
            super((Component)Component.m_237115_((String)(I18n.m_118936_((String)("DistantHorizons.config" + (String)(category.isEmpty() ? "." + category : "") + ".title")) ? "DistantHorizons.config.title" : "DistantHorizons.config" + (String)(category.isEmpty() ? "" : "." + category) + ".title")));
            this.parent = parent;
            this.category = category;
            this.translationPrefix = "DistantHorizons.config.";
        }

        public void m_86600_() {
            super.m_86600_();
        }

        public void m_7379_() {
            ConfigGui.saveToFile();
            Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
        }

        private Button addBtn(Button button) {
            this.m_142416_((GuiEventListener)button);
            return button;
        }

        protected void m_7856_() {
            super.m_7856_();
            if (!this.reload) {
                ConfigGui.loadFromFile();
            }
            this.addBtn(new Button(this.f_96543_ / 2 - 154, this.f_96544_ - 28, 150, 20, CommonComponents.f_130656_, button -> {
                ConfigGui.loadFromFile();
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }));
            Button done = this.addBtn(new Button(this.f_96543_ / 2 + 4, this.f_96544_ - 28, 150, 20, CommonComponents.f_130655_, button -> {
                ConfigGui.saveToFile();
                Objects.requireNonNull(this.f_96541_).m_91152_(this.parent);
            }));
            this.list = new ConfigListWidget(this.f_96541_, this.f_96543_ * 2, this.f_96544_, 32, this.f_96544_ - 32, 25);
            if (this.f_96541_ != null && this.f_96541_.f_91073_ != null) {
                this.list.m_93488_(false);
            }
            this.m_7787_((GuiEventListener)this.list);
            for (EntryInfo info : entries) {
                Predicate processor;
                Map.Entry widget;
                if (!info.category.matches(this.category) || info.hideOption) continue;
                Component name = info.name == null ? Component.m_237115_((String)(this.translationPrefix + (String)(!info.category.isEmpty() ? info.category + "." : "") + info.field.getName())) : info.name;
                Button resetButton = new Button(this.f_96543_ - 10 - info.width - 5 - 40, 0, 40, 20, (Component)Component.m_237115_((String)"Reset").m_130940_(ChatFormatting.RED), button -> {
                    info.value = info.defaultValue;
                    info.tempValue = info.defaultValue.toString();
                    info.index = 0;
                    this.reload = true;
                    Objects.requireNonNull(this.f_96541_).m_91152_((Screen)this);
                });
                if (info.widget instanceof Map.Entry) {
                    widget = (Map.Entry)info.widget;
                    if (info.field.getType().isEnum()) {
                        widget.setValue(value -> Component.m_237115_((String)(this.translationPrefix + "enum." + info.field.getType().getSimpleName() + "." + info.value.toString())));
                    }
                    this.list.addButton((AbstractWidget)new Button(this.f_96543_ - info.width - 10, 0, info.width, 20, (Component)((Function)widget.getValue()).apply(info.value), (Button.OnPress)widget.getKey()), (AbstractWidget)resetButton, null, name);
                    continue;
                }
                if (info.field.getType() == List.class) {
                    if (!this.reload) {
                        info.index = 0;
                    }
                    widget = new EditBox(this.f_96547_, this.f_96543_ - info.width - 10, 0, info.width, 20, null);
                    widget.m_94199_(info.width);
                    if (info.index < ((List)info.value).size()) {
                        widget.m_94164_(String.valueOf(((List)info.value).get(info.index)));
                    } else {
                        widget.m_94164_("");
                    }
                    processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                    widget.m_94153_(processor);
                    resetButton.m_93674_(20);
                    resetButton.m_93666_((Component)Component.m_237115_((String)"R").m_130940_(ChatFormatting.RED));
                    Button cycleButton = new Button(this.f_96543_ - 185, 0, 20, 20, (Component)Component.m_237115_((String)String.valueOf(info.index)).m_130940_(ChatFormatting.GOLD), button -> {
                        ((List)info.value).remove("");
                        this.reload = true;
                        ++info.index;
                        if (info.index > ((List)info.value).size()) {
                            info.index = 0;
                        }
                        Objects.requireNonNull(this.f_96541_).m_91152_((Screen)this);
                    });
                    this.list.addButton((AbstractWidget)widget, (AbstractWidget)resetButton, (AbstractWidget)cycleButton, name);
                    continue;
                }
                if (info.widget != null) {
                    widget = new EditBox(this.f_96547_, this.f_96543_ - info.width - 10 + 2, 0, info.width - 4, 20, null);
                    widget.m_94199_(info.width);
                    widget.m_94164_(String.valueOf(info.value));
                    processor = (Predicate)((BiFunction)info.widget).apply(widget, done);
                    widget.m_94153_(processor);
                    this.list.addButton((AbstractWidget)widget, (AbstractWidget)resetButton, null, name);
                    continue;
                }
                if (info.screenButton) {
                    widget = new Button(this.f_96543_ / 2 - info.width, this.f_96544_ - 28, info.width * 2, 20, name, button -> {
                        ConfigGui.saveToFile();
                        Objects.requireNonNull(this.f_96541_).m_91152_(ConfigGui.getScreen(this, info.gotoScreen));
                    });
                    this.list.addButton((AbstractWidget)widget, null, null, null);
                    continue;
                }
                if (info.fileComment) continue;
                this.list.addButton(null, null, null, name);
            }
        }

        public void m_6305_(PoseStack matrices, int mouseX, int mouseY, float delta) {
            this.m_7333_(matrices);
            this.list.m_6305_(matrices, mouseX, mouseY, delta);
            ConfigScreen.m_93215_((PoseStack)matrices, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)15, (int)0xFFFFFF);
            for (EntryInfo info : entries) {
                if (!info.category.matches(this.category) || info.hideOption || !this.list.getHoveredButton(mouseX, mouseY).isPresent()) continue;
                AbstractWidget buttonWidget = this.list.getHoveredButton(mouseX, mouseY).get();
                Component text = ButtonEntry.buttonsWithText.get(buttonWidget);
                MutableComponent name = Component.m_237115_((String)(this.translationPrefix + (String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName()));
                String key = this.translationPrefix + (String)(info.category.isEmpty() ? "" : info.category + ".") + info.field.getName() + ".@tooltip";
                if (info.error != null && text.equals(name)) {
                    this.m_96602_(matrices, info.error.getValue(), mouseX, mouseY);
                    continue;
                }
                if (!I18n.m_118936_((String)key) || text == null || !text.equals(name)) continue;
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                for (String str : I18n.m_118938_((String)key, (Object[])new Object[0]).split("\n")) {
                    list.add(Component.m_237115_((String)str));
                }
                this.m_96597_(matrices, list, mouseX, mouseY);
            }
            super.m_6305_(matrices, mouseX, mouseY, delta);
        }
    }

    public static class ButtonEntry
    extends ContainerObjectSelectionList.Entry<ButtonEntry> {
        private static final Font textRenderer = Minecraft.m_91087_().f_91062_;
        public final AbstractWidget button;
        private final AbstractWidget resetButton;
        private final AbstractWidget indexButton;
        private final Component text;
        private final List<AbstractWidget> children = new ArrayList<AbstractWidget>();
        public static final Map<AbstractWidget, Component> buttonsWithText = new HashMap<AbstractWidget, Component>();

        private ButtonEntry(AbstractWidget button, Component text, AbstractWidget resetButton, AbstractWidget indexButton) {
            buttonsWithText.put(button, text);
            this.button = button;
            this.resetButton = resetButton;
            this.text = text;
            this.indexButton = indexButton;
            if (button != null) {
                this.children.add(button);
            }
            if (resetButton != null) {
                this.children.add(resetButton);
            }
            if (indexButton != null) {
                this.children.add(indexButton);
            }
        }

        public static ButtonEntry create(AbstractWidget button, Component text, AbstractWidget resetButton, AbstractWidget indexButton) {
            return new ButtonEntry(button, text, resetButton, indexButton);
        }

        public void m_6311_(PoseStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            if (this.button != null) {
                this.button.f_93621_ = y;
                this.button.m_6305_(matrices, mouseX, mouseY, tickDelta);
            }
            if (this.resetButton != null) {
                this.resetButton.f_93621_ = y;
                this.resetButton.m_6305_(matrices, mouseX, mouseY, tickDelta);
            }
            if (this.indexButton != null) {
                this.indexButton.f_93621_ = y;
                this.indexButton.m_6305_(matrices, mouseX, mouseY, tickDelta);
            }
            if (!(this.text == null || this.text.getString().contains("spacer") && this.button == null)) {
                GuiComponent.m_93243_((PoseStack)matrices, (Font)textRenderer, (Component)this.text, (int)12, (int)(y + 5), (int)0xFFFFFF);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.children;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return this.children;
        }
    }

    public static class ConfigListWidget
    extends ContainerObjectSelectionList<ButtonEntry> {
        Font textRenderer;

        public ConfigListWidget(Minecraft minecraftClient, int i, int j, int k, int l, int m) {
            super(minecraftClient, i, j, k, l, m);
            this.f_93394_ = false;
            this.textRenderer = minecraftClient.f_91062_;
        }

        public void addButton(AbstractWidget button, AbstractWidget resetButton, AbstractWidget indexButton, Component text) {
            this.m_7085_((AbstractSelectionList.Entry)ButtonEntry.create(button, text, resetButton, indexButton));
        }

        public int m_5759_() {
            return 10000;
        }

        public Optional<AbstractWidget> getHoveredButton(double mouseX, double mouseY) {
            for (ButtonEntry buttonEntry : this.m_6702_()) {
                if (buttonEntry.button == null || !buttonEntry.button.m_5953_(mouseX, mouseY)) continue;
                return Optional.of(buttonEntry.button);
            }
            return Optional.empty();
        }
    }

    private static class ConfigScreenConfigs {
        public static final int SpaceFromRightScreen = 10;
        public static final int ButtonWidthSpacing = 5;
        public static final int ResetButtonWidth = 40;

        private ConfigScreenConfigs() {
        }
    }
}

