/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.networking;

import io.netty.buffer.Unpooled;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class Networking {
    public static final ResourceLocation resourceLocation_meow = new ResourceLocation("lod", "meow");

    public static FriendlyByteBuf createNew() {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        buf.writeInt(1);
        return buf;
    }

    public static void send(ServerPlayer player, FriendlyByteBuf buf) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(resourceLocation_meow, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Packet byte buf cannot be null");
        player.f_8906_.m_9829_(Networking.createS2CPacket(resourceLocation_meow, buf));
    }

    public static void send(FriendlyByteBuf buf) throws IllegalStateException {
        if (Minecraft.m_91087_().m_91403_() != null) {
            Minecraft.m_91087_().m_91403_().m_104955_(Networking.createC2SPacket(resourceLocation_meow, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    public static Packet<?> createS2CPacket(ResourceLocation channelName, FriendlyByteBuf buf) {
        Objects.requireNonNull(channelName, "Channel cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return Networking.createPlayS2CPacket(channelName, buf);
    }

    public static Packet<?> createPlayS2CPacket(ResourceLocation channel, FriendlyByteBuf buf) {
        return new ClientboundCustomPayloadPacket(channel, buf);
    }

    public static Packet<?> createC2SPacket(ResourceLocation channelName, FriendlyByteBuf buf) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return Networking.createPlayC2SPacket(channelName, buf);
    }

    public static Packet<?> createPlayC2SPacket(ResourceLocation channelName, FriendlyByteBuf buf) {
        return new ServerboundCustomPayloadPacket(channelName, buf);
    }
}

