/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.util;

import com.seibel.lod.core.logging.SpamReducedLogger;
import com.seibel.lod.core.util.ColorUtil;
import java.util.Arrays;

public class DataPointUtil {
    public static final int EMPTY_DATA = 0;
    public static final int MAX_WORLD_Y_SIZE = 4096;
    public static final int ALPHA_DOWNSIZE_SHIFT = 4;
    public static final int GEN_TYPE_SHIFT = 60;
    public static final int COLOR_SHIFT = 32;
    public static final int BLUE_SHIFT = 32;
    public static final int GREEN_SHIFT = 40;
    public static final int RED_SHIFT = 48;
    public static final int ALPHA_SHIFT = 56;
    public static final int HEIGHT_SHIFT = 20;
    public static final int DEPTH_SHIFT = 8;
    public static final int BLOCK_LIGHT_SHIFT = 4;
    public static final int SKY_LIGHT_SHIFT = 0;
    public static final long ALPHA_MASK = 15L;
    public static final long RED_MASK = 255L;
    public static final long GREEN_MASK = 255L;
    public static final long BLUE_MASK = 255L;
    public static final long COLOR_MASK = 0xFFFFFFL;
    public static final long HEIGHT_MASK = 4095L;
    public static final long DEPTH_MASK = 4095L;
    public static final long HEIGHT_DEPTH_MASK = 0xFFFFFFL;
    public static final long BLOCK_LIGHT_MASK = 15L;
    public static final long SKY_LIGHT_MASK = 15L;
    public static final long GEN_TYPE_MASK = 7L;
    public static final long COMPARE_SHIFT = 60L;
    public static final long HEIGHT_SHIFTED_MASK = 0xFFF00000L;
    public static final long DEPTH_SHIFTED_MASK = 1048320L;
    public static final long VOID_SETTER = 0xFFFFFF00L;
    private static final SpamReducedLogger warnLogger = new SpamReducedLogger(1);
    private static final ThreadLocal<short[]> tLocalHeightAndDepth = new ThreadLocal();
    private static final ThreadLocal<long[]> tMaxVerticalData = new ThreadLocal();

    public static long createVoidDataPoint(byte generationMode) {
        if (generationMode == 0) {
            throw new IllegalArgumentException("Trying to create void datapoint with genMode 0, which is NOT allowed in DataPoint version 10!");
        }
        return ((long)generationMode & 7L) << 60;
    }

    public static long createDataPoint(int height, int depth, int color, int lightSky, int lightBlock, int generationMode) {
        return DataPointUtil.createDataPoint(ColorUtil.getAlpha(color), ColorUtil.getRed(color), ColorUtil.getGreen(color), ColorUtil.getBlue(color), height, depth, lightSky, lightBlock, generationMode);
    }

    public static long createDataPoint(int alpha, int red, int green, int blue, int height, int depth, int lightSky, int lightBlock, int generationMode) {
        if (generationMode == 0) {
            throw new IllegalArgumentException("Trying to create datapoint with genMode 0, which is NOT allowed in DataPoint version 10!");
        }
        if (height < 0 || height > 4096) {
            throw new IllegalArgumentException("Height must be between 0 and 4096!");
        }
        if (depth < 0 || depth > 4096) {
            throw new IllegalArgumentException("Depth must be between 0 and 4096!");
        }
        if (lightSky < 0 || lightSky > 15) {
            throw new IllegalArgumentException("Sky light must be between 0 and 15!");
        }
        if (lightBlock < 0 || lightBlock > 15) {
            throw new IllegalArgumentException("Block light must be between 0 and 15!");
        }
        if (alpha < 0 || alpha > 255) {
            throw new IllegalArgumentException("Alpha must be between 0 and 255!");
        }
        if (red < 0 || red > 255) {
            throw new IllegalArgumentException("Red must be between 0 and 255!");
        }
        if (green < 0 || green > 255) {
            throw new IllegalArgumentException("Green must be between 0 and 255!");
        }
        if (blue < 0 || blue > 255) {
            throw new IllegalArgumentException("Blue must be between 0 and 255!");
        }
        if (generationMode < 0 || generationMode > 7) {
            throw new IllegalArgumentException("Generation mode must be between 0 and 7!");
        }
        if (depth > height) {
            throw new IllegalArgumentException("Depth must be less than or equal to height!");
        }
        return (long)(alpha >>> 4) << 56 | ((long)red & 0xFFL) << 48 | ((long)green & 0xFFL) << 40 | ((long)blue & 0xFFL) << 32 | ((long)height & 0xFFFL) << 20 | ((long)depth & 0xFFFL) << 8 | ((long)lightBlock & 0xFL) << 4 | ((long)lightSky & 0xFL) << 0 | ((long)generationMode & 7L) << 60;
    }

    public static long shiftHeightAndDepth(long dataPoint, short offset) {
        long height = dataPoint + ((long)offset << 20) & 0xFFF00000L;
        long depth = dataPoint + (long)(offset << 8) & 0xFFF00L;
        return dataPoint & 0xFFFFFFFF000000FFL | height | depth;
    }

    public static long version9Reorder(long dataPoint) {
        if ((dataPoint & 1L) == 0L) {
            return 0L;
        }
        long height = dataPoint >>> 26 & 0x3FFL;
        long depth = dataPoint >>> 16 & 0x3FFL;
        if (height == depth || (dataPoint & 2L) == 2L) {
            return DataPointUtil.createVoidDataPoint((byte)((dataPoint >>> 2 & 7L) + 1L));
        }
        return (dataPoint >>> 60 & 0xFL) << 56 | (dataPoint >>> 52 & 0xFFL) << 48 | (dataPoint >>> 44 & 0xFFL) << 40 | (dataPoint >>> 36 & 0xFFL) << 32 | (dataPoint >>> 26 & 0x3FFL) << 20 | (dataPoint >>> 16 & 0x3FFL) << 8 | (dataPoint >>> 8 & 0xFFL) << 0 | (dataPoint >>> 2 & 0xFFL) + 1L << 60;
    }

    public static short getHeight(long dataPoint) {
        return (short)(dataPoint >>> 20 & 0xFFFL);
    }

    public static short getDepth(long dataPoint) {
        return (short)(dataPoint >>> 8 & 0xFFFL);
    }

    public static short getAlpha(long dataPoint) {
        return (short)((dataPoint >>> 56 & 0xFL) << 4 | 0xFL);
    }

    public static short getRed(long dataPoint) {
        return (short)(dataPoint >>> 48 & 0xFFL);
    }

    public static short getGreen(long dataPoint) {
        return (short)(dataPoint >>> 40 & 0xFFL);
    }

    public static short getBlue(long dataPoint) {
        return (short)(dataPoint >>> 32 & 0xFFL);
    }

    public static byte getLightSky(long dataPoint) {
        return (byte)(dataPoint >>> 0 & 0xFL);
    }

    public static byte getLightBlock(long dataPoint) {
        return (byte)(dataPoint >>> 4 & 0xFL);
    }

    public static byte getGenerationMode(long dataPoint) {
        byte genMode = (byte)(dataPoint >>> 60 & 7L);
        if (warnLogger.canMaybeLog() && DataPointUtil.doesItExist(dataPoint) && genMode == 0) {
            warnLogger.warnInc("Existing datapoint with genMode 0 detected! This is invalid in DataPoint version 10! This may be caused by old data that has not been updated correctly.", new Object[0]);
            return 1;
        }
        return genMode == 0 ? (byte)1 : genMode;
    }

    public static boolean isVoid(long dataPoint) {
        return (dataPoint >>> 8 & 0xFFFFFFL) == 0L;
    }

    public static boolean doesItExist(long dataPoint) {
        return dataPoint != 0L;
    }

    public static int getColor(long dataPoint) {
        long alpha = DataPointUtil.getAlpha(dataPoint);
        return (int)(dataPoint >>> 32 & 0xFFFFFFL | alpha << 24);
    }

    public static String toString(long dataPoint) {
        return DataPointUtil.getHeight(dataPoint) + " " + DataPointUtil.getDepth(dataPoint) + " " + DataPointUtil.getAlpha(dataPoint) + " " + DataPointUtil.getRed(dataPoint) + " " + DataPointUtil.getBlue(dataPoint) + " " + DataPointUtil.getGreen(dataPoint) + " " + DataPointUtil.getLightBlock(dataPoint) + " " + DataPointUtil.getLightSky(dataPoint) + " " + DataPointUtil.getGenerationMode(dataPoint) + " " + DataPointUtil.isVoid(dataPoint) + " " + DataPointUtil.doesItExist(dataPoint) + '\n';
    }

    public static void shrinkArray(short[] array, int packetSize, int start, int length, int arraySize) {
        length *= packetSize;
        if ((arraySize *= packetSize) - (start *= packetSize) >= 0) {
            System.arraycopy(array, start + length, array, start, arraySize - start);
        }
    }

    public static void extendArray(short[] array, int packetSize, int start, int length, int arraySize) {
        length *= packetSize;
        for (int i = (arraySize *= packetSize) - (start *= packetSize) - 1; i >= 0; --i) {
            array[start + length + i] = array[start + i];
            array[start + i] = 0;
        }
    }

    public static int compareDatapointPriority(long dataA, long dataB) {
        return (int)((dataA >> 60) - (dataB >> 60));
    }

    public static boolean mergeTwoDataArray(long[] target, long[] newData, int verticalDataSize) {
        boolean anyChange = false;
        for (int i = 0; i < target.length && i < newData.length; i += verticalDataSize) {
            if (DataPointUtil.compareDatapointPriority(newData[i], target[i]) <= 0) continue;
            anyChange = true;
            System.arraycopy(newData, i, target, i, verticalDataSize);
        }
        return anyChange;
    }

    public static boolean mergeTwoDataArray(long[] target, int targetOffset, long[] newData, int newDataOffset, int dataLength, int verticalDataSize, boolean override) {
        if (targetOffset + verticalDataSize * dataLength > target.length) {
            throw new ArrayIndexOutOfBoundsException("\"target\" array index out of bounds");
        }
        if (newDataOffset + verticalDataSize * dataLength > newData.length) {
            throw new ArrayIndexOutOfBoundsException("\"newData\" array index out of bounds");
        }
        boolean anyChange = false;
        for (int o = 0; o < dataLength * verticalDataSize; o += verticalDataSize) {
            if (override) {
                if (DataPointUtil.compareDatapointPriority(newData[o + newDataOffset], target[o + targetOffset]) < 0) continue;
                anyChange = true;
                System.arraycopy(newData, o + newDataOffset, target, o + targetOffset, verticalDataSize);
                continue;
            }
            if (DataPointUtil.compareDatapointPriority(newData[o + newDataOffset], target[o + targetOffset]) <= 0) continue;
            anyChange = true;
            System.arraycopy(newData, o + newDataOffset, target, o + targetOffset, verticalDataSize);
        }
        return anyChange;
    }

    public static long[] extractDataArray(long[] source, int inWidth, int inHeight, int outX, int outY, int outWidth, int outHeight) {
        int dataSetSize = source.length / inWidth / inHeight;
        if (dataSetSize * inWidth * inHeight != source.length) {
            throw new ArrayIndexOutOfBoundsException("\"source\" array invalid width and height");
        }
        if (outWidth > inWidth || outX + outWidth > inWidth) {
            throw new ArrayIndexOutOfBoundsException("X index out of bounds");
        }
        if (outHeight > inHeight || outY + outHeight > inHeight) {
            throw new ArrayIndexOutOfBoundsException("Y index out of bounds");
        }
        long[] out = new long[dataSetSize * outWidth * outHeight];
        for (int x = 0; x < outWidth; ++x) {
            System.arraycopy(source, ((outX + x) * inHeight + outY) * dataSetSize, out, x * outHeight * dataSetSize, outHeight * dataSetSize);
        }
        return out;
    }

    public static long[] changeMaxVertSize(long[] source, int sourceVertSize, int targetVertSize) {
        if (source.length % sourceVertSize != 0) {
            throw new ArrayIndexOutOfBoundsException("\"source\" array invalid vertical size or length");
        }
        if (sourceVertSize == targetVertSize) {
            return source;
        }
        if (sourceVertSize > targetVertSize) {
            int size = source.length / sourceVertSize;
            long[] dataToMerge = new long[sourceVertSize];
            long[] newData = new long[size * targetVertSize];
            for (int i = 0; i < size; ++i) {
                System.arraycopy(source, i * sourceVertSize, dataToMerge, 0, sourceVertSize);
                long[] tempBuffer = DataPointUtil.mergeMultiData(dataToMerge, sourceVertSize, targetVertSize);
                System.arraycopy(tempBuffer, 0, newData, i * targetVertSize, targetVertSize);
            }
            return newData;
        }
        int size = source.length / sourceVertSize;
        long[] newData = new long[size * targetVertSize];
        for (int i = 0; i < size; ++i) {
            System.arraycopy(source, i * sourceVertSize, newData, i * targetVertSize, sourceVertSize);
        }
        return newData;
    }

    public static long[] mergeMultiData(long[] dataToMerge, int inputVerticalData, int maxVerticalData) {
        int i;
        short height;
        short depth;
        long singleData;
        int dataIndex;
        int size = dataToMerge.length / inputVerticalData;
        int heightAndDepthLength = 4128;
        short[] heightAndDepth = tLocalHeightAndDepth.get();
        if (heightAndDepth == null || heightAndDepth.length != heightAndDepthLength) {
            heightAndDepth = new short[heightAndDepthLength];
            tLocalHeightAndDepth.set(heightAndDepth);
        }
        int dataPointLength = maxVerticalData;
        long[] dataPoint = tMaxVerticalData.get();
        if (dataPoint == null || dataPoint.length != dataPointLength) {
            dataPoint = new long[dataPointLength];
            tMaxVerticalData.set(dataPoint);
        } else {
            Arrays.fill(dataPoint, 0L);
        }
        byte genMode = DataPointUtil.getGenerationMode(dataToMerge[0]);
        if (genMode == 0) {
            genMode = 1;
        }
        boolean allEmpty = true;
        boolean allVoid = true;
        boolean limited = false;
        int count = 0;
        for (int index = 0; index < size; ++index) {
            if (index == 0) {
                for (dataIndex = 0; dataIndex < inputVerticalData && DataPointUtil.doesItExist(singleData = dataToMerge[dataIndex]); ++dataIndex) {
                    allEmpty = false;
                    if (DataPointUtil.isVoid(singleData)) continue;
                    allVoid = false;
                    ++count;
                    heightAndDepth[dataIndex * 2] = DataPointUtil.getHeight(singleData);
                    heightAndDepth[dataIndex * 2 + 1] = DataPointUtil.getDepth(singleData);
                }
                continue;
            }
            for (dataIndex = 0; dataIndex < inputVerticalData && DataPointUtil.doesItExist(singleData = dataToMerge[index * inputVerticalData + dataIndex]); ++dataIndex) {
                allEmpty = false;
                if (DataPointUtil.isVoid(singleData)) continue;
                allVoid = false;
                depth = DataPointUtil.getDepth(singleData);
                height = DataPointUtil.getHeight(singleData);
                int botPos = -1;
                int topPos = -1;
                boolean botExtend = false;
                boolean topExtend = false;
                for (i = 0; i < count; ++i) {
                    if (depth < heightAndDepth[i * 2] && depth >= heightAndDepth[i * 2 + 1]) {
                        botPos = i;
                        break;
                    }
                    if (depth >= heightAndDepth[i * 2 + 1] || (i + 1 >= count || depth < heightAndDepth[(i + 1) * 2]) && i + 1 != count) continue;
                    botPos = i;
                    botExtend = true;
                    break;
                }
                for (i = 0; i < count; ++i) {
                    if (height <= heightAndDepth[i * 2] && height > heightAndDepth[i * 2 + 1]) {
                        topPos = i;
                        break;
                    }
                    if (height > heightAndDepth[i * 2 + 1] || (i + 1 >= count || height <= heightAndDepth[(i + 1) * 2]) && i + 1 != count) continue;
                    topPos = i;
                    topExtend = true;
                    break;
                }
                if (topPos == -1) {
                    if (botPos == -1) {
                        DataPointUtil.extendArray(heightAndDepth, 2, 0, 1, count);
                        heightAndDepth[0] = height;
                        heightAndDepth[1] = depth;
                        ++count;
                        continue;
                    }
                    if (!botExtend) {
                        DataPointUtil.shrinkArray(heightAndDepth, 2, 0, botPos, count);
                        heightAndDepth[0] = height;
                        count -= botPos;
                        continue;
                    }
                    DataPointUtil.shrinkArray(heightAndDepth, 2, 0, botPos, count);
                    heightAndDepth[0] = height;
                    heightAndDepth[1] = depth;
                    count -= botPos;
                    continue;
                }
                if (!topExtend) {
                    heightAndDepth[topPos * 2 + 1] = !botExtend ? heightAndDepth[botPos * 2 + 1] : depth;
                    DataPointUtil.shrinkArray(heightAndDepth, 2, topPos + 1, botPos - topPos, count);
                    count -= botPos - topPos;
                    continue;
                }
                if (!botExtend) {
                    heightAndDepth[++topPos * 2] = height;
                    heightAndDepth[topPos * 2 + 1] = heightAndDepth[botPos * 2 + 1];
                    DataPointUtil.shrinkArray(heightAndDepth, 2, topPos + 1, botPos - topPos, count);
                    count -= botPos - topPos;
                    continue;
                }
                DataPointUtil.shrinkArray(heightAndDepth, 2, topPos + 1, botPos - topPos, count);
                DataPointUtil.extendArray(heightAndDepth, 2, topPos + 1, 1, count -= botPos - topPos);
                ++count;
                heightAndDepth[topPos * 2 + 2] = height;
                heightAndDepth[topPos * 2 + 3] = depth;
            }
        }
        if (allEmpty) {
            return dataPoint;
        }
        if (allVoid) {
            dataPoint[0] = DataPointUtil.createVoidDataPoint(genMode);
            return dataPoint;
        }
        int j = 0;
        while (count > maxVerticalData) {
            limited = true;
            int ii = 4096;
            for (i = 0; i < count - 1; ++i) {
                if (heightAndDepth[i * 2 + 1] - heightAndDepth[(i + 1) * 2] > ii) continue;
                ii = heightAndDepth[i * 2 + 1] - heightAndDepth[(i + 1) * 2];
                j = i;
            }
            heightAndDepth[j * 2 + 1] = heightAndDepth[(j + 1) * 2 + 1];
            for (i = j + 1; i < count - 1; ++i) {
                heightAndDepth[i * 2] = heightAndDepth[(i + 1) * 2];
                heightAndDepth[i * 2 + 1] = heightAndDepth[(i + 1) * 2 + 1];
            }
            --count;
        }
        if (!limited && size == 1) {
            for (j = 0; j < count; ++j) {
                dataPoint[j] = dataToMerge[j];
            }
        } else {
            for (j = 0; j < count; ++j) {
                height = heightAndDepth[j * 2];
                depth = heightAndDepth[j * 2 + 1];
                if ((depth != 0 || height != 0) && j < heightAndDepth.length / 2) {
                    int numberOfChildren = 0;
                    int tempAlpha = 0;
                    int tempRed = 0;
                    int tempGreen = 0;
                    int tempBlue = 0;
                    int tempLightBlock = 0;
                    int tempLightSky = 0;
                    allEmpty = true;
                    allVoid = true;
                    long data = 0L;
                    for (int index = 0; index < size; ++index) {
                        for (dataIndex = 0; dataIndex < inputVerticalData && DataPointUtil.doesItExist(singleData = dataToMerge[index * inputVerticalData + dataIndex]) && !DataPointUtil.isVoid(singleData); ++dataIndex) {
                            if ((depth > DataPointUtil.getDepth(singleData) || DataPointUtil.getDepth(singleData) >= height) && (depth >= DataPointUtil.getHeight(singleData) || DataPointUtil.getHeight(singleData) > height)) continue;
                            data = singleData;
                            break;
                        }
                        if (!DataPointUtil.doesItExist(data)) {
                            singleData = dataToMerge[index * inputVerticalData];
                            data = DataPointUtil.createVoidDataPoint(genMode);
                        }
                        if (!DataPointUtil.doesItExist(data)) continue;
                        allEmpty = false;
                        if (DataPointUtil.isVoid(data)) continue;
                        ++numberOfChildren;
                        allVoid = false;
                        tempAlpha = Math.max(DataPointUtil.getAlpha(data), tempAlpha);
                        tempRed += DataPointUtil.getRed(data) * DataPointUtil.getRed(data);
                        tempGreen += DataPointUtil.getGreen(data) * DataPointUtil.getGreen(data);
                        tempBlue += DataPointUtil.getBlue(data) * DataPointUtil.getBlue(data);
                        tempLightBlock += DataPointUtil.getLightBlock(data);
                        tempLightSky += DataPointUtil.getLightSky(data);
                    }
                    if (allEmpty) {
                        dataPoint[j] = 0L;
                        continue;
                    }
                    if (allVoid) {
                        dataPoint[j] = DataPointUtil.createVoidDataPoint(genMode);
                        continue;
                    }
                    if (size != 1) {
                        tempRed /= numberOfChildren;
                        tempGreen /= numberOfChildren;
                        tempBlue /= numberOfChildren;
                        tempLightBlock /= numberOfChildren;
                        tempLightSky /= numberOfChildren;
                    }
                    dataPoint[j] = DataPointUtil.createDataPoint((int)Math.sqrt(tempAlpha), (int)Math.sqrt(tempRed), (int)Math.sqrt(tempGreen), (int)Math.sqrt(tempBlue), height, depth, tempLightSky, tempLightBlock, genMode);
                    continue;
                }
                break;
            }
        }
        return dataPoint;
    }
}

