/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.render.objects;

import com.seibel.lod.core.objects.math.Mat4f;
import com.seibel.lod.core.objects.math.Vec3d;
import com.seibel.lod.core.objects.math.Vec3f;
import com.seibel.lod.core.render.objects.Shader;
import java.awt.Color;
import java.nio.FloatBuffer;
import java.util.function.Supplier;
import org.lwjgl.opengl.GL32;
import org.lwjgl.system.MemoryStack;

public class ShaderProgram {
    public final int id;

    public ShaderProgram(String vert, String frag, String fragDataOutputName, String[] attributes) {
        this(() -> Shader.loadFile(vert, false, new StringBuilder()).toString(), () -> Shader.loadFile(frag, false, new StringBuilder()).toString(), fragDataOutputName, attributes);
    }

    public ShaderProgram(Supplier<String> vert, Supplier<String> frag, String fragDataOutputName, String[] attributes) {
        Shader vertShader = new Shader(35633, vert.get());
        Shader fragShader = new Shader(35632, frag.get());
        this.id = GL32.glCreateProgram();
        GL32.glAttachShader((int)this.id, (int)vertShader.id);
        GL32.glAttachShader((int)this.id, (int)fragShader.id);
        for (int i = 0; i < attributes.length; ++i) {
            GL32.glBindAttribLocation((int)this.id, (int)i, (CharSequence)attributes[i]);
        }
        GL32.glLinkProgram((int)this.id);
        vertShader.free();
        fragShader.free();
        int status = GL32.glGetProgrami((int)this.id, (int)35714);
        if (status != 1) {
            String message = "Shader Link Error. Details: " + GL32.glGetProgramInfoLog((int)this.id);
            this.free();
            throw new RuntimeException(message);
        }
        GL32.glUseProgram((int)this.id);
    }

    public void bind() {
        GL32.glUseProgram((int)this.id);
    }

    public void unbind() {
        GL32.glUseProgram((int)0);
    }

    public void free() {
        GL32.glDeleteProgram((int)this.id);
    }

    public int getAttributeLocation(CharSequence name) {
        int i = GL32.glGetAttribLocation((int)this.id, (CharSequence)name);
        if (i == -1) {
            throw new RuntimeException("Attribute name not found: " + name);
        }
        return i;
    }

    public int tryGetAttributeLocation(CharSequence name) {
        return GL32.glGetAttribLocation((int)this.id, (CharSequence)name);
    }

    public int getUniformLocation(CharSequence name) {
        int i = GL32.glGetUniformLocation((int)this.id, (CharSequence)name);
        if (i == -1) {
            throw new RuntimeException("Uniform name not found: " + name);
        }
        return i;
    }

    public int tryGetUniformLocation(CharSequence name) {
        return GL32.glGetUniformLocation((int)this.id, (CharSequence)name);
    }

    public void setUniform(int location, boolean value) {
        GL32.glUniform1i((int)location, (int)(value ? 1 : 0));
    }

    public void setUniform(int location, int value) {
        GL32.glUniform1i((int)location, (int)value);
    }

    public void setUniform(int location, float value) {
        GL32.glUniform1f((int)location, (float)value);
    }

    public void setUniform(int location, Vec3f value) {
        GL32.glUniform3f((int)location, (float)value.x, (float)value.y, (float)value.z);
    }

    public void setUniform(int location, Vec3d value) {
        GL32.glUniform3f((int)location, (float)((float)value.x), (float)((float)value.y), (float)((float)value.z));
    }

    public void setUniform(int location, Mat4f value) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            FloatBuffer buffer = stack.mallocFloat(16);
            value.store(buffer);
            GL32.glUniformMatrix4fv((int)location, (boolean)false, (FloatBuffer)buffer);
        }
    }

    public void setUniform(int location, Color value) {
        GL32.glUniform4f((int)location, (float)((float)value.getRed() / 256.0f), (float)((float)value.getGreen() / 256.0f), (float)((float)value.getBlue() / 256.0f), (float)((float)value.getAlpha() / 256.0f));
    }
}

