/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.enums.config;

public enum VerticalQuality {
    LOW(new int[]{4, 2, 2, 2, 2, 1, 1, 1, 1, 1, 1}, 2),
    MEDIUM(new int[]{6, 4, 3, 2, 2, 1, 1, 1, 1, 1, 1}, 4),
    HIGH(new int[]{8, 6, 4, 2, 2, 2, 2, 1, 1, 1, 1}, 6),
    ULTRA(new int[]{16, 8, 4, 2, 2, 2, 2, 1, 1, 1, 1}, 12);

    public final int[] maxVerticalData;
    @Deprecated
    public final int maxConnectedLods;

    private VerticalQuality(int[] maxVerticalData, int maxConnectedLods) {
        this.maxVerticalData = maxVerticalData;
        this.maxConnectedLods = maxConnectedLods;
    }

    public static VerticalQuality previous(VerticalQuality mode) {
        switch (mode) {
            case ULTRA: {
                return HIGH;
            }
            case HIGH: {
                return MEDIUM;
            }
            case MEDIUM: {
                return LOW;
            }
        }
        return null;
    }

    public static VerticalQuality next(VerticalQuality mode) {
        switch (mode) {
            case MEDIUM: {
                return HIGH;
            }
            case LOW: {
                return MEDIUM;
            }
            case HIGH: {
                return ULTRA;
            }
        }
        return null;
    }

    public static VerticalQuality getByName(String name) {
        switch (name.toUpperCase()) {
            case "ULTRA": {
                return ULTRA;
            }
            case "HIGH": {
                return HIGH;
            }
            case "MEDIUM": {
                return MEDIUM;
            }
            case "LOW": {
                return LOW;
            }
        }
        return null;
    }
}

