/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.tweakeroo.Tweakeroo;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.tweaks.PlacementTweaks;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.class_1268;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1738;
import net.minecraft.class_1770;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2868;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_6019;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class InventoryUtils {
    private static final List<class_1304> REPAIR_MODE_SLOTS = new ArrayList<class_1304>();
    private static final List<Integer> REPAIR_MODE_SLOT_NUMBERS = new ArrayList<Integer>();
    private static final HashSet<class_1792> UNSTACKING_ITEMS = new HashSet();
    private static final List<Integer> TOOL_SWITCHABLE_SLOTS = new ArrayList<Integer>();

    public static void setToolSwitchableSlots(String configStr) {
        InventoryUtils.parseSlotsFromString(configStr, TOOL_SWITCHABLE_SLOTS);
    }

    public static void parseSlotsFromString(String configStr, Collection<Integer> output) {
        String[] parts = configStr.split(",");
        Pattern patternRange = Pattern.compile("^(?<start>[0-9])-(?<end>[0-9])$");
        output.clear();
        for (String str : parts) {
            try {
                Matcher matcher = patternRange.matcher(str);
                if (matcher.matches()) {
                    int slotEnd;
                    int slotStart = Integer.parseInt(matcher.group("start")) - 1;
                    if (slotStart > (slotEnd = Integer.parseInt(matcher.group("end")) - 1) || !class_1661.method_7380((int)slotStart) || !class_1661.method_7380((int)slotEnd)) continue;
                    for (int slotNum = slotStart; slotNum <= slotEnd; ++slotNum) {
                        if (output.contains(slotNum)) continue;
                        output.add(slotNum);
                    }
                    continue;
                }
                int slotNum = Integer.parseInt(str) - 1;
                if (!class_1661.method_7380((int)slotNum) || output.contains(slotNum)) continue;
                output.add(slotNum);
            }
            catch (NumberFormatException ignore) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"Failed to parse slots from string %s", (Object[])new Object[]{configStr});
            }
        }
    }

    public static void setUnstackingItems(List<String> names) {
        UNSTACKING_ITEMS.clear();
        for (String name : names) {
            try {
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(name));
                if (item == null || item == class_1802.field_8162) continue;
                UNSTACKING_ITEMS.add(item);
            }
            catch (Exception e) {
                Tweakeroo.logger.warn("Failed to set an unstacking protected item from name '{}'", (Object)name, (Object)e);
            }
        }
    }

    public static void setRepairModeSlots(List<String> names) {
        REPAIR_MODE_SLOTS.clear();
        REPAIR_MODE_SLOT_NUMBERS.clear();
        for (String name : names) {
            class_1304 type = null;
            switch (name) {
                case "mainhand": {
                    type = class_1304.field_6173;
                    break;
                }
                case "offhand": {
                    type = class_1304.field_6171;
                    break;
                }
                case "head": {
                    type = class_1304.field_6169;
                    break;
                }
                case "chest": {
                    type = class_1304.field_6174;
                    break;
                }
                case "legs": {
                    type = class_1304.field_6172;
                    break;
                }
                case "feet": {
                    type = class_1304.field_6166;
                }
            }
            if (type == null) continue;
            REPAIR_MODE_SLOTS.add(type);
            int slotNum = InventoryUtils.getSlotNumberForEquipmentType(type, null);
            if (slotNum < 0) continue;
            REPAIR_MODE_SLOT_NUMBERS.add(slotNum);
        }
    }

    private static boolean isConfiguredRepairSlot(int slotNum, class_1657 player) {
        if (REPAIR_MODE_SLOTS.contains(class_1304.field_6173) && slotNum - 36 == player.method_31548().field_7545) {
            return true;
        }
        return REPAIR_MODE_SLOT_NUMBERS.contains(slotNum);
    }

    @Nullable
    private static class_1304 getEquipmentTypeForSlot(int slotNum, class_1657 player) {
        if (REPAIR_MODE_SLOTS.contains(class_1304.field_6173) && slotNum - 36 == player.method_31548().field_7545) {
            return class_1304.field_6173;
        }
        switch (slotNum) {
            case 45: {
                return class_1304.field_6171;
            }
            case 5: {
                return class_1304.field_6169;
            }
            case 6: {
                return class_1304.field_6174;
            }
            case 7: {
                return class_1304.field_6172;
            }
            case 8: {
                return class_1304.field_6166;
            }
        }
        return null;
    }

    private static int getSlotNumberForEquipmentType(class_1304 type, @Nullable class_1657 player) {
        switch (type) {
            case field_6173: {
                return player != null ? player.method_31548().field_7545 + 36 : -1;
            }
            case field_6171: {
                return 45;
            }
            case field_6169: {
                return 5;
            }
            case field_6174: {
                return 6;
            }
            case field_6172: {
                return 7;
            }
            case field_6166: {
                return 8;
            }
        }
        return -1;
    }

    public static void swapHotbarWithInventoryRow(class_1657 player, int row) {
        class_1723 container = player.field_7498;
        row = class_3532.method_15340((int)row, (int)0, (int)2);
        int slot = row * 9 + 9;
        for (int hotbarSlot = 0; hotbarSlot < 9; ++hotbarSlot) {
            fi.dy.masa.malilib.util.InventoryUtils.swapSlots((class_1703)container, (int)slot, (int)hotbarSlot);
            ++slot;
        }
    }

    public static void restockNewStackToHand(class_1657 player, class_1268 hand, class_1799 stackReference, boolean allowHotbar) {
        int slotWithItem;
        if (stackReference.method_7909().method_7846()) {
            int minDurability = InventoryUtils.getMinDurability(stackReference);
            slotWithItem = InventoryUtils.findSlotWithSuitableReplacementToolWithDurabilityLeft((class_1703)player.field_7498, stackReference, minDurability);
        } else {
            slotWithItem = InventoryUtils.findSlotWithItem((class_1703)player.field_7498, stackReference, allowHotbar, true);
        }
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
        }
    }

    public static void preRestockHand(class_1657 player, class_1268 hand, boolean allowHotbar) {
        class_1799 stackHand = player.method_5998(hand);
        int threshold = Configs.Generic.HAND_RESTOCK_PRE_THRESHOLD.getIntegerValue();
        if (FeatureToggle.TWEAK_HAND_RESTOCK.getBooleanValue() && Configs.Generic.HAND_RESTOCK_PRE.getBooleanValue() && !stackHand.method_7960() && stackHand.method_7947() <= threshold && stackHand.method_7914() > threshold && PlacementTweaks.canUseItemWithRestriction(PlacementTweaks.HAND_RESTOCK_RESTRICTION, stackHand) && player.field_7512 == player.field_7498 && player.field_7512.method_34255().method_7960()) {
            class_310 mc = class_310.method_1551();
            class_1723 container = player.field_7498;
            int endSlot = allowHotbar ? 44 : 35;
            int currentMainHandSlot = player.method_31548().field_7545 + 36;
            int currentSlot = hand == class_1268.field_5808 ? currentMainHandSlot : 45;
            for (int slotNum = 9; slotNum <= endSlot; ++slotNum) {
                class_1735 slot;
                class_1799 stackSlot;
                if (slotNum == currentMainHandSlot || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqualIgnoreDurability((class_1799)(stackSlot = (slot = (class_1735)container.field_7761.get(slotNum)).method_7677()), (class_1799)stackHand)) continue;
                int button = stackSlot.method_7947() + stackHand.method_7947() <= stackHand.method_7914() ? 0 : 1;
                mc.field_1761.method_2906(container.field_7763, slot.field_7874, button, class_1713.field_7790, player);
                mc.field_1761.method_2906(container.field_7763, currentSlot, 0, class_1713.field_7790, player);
                break;
            }
        }
    }

    public static void trySwapCurrentToolIfNearlyBroken() {
        class_746 player = class_310.method_1551().field_1724;
        if (FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue() && player != null) {
            InventoryUtils.trySwapCurrentToolIfNearlyBroken(class_1268.field_5808, (class_1657)player);
            InventoryUtils.trySwapCurrentToolIfNearlyBroken(class_1268.field_5810, (class_1657)player);
        }
    }

    public static void trySwapCurrentToolIfNearlyBroken(class_1268 hand, class_1657 player) {
        int minDurability;
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_7960() && InventoryUtils.isItemAtLowDurability(stack, minDurability = InventoryUtils.getMinDurability(stack))) {
            InventoryUtils.swapItemWithHigherDurabilityToHand(player, hand, stack, minDurability);
        }
    }

    public static void trySwitchToEffectiveTool(class_2338 pos) {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player != null && mc.field_1687 != null) {
            class_2680 state = mc.field_1687.method_8320(pos);
            class_1723 container = player.field_7498;
            ItemPickerTest test = FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue() ? (currentStack, previous) -> InventoryUtils.isBetterToolAndHasDurability(currentStack, previous, state) : (currentStack, previous) -> InventoryUtils.isBetterTool(currentStack, previous, state);
            int slotNumber = InventoryUtils.findSlotWithBestItemMatch((class_1703)container, test, class_6019.method_35017((int)36, (int)44), class_6019.method_35017((int)9, (int)35));
            if (slotNumber != -1 && slotNumber - 36 != player.method_31548().field_7545) {
                InventoryUtils.swapToolToHand(slotNumber, mc);
            }
        }
    }

    private static boolean isBetterTool(class_1799 testedStack, class_1799 previousTool, class_2680 state) {
        return !testedStack.method_7960() && InventoryUtils.isMoreEffectiveTool(testedStack, previousTool, state);
    }

    private static boolean isBetterToolAndHasDurability(class_1799 testedStack, class_1799 previousTool, class_2680 state) {
        return InventoryUtils.hasEnoughDurability(testedStack) && InventoryUtils.isBetterTool(testedStack, previousTool, state);
    }

    private static boolean isMoreEffectiveTool(class_1799 testedStack, class_1799 previousTool, class_2680 state) {
        return InventoryUtils.getBaseBlockBreakingSpeed(testedStack, state) > InventoryUtils.getBaseBlockBreakingSpeed(previousTool, state);
    }

    protected static float getBaseBlockBreakingSpeed(class_1799 stack, class_2680 state) {
        int effLevel;
        float speed = stack.method_7924(state);
        if (speed > 1.0f && (effLevel = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)stack)) > 0) {
            speed += (float)(effLevel * effLevel + 1);
        }
        if (state.method_29291() && !stack.method_7951(state)) {
            speed /= 3.3333333f;
        }
        return speed;
    }

    protected static boolean hasEnoughDurability(class_1799 stack) {
        return stack.method_7936() - stack.method_7919() >= InventoryUtils.getMinDurability(stack);
    }

    private static int findSuitableSlot(class_1703 container, Predicate<class_1799> itemTest) {
        return InventoryUtils.findSuitableSlot(container, itemTest, class_6019.method_35017((int)9, (int)(container.field_7761.size() - 1)));
    }

    private static int findSuitableSlot(class_1703 container, Predicate<class_1799> itemTest, class_6019 ... ranges) {
        int max = container.field_7761.size() - 1;
        for (class_6019 range : ranges) {
            int end = Math.min(max, range.method_35011());
            for (int slotNumber = range.method_35009(); slotNumber <= end; ++slotNumber) {
                if (!itemTest.test(container.method_7611(slotNumber).method_7677())) continue;
                return slotNumber;
            }
        }
        return -1;
    }

    private static int findSlotWithBestItemMatch(class_1703 container, ItemPickerTest itemTest, class_6019 ... ranges) {
        int max = container.field_7761.size() - 1;
        class_1799 bestMatch = class_1799.field_8037;
        int slotNum = -1;
        for (class_6019 range : ranges) {
            int end = Math.min(max, range.method_35011());
            for (int slotNumber = range.method_35009(); slotNumber <= end; ++slotNumber) {
                class_1735 slot = container.method_7611(slotNumber);
                if (!itemTest.isBetterMatch(slot.method_7677(), bestMatch)) continue;
                bestMatch = slot.method_7677();
                slotNum = slot.field_7874;
            }
        }
        return slotNum;
    }

    private static int findEmptySlot(class_1703 container, Collection<Integer> slotNumbers) {
        int maxSlot = container.field_7761.size() - 1;
        for (int slotNumber : slotNumbers) {
            if (slotNumber < 0 || slotNumber > maxSlot || container.method_7611(slotNumber).method_7681()) continue;
            return slotNumber;
        }
        return -1;
    }

    private static boolean isItemAtLowDurability(class_1799 stack, int minDurability) {
        return stack.method_7963() && stack.method_7919() >= stack.method_7936() - minDurability;
    }

    private static int getMinDurability(class_1799 stack) {
        if (!FeatureToggle.TWEAK_SWAP_ALMOST_BROKEN_TOOLS.getBooleanValue()) {
            return 0;
        }
        int minDurability = Configs.Generic.ITEM_SWAP_DURABILITY_THRESHOLD.getIntegerValue();
        if (stack.method_7936() <= 100 && minDurability <= 20 && (double)minDurability / (double)stack.method_7936() > 0.08) {
            minDurability = (int)Math.ceil((double)stack.method_7936() * 0.08);
        }
        return minDurability;
    }

    private static void swapItemWithHigherDurabilityToHand(class_1657 player, class_1268 hand, class_1799 stackReference, int minDurabilityLeft) {
        class_1723 container = player.field_7498;
        int slotWithItem = InventoryUtils.findSlotWithSuitableReplacementToolWithDurabilityLeft((class_1703)container, stackReference, minDurabilityLeft);
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_for_better_durability", (Object[])new Object[0]);
            return;
        }
        slotWithItem = fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((class_1703)container, (boolean)false, (boolean)false);
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_off_players_hand", (Object[])new Object[0]);
            return;
        }
        slotWithItem = InventoryUtils.findSuitableSlot((class_1703)container, s -> !s.method_7963());
        if (slotWithItem != -1) {
            InventoryUtils.swapItemToHand(player, hand, slotWithItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.swapped_low_durability_item_for_dummy_item", (Object[])new Object[0]);
        }
    }

    public static void repairModeSwapItems(class_1657 player) {
        if (player.field_7512 == player.field_7498) {
            for (class_1304 type : REPAIR_MODE_SLOTS) {
                InventoryUtils.repairModeHandleSlot(player, type);
            }
        }
    }

    private static void repairModeHandleSlot(class_1657 player, class_1304 type) {
        class_1735 slot;
        int slotRepairableItem;
        int slotNum = InventoryUtils.getSlotNumberForEquipmentType(type, player);
        if (slotNum == -1) {
            return;
        }
        class_1799 stack = player.method_6118(type);
        if (!(stack.method_7960() || stack.method_7963() && stack.method_7986() && class_1890.method_8225((class_1887)class_1893.field_9101, (class_1799)stack) > 0 || (slotRepairableItem = InventoryUtils.findRepairableItemNotInRepairableSlot(slot = player.field_7512.method_7611(slotNum), player)) == -1)) {
            InventoryUtils.swapItemToEquipmentSlot(player, type, slotRepairableItem);
            InfoUtils.printActionbarMessage((String)"tweakeroo.message.repair_mode.swapped_repairable_item_to_slot", (Object[])new Object[]{type.method_5923()});
        }
    }

    private static int findRepairableItemNotInRepairableSlot(class_1735 targetSlot, class_1657 player) {
        class_1703 containerPlayer = player.field_7512;
        for (class_1735 slot : containerPlayer.field_7761) {
            if (!slot.method_7681() || InventoryUtils.isConfiguredRepairSlot(slot.field_7874, player)) continue;
            class_1799 stack = slot.method_7677();
            if (slot.field_7874 - 36 == player.method_31548().field_7545 || !stack.method_7963() || !stack.method_7986() || !targetSlot.method_7680(stack) || class_1890.method_8225((class_1887)class_1893.field_9101, (class_1799)stack) <= 0) continue;
            return slot.field_7874;
        }
        return -1;
    }

    public static void swapElytraWithChestPlate(@Nullable class_1657 player) {
        if (player == null || GuiUtils.getCurrentScreen() != null) {
            return;
        }
        class_1703 container = player.field_7512;
        class_1799 currentStack = player.method_6118(class_1304.field_6174);
        Predicate<class_1799> stackFilterChestPlate = s -> s.method_7909() instanceof class_1738 && ((class_1738)s.method_7909()).method_7685() == class_1304.field_6174;
        Predicate<class_1799> stackFilterElytra = s -> s.method_7909() instanceof class_1770 && class_1770.method_7804((class_1799)s);
        Predicate<class_1799> stackFilter = currentStack.method_7960() || stackFilterChestPlate.test(currentStack) ? stackFilterElytra : stackFilterChestPlate;
        Predicate<class_1799> finalFilter = s -> !s.method_7960() && stackFilter.test((class_1799)s) && s.method_7919() < s.method_7936() - 10;
        int targetSlot = InventoryUtils.findSuitableSlot(container, finalFilter);
        if (targetSlot >= 0) {
            InventoryUtils.swapItemToEquipmentSlot(player, class_1304.field_6174, targetSlot);
        }
    }

    public static int findSlotWithItem(class_1703 container, class_1799 stackReference, boolean allowHotbar, boolean reverse) {
        int startSlot = reverse ? container.field_7761.size() - 1 : 0;
        int endSlot = reverse ? -1 : container.field_7761.size();
        int increment = reverse ? -1 : 1;
        boolean isPlayerInv = container instanceof class_1723;
        for (int slotNum = startSlot; slotNum != endSlot; slotNum += increment) {
            class_1735 slot = (class_1735)container.field_7761.get(slotNum);
            if (isPlayerInv && !fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.field_7874, (boolean)false) || !allowHotbar && InventoryUtils.isHotbarSlot(slot) || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqualIgnoreDurability((class_1799)slot.method_7677(), (class_1799)stackReference)) continue;
            return slot.field_7874;
        }
        return -1;
    }

    private static boolean isHotbarSlot(class_1735 slot) {
        return InventoryUtils.isHotbarSlot(slot.field_7874);
    }

    private static boolean isHotbarSlot(int slot) {
        return slot >= 36 && slot < 36 + class_1661.method_7368();
    }

    private static void swapItemToHand(class_1657 player, class_1268 hand, int slotNumber) {
        class_1703 container = player.field_7512;
        if (slotNumber != -1 && container == player.field_7498) {
            class_310 mc = class_310.method_1551();
            class_1661 inventory = player.method_31548();
            if (hand == class_1268.field_5808) {
                int currentHotbarSlot = inventory.field_7545;
                if (InventoryUtils.isHotbarSlot(slotNumber)) {
                    inventory.field_7545 = slotNumber - 36;
                    mc.method_1562().method_2883((class_2596)new class_2868(inventory.field_7545));
                } else {
                    mc.field_1761.method_2906(container.field_7763, slotNumber, currentHotbarSlot, class_1713.field_7791, (class_1657)mc.field_1724);
                }
            } else if (hand == class_1268.field_5810) {
                mc.field_1761.method_2906(container.field_7763, slotNumber, 40, class_1713.field_7791, (class_1657)mc.field_1724);
            }
        }
    }

    private static void swapItemToEquipmentSlot(class_1657 player, class_1304 type, int sourceSlotNumber) {
        if (sourceSlotNumber != -1 && player.field_7512 == player.field_7498) {
            class_310 mc = class_310.method_1551();
            class_1723 container = player.field_7498;
            int equipmentSlotNumber = InventoryUtils.getSlotNumberForEquipmentType(type, player);
            int equipmentSlotInvIndex = container.method_7611(equipmentSlotNumber).method_34266();
            mc.field_1761.method_2906(container.field_7763, sourceSlotNumber, equipmentSlotInvIndex, class_1713.field_7791, (class_1657)mc.field_1724);
        }
    }

    private static void swapToolToHand(int slotNumber, class_310 mc) {
        class_746 player = mc.field_1724;
        if (slotNumber >= 0 && player.field_7512 == player.field_7498) {
            class_1661 inventory = player.method_31548();
            class_1723 container = player.field_7498;
            if (InventoryUtils.isHotbarSlot(slotNumber)) {
                inventory.field_7545 = slotNumber - 36;
                mc.method_1562().method_2883((class_2596)new class_2868(inventory.field_7545));
            } else {
                int selectedSlot = inventory.field_7545;
                int hotbarSlot = InventoryUtils.getUsableHotbarSlotForTool(selectedSlot, TOOL_SWITCHABLE_SLOTS, (class_1703)container);
                if (class_1661.method_7380((int)hotbarSlot)) {
                    if (hotbarSlot != selectedSlot) {
                        inventory.field_7545 = hotbarSlot;
                        mc.method_1562().method_2883((class_2596)new class_2868(inventory.field_7545));
                    }
                    mc.field_1761.method_2906(container.field_7763, slotNumber, hotbarSlot, class_1713.field_7791, (class_1657)mc.field_1724);
                }
            }
        }
    }

    private static int getUsableHotbarSlotForTool(int currentHotbarSlot, Collection<Integer> validSlots, class_1703 container) {
        int first = -1;
        int nonTool = -1;
        if (validSlots.contains(currentHotbarSlot)) {
            class_1799 stack = container.method_7611(currentHotbarSlot + 36).method_7677();
            if (stack.method_7960()) {
                return currentHotbarSlot;
            }
            if (!(stack.method_7909() instanceof class_1831)) {
                nonTool = currentHotbarSlot;
            }
        }
        for (int hotbarSlot : validSlots) {
            class_1799 stack = container.method_7611(hotbarSlot + 36).method_7677();
            if (stack.method_7960()) {
                return hotbarSlot;
            }
            if (nonTool == -1 && !(stack.method_7909() instanceof class_1831)) {
                nonTool = hotbarSlot;
            }
            if (first != -1) continue;
            first = hotbarSlot;
        }
        return nonTool >= 0 ? nonTool : first;
    }

    private static int findSlotWithSuitableReplacementToolWithDurabilityLeft(class_1703 container, class_1799 stackReference, int minDurabilityLeft) {
        for (class_1735 slot : container.field_7761) {
            class_1799 stackSlot = slot.method_7677();
            if (!fi.dy.masa.malilib.util.InventoryUtils.isRegularInventorySlot((int)slot.field_7874, (boolean)false) || !stackSlot.method_7962(stackReference) || stackSlot.method_7936() - stackSlot.method_7919() < minDurabilityLeft || !InventoryUtils.hasSameIshEnchantments(stackReference, stackSlot)) continue;
            return slot.field_7874;
        }
        return -1;
    }

    private static boolean hasSameIshEnchantments(class_1799 stackReference, class_1799 stack) {
        int level = class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stackReference);
        if (level > 0) {
            return class_1890.method_8225((class_1887)class_1893.field_9099, (class_1799)stack) >= level;
        }
        level = class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)stackReference);
        if (level > 0) {
            return class_1890.method_8225((class_1887)class_1893.field_9130, (class_1799)stack) >= level;
        }
        return true;
    }

    private static int findSlotWithEffectiveItemWithDurabilityLeft(class_1703 container, class_2680 state) {
        int slotNum = -1;
        float bestSpeed = -1.0f;
        for (class_1735 slot : container.field_7761) {
            int effLevel;
            class_1799 stack;
            if (slot.field_7874 <= 8 || !slot.method_7681() || (stack = slot.method_7677()).method_7936() - stack.method_7919() <= InventoryUtils.getMinDurability(stack)) continue;
            float speed = stack.method_7924(state);
            if (speed > 1.0f && (effLevel = class_1890.method_8225((class_1887)class_1893.field_9131, (class_1799)stack)) > 0) {
                speed += (float)(effLevel * effLevel + 1);
            }
            if (!(speed > 1.0f) || slotNum != -1 && !(speed > bestSpeed)) continue;
            slotNum = slot.field_7874;
            bestSpeed = speed;
        }
        return slotNum;
    }

    private static void tryCombineStacksInInventory(class_1657 player, class_1799 stackReference) {
        ArrayList<class_1735> slots = new ArrayList<class_1735>();
        class_1723 container = player.field_7498;
        class_310 mc = class_310.method_1551();
        for (class_1735 slot : container.field_7761) {
            class_1799 stack;
            if (slot.field_7874 < 8 || (stack = slot.method_7677()).method_7947() >= stack.method_7914() || !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((class_1799)stackReference, (class_1799)stack)) continue;
            slots.add(slot);
        }
        block1: for (int i = 0; i < slots.size(); ++i) {
            class_1735 slot1 = (class_1735)slots.get(i);
            for (int j = i + 1; j < slots.size(); ++j) {
                class_1735 slot2 = (class_1735)slots.get(j);
                class_1799 stack = slot1.method_7677();
                if (stack.method_7947() < stack.method_7914()) {
                    mc.field_1761.method_2906(container.field_7763, slot1.field_7874, 0, class_1713.field_7790, player);
                    mc.field_1761.method_2906(container.field_7763, slot2.field_7874, 0, class_1713.field_7790, player);
                    if (!player.method_31548().method_7391().method_7960()) {
                        mc.field_1761.method_2906(container.field_7763, slot1.field_7874, 0, class_1713.field_7790, player);
                    }
                    if (slot2.method_7677().method_7947() >= slot2.method_7677().method_7914()) {
                        slots.remove(j);
                        --j;
                    }
                }
                if (!slot1.method_7681()) continue block1;
            }
        }
    }

    public static boolean canUnstackingItemNotFitInInventory(class_1799 stack, class_1657 player) {
        if (FeatureToggle.TWEAK_ITEM_UNSTACKING_PROTECTION.getBooleanValue() && stack.method_7947() > 1 && UNSTACKING_ITEMS.contains(stack.method_7909()) && fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((class_1703)player.field_7498, (boolean)false, (boolean)false) == -1) {
            InventoryUtils.tryCombineStacksInInventory(player, stack);
            return fi.dy.masa.malilib.util.InventoryUtils.findEmptySlotInPlayerInventory((class_1703)player.field_7498, (boolean)false, (boolean)false) == -1;
        }
        return false;
    }

    public static void switchToPickedBlock() {
        class_2338 pos;
        class_2680 stateTargeted;
        class_1799 stack;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        class_638 world = mc.field_1687;
        if (player == null || world == null || player.field_7512 != player.field_7498) {
            return;
        }
        double reach = mc.field_1761.method_2904();
        boolean isCreative = player.method_7337();
        class_239 trace = player.method_5745(reach, mc.method_1488(), false);
        if (trace != null && trace.method_17783() == class_239.class_240.field_1332 && !(stack = (stateTargeted = world.method_8320(pos = ((class_3965)trace).method_17777())).method_26204().method_9574((class_1922)world, pos, stateTargeted)).method_7960() && !fi.dy.masa.malilib.util.InventoryUtils.areStacksEqual((class_1799)stack, (class_1799)player.method_6047())) {
            class_1703 container = player.field_7512;
            class_1661 inventory = player.method_31548();
            if (isCreative) {
                inventory.method_7374(stack);
                mc.field_1761.method_2909(player.method_5998(class_1268.field_5808), 36 + inventory.field_7545);
            } else {
                int slotNumber = fi.dy.masa.malilib.util.InventoryUtils.findSlotWithItem((class_1703)container, (class_1799)stack, (boolean)true);
                if (slotNumber != -1) {
                    InventoryUtils.swapItemToHand((class_1657)player, class_1268.field_5808, slotNumber);
                }
            }
        }
    }

    public static boolean cleanUpShulkerBoxNBT(class_1799 stack) {
        boolean changed = false;
        class_2487 nbt = stack.method_7969();
        if (nbt != null) {
            if (nbt.method_10573("BlockEntityTag", 10)) {
                class_2487 tag = nbt.method_10562("BlockEntityTag");
                if (tag.method_10573("Items", 9) && tag.method_10554("Items", 10).size() == 0) {
                    tag.method_10551("Items");
                    changed = true;
                }
                if (tag.method_33133()) {
                    nbt.method_10551("BlockEntityTag");
                }
            }
            if (nbt.method_33133()) {
                stack.method_7980(null);
                changed = true;
            }
        }
        return changed;
    }

    public static interface ItemPickerTest {
        public boolean isBetterMatch(class_1799 var1, class_1799 var2);
    }
}

