/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.util;

import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.config.FeatureToggle;
import fi.dy.masa.tweakeroo.util.CameraUtils;
import javax.annotation.Nullable;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_243;
import net.minecraft.class_299;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3469;
import net.minecraft.class_3532;
import net.minecraft.class_634;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class CameraEntity
extends class_746 {
    @Nullable
    private static class_1297 originalCameraEntity;
    @Nullable
    private static CameraEntity camera;
    private static boolean cullChunksOriginal;
    private static float forwardRamped;
    private static float strafeRamped;
    private static float verticalRamped;
    private static boolean sprinting;
    private static boolean originalCameraWasPlayer;

    public CameraEntity(class_310 mc, class_638 world, class_634 nethandler, class_3469 stats, class_299 recipeBook) {
        super(mc, world, nethandler, stats, recipeBook, false, false);
    }

    public boolean method_7325() {
        return true;
    }

    public static void movementTick(boolean sneak, boolean jump) {
        CameraEntity camera = CameraEntity.getCamera();
        if (camera != null && !Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT.getBooleanValue()) {
            class_310 mc = class_310.method_1551();
            camera.updateLastTickPosition();
            float forward = 0.0f;
            float vertical = 0.0f;
            float strafe = 0.0f;
            class_315 options = mc.field_1690;
            if (options.field_1894.method_1434()) {
                forward += 1.0f;
            }
            if (options.field_1881.method_1434()) {
                forward -= 1.0f;
            }
            if (options.field_1913.method_1434()) {
                strafe += 1.0f;
            }
            if (options.field_1849.method_1434()) {
                strafe -= 1.0f;
            }
            if (options.field_1903.method_1434()) {
                vertical += 1.0f;
            }
            if (options.field_1832.method_1434()) {
                vertical -= 1.0f;
            }
            if (options.field_1867.method_1434()) {
                sprinting = true;
            } else if (forward == 0.0f) {
                sprinting = false;
            }
            float rampAmount = 0.15f;
            float speed = strafe * strafe + forward * forward;
            speed = forward != 0.0f && strafe != 0.0f ? (float)Math.sqrt((double)speed * 0.6) : 1.0f;
            forwardRamped = CameraEntity.getRampedMotion(forwardRamped, forward, rampAmount) / speed;
            verticalRamped = CameraEntity.getRampedMotion(verticalRamped, vertical, rampAmount);
            strafeRamped = CameraEntity.getRampedMotion(strafeRamped, strafe, rampAmount) / speed;
            forward = sprinting ? forwardRamped * 3.0f : forwardRamped;
            camera.handleMotion(forward, verticalRamped, strafeRamped);
        }
    }

    private static float getRampedMotion(float current, float input, float rampAmount) {
        if (input != 0.0f) {
            if (input < 0.0f) {
                rampAmount *= -1.0f;
            }
            if (input < 0.0f != current < 0.0f) {
                current = 0.0f;
            }
            current = class_3532.method_15363((float)(current + rampAmount), (float)-1.0f, (float)1.0f);
        } else {
            current *= 0.5f;
        }
        return current;
    }

    private static double getMoveSpeed() {
        double base = 0.07;
        if (FeatureToggle.TWEAK_FLY_SPEED.getBooleanValue()) {
            base = Configs.getActiveFlySpeedConfig().getDoubleValue();
        }
        return base * 10.0;
    }

    private void handleMotion(float forward, float up, float strafe) {
        float yaw = this.method_36454();
        double xFactor = Math.sin((double)yaw * Math.PI / 180.0);
        double zFactor = Math.cos((double)yaw * Math.PI / 180.0);
        double scale = CameraEntity.getMoveSpeed();
        double x = ((double)strafe * zFactor - (double)forward * xFactor) * scale;
        double y = (double)up * scale;
        double z = ((double)forward * zFactor + (double)strafe * xFactor) * scale;
        this.method_18799(new class_243(x, y, z));
        this.method_5784(class_1313.field_6308, this.method_18798());
    }

    private void updateLastTickPosition() {
        this.field_6038 = this.method_23317();
        this.field_5971 = this.method_23318();
        this.field_5989 = this.method_23321();
        this.field_6014 = this.method_23317();
        this.field_6036 = this.method_23318();
        this.field_5969 = this.method_23321();
        this.field_5982 = this.method_36454();
        this.field_6004 = this.method_36455();
        this.field_6259 = this.field_6241;
    }

    public void setCameraRotations(float yaw, float pitch) {
        this.method_36456(yaw);
        this.method_36457(pitch);
        this.field_6241 = yaw;
    }

    public void updateCameraRotations(float yawChange, float pitchChange) {
        float yaw = this.method_36454() + yawChange * 0.15f;
        float pitch = class_3532.method_15363((float)(this.method_36455() + pitchChange * 0.15f), (float)-90.0f, (float)90.0f);
        this.method_36456(yaw);
        this.method_36457(pitch);
        this.setCameraRotations(yaw, pitch);
    }

    private static CameraEntity createCameraEntity(class_310 mc) {
        class_746 player = mc.field_1724;
        CameraEntity camera = new CameraEntity(mc, mc.field_1687, player.field_3944, player.method_3143(), player.method_3130());
        camera.field_5960 = true;
        float yaw = player.method_36454();
        float pitch = player.method_36455();
        camera.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), yaw, pitch);
        camera.method_5710(yaw, pitch);
        return camera;
    }

    @Nullable
    public static CameraEntity getCamera() {
        return camera;
    }

    public static void setCameraState(boolean enabled) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 != null && mc.field_1724 != null) {
            if (enabled) {
                CameraEntity.createAndSetCamera(mc);
            } else {
                CameraEntity.removeCamera(mc);
            }
            mc.field_1773.method_35768(!enabled);
        }
    }

    public static boolean originalCameraWasPlayer() {
        return originalCameraWasPlayer;
    }

    private static void createAndSetCamera(class_310 mc) {
        camera = CameraEntity.createCameraEntity(mc);
        originalCameraEntity = mc.method_1560();
        originalCameraWasPlayer = originalCameraEntity == mc.field_1724;
        cullChunksOriginal = mc.field_1730;
        mc.method_1504((class_1297)camera);
        mc.field_1730 = false;
        Configs.Generic.FREE_CAMERA_PLAYER_MOVEMENT.setBooleanValue(false);
    }

    private static void removeCamera(class_310 mc) {
        if (mc.field_1687 != null && camera != null) {
            mc.method_1504((class_1297)(originalCameraWasPlayer ? mc.field_1724 : originalCameraEntity));
            mc.field_1730 = cullChunksOriginal;
            int chunkX = class_3532.method_15357((double)(camera.method_23317() / 16.0)) >> 4;
            int chunkZ = class_3532.method_15357((double)(camera.method_23321() / 16.0)) >> 4;
            CameraUtils.markChunksForRebuildOnDeactivation(chunkX, chunkZ);
        }
        originalCameraEntity = null;
        camera = null;
    }
}

