/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.tweakeroo.renderer;

import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.HudAlignment;
import fi.dy.masa.malilib.render.InventoryOverlay;
import fi.dy.masa.malilib.util.EntityUtils;
import fi.dy.masa.malilib.util.GuiUtils;
import fi.dy.masa.malilib.util.InventoryUtils;
import fi.dy.masa.malilib.util.WorldUtils;
import fi.dy.masa.tweakeroo.config.Configs;
import fi.dy.masa.tweakeroo.mixin.IMixinHorseBaseEntity;
import fi.dy.masa.tweakeroo.util.MiscUtils;
import fi.dy.masa.tweakeroo.util.RayTraceUtils;
import fi.dy.masa.tweakeroo.util.SnapAimMode;
import net.minecraft.class_1160;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2480;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_746;

public class RenderUtils {
    private static long lastRotationChangeTime;

    public static void renderHotbarSwapOverlay(class_310 mc, class_4587 matrixStack) {
        class_746 player = mc.field_1724;
        if (player != null) {
            int scaledWidth = GuiUtils.getScaledWindowWidth();
            int scaledHeight = GuiUtils.getScaledWindowHeight();
            int offX = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_X.getIntegerValue();
            int offY = Configs.Generic.HOTBAR_SWAP_OVERLAY_OFFSET_Y.getIntegerValue();
            int startX = offX;
            int startY = offY;
            HudAlignment align = (HudAlignment)Configs.Generic.HOTBAR_SWAP_OVERLAY_ALIGNMENT.getOptionListValue();
            switch (align) {
                case TOP_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    break;
                }
                case BOTTOM_LEFT: {
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case BOTTOM_RIGHT: {
                    startX = scaledWidth - offX - 162;
                    startY = scaledHeight - offY - 54;
                    break;
                }
                case CENTER: {
                    startX = scaledWidth / 2 - offX - 81;
                    startY = scaledHeight / 2 - offY - 27;
                    break;
                }
            }
            int x = startX;
            int y = startY;
            class_327 textRenderer = mc.field_1772;
            fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            fi.dy.masa.malilib.render.RenderUtils.bindTexture((class_2960)class_465.field_2801);
            fi.dy.masa.malilib.render.RenderUtils.drawTexturedRect((int)(x - 1), (int)(y - 1), (int)7, (int)83, (int)162, (int)54);
            textRenderer.method_1720(matrixStack, "1", (float)(x - 10), (float)(y + 4), 0xFFFFFF);
            textRenderer.method_1720(matrixStack, "2", (float)(x - 10), (float)(y + 22), 0xFFFFFF);
            textRenderer.method_1720(matrixStack, "3", (float)(x - 10), (float)(y + 40), 0xFFFFFF);
            for (int row = 1; row <= 3; ++row) {
                for (int column = 0; column < 9; ++column) {
                    class_1799 stack = player.method_31548().method_5438(row * 9 + column);
                    if (!stack.method_7960()) {
                        InventoryOverlay.renderStackAt((class_1799)stack, (float)x, (float)y, (float)1.0f, (class_310)mc);
                    }
                    x += 18;
                }
                y += 18;
                x = startX;
            }
        }
    }

    public static void renderInventoryOverlay(class_310 mc, class_4587 matrixStack) {
        class_239 trace;
        class_1657 serverPlayer;
        class_1937 world = WorldUtils.getBestWorld((class_310)mc);
        class_1297 cameraEntity = EntityUtils.getCameraEntity();
        if (cameraEntity == mc.field_1724 && world instanceof class_3218 && (serverPlayer = world.method_18470(mc.field_1724.method_5667())) != null) {
            cameraEntity = serverPlayer;
        }
        if ((trace = RayTraceUtils.getRayTraceFromEntity(world, cameraEntity, false)) == null) {
            return;
        }
        class_1263 inv = null;
        class_2480 block = null;
        class_1309 entityLivingBase = null;
        if (trace.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)trace).method_17777();
            class_2248 blockTmp = world.method_8320(pos).method_26204();
            if (blockTmp instanceof class_2480) {
                block = (class_2480)blockTmp;
            }
            inv = InventoryUtils.getInventory((class_1937)world, (class_2338)pos);
        } else if (trace.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)trace).method_17782();
            if (entity instanceof class_1309) {
                entityLivingBase = (class_1309)entity;
            }
            if (entity instanceof class_1263) {
                inv = (class_1263)entity;
            } else if (entity instanceof class_1646) {
                inv = ((class_1646)entity).method_18011();
            } else if (entity instanceof class_1496) {
                inv = ((IMixinHorseBaseEntity)entity).getHorseInventory();
            }
        }
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 26;
        int y = yCenter - 92;
        if (inv != null && inv.method_5439() > 0) {
            boolean isHorse = entityLivingBase instanceof class_1496;
            int totalSlots = isHorse ? inv.method_5439() - 2 : inv.method_5439();
            int firstSlot = isHorse ? 2 : 0;
            InventoryOverlay.InventoryRenderType type = entityLivingBase instanceof class_1646 ? InventoryOverlay.InventoryRenderType.VILLAGER : InventoryOverlay.getInventoryType((class_1263)inv);
            InventoryOverlay.InventoryProperties props = InventoryOverlay.getInventoryPropsTemp((InventoryOverlay.InventoryRenderType)type, (int)totalSlots);
            int rows = (int)Math.ceil((double)totalSlots / (double)props.slotsPerRow);
            int xInv = xCenter - props.width / 2;
            int yInv = yCenter - props.height - 6;
            if (rows > 6) {
                yInv -= (rows - 6) * 18;
                y -= (rows - 6) * 18;
            }
            if (entityLivingBase != null) {
                x = xCenter - 55;
                xInv = xCenter + 2;
                yInv = Math.min(yInv, yCenter - 92);
            }
            fi.dy.masa.malilib.render.RenderUtils.setShulkerboxBackgroundTintColor((class_2480)block, (boolean)Configs.Generic.SHULKER_DISPLAY_BACKGROUND_COLOR.getBooleanValue());
            if (isHorse) {
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)1, (int)2, (class_310)mc);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)1, (int)0, (int)2, (class_310)mc);
                xInv += 36;
            }
            if (totalSlots > 0) {
                InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)xInv, (int)yInv, (int)props.slotsPerRow, (int)totalSlots, (class_310)mc);
                InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)inv, (int)(xInv + props.slotOffsetX), (int)(yInv + props.slotOffsetY), (int)props.slotsPerRow, (int)firstSlot, (int)totalSlots, (class_310)mc);
            }
        }
        if (entityLivingBase != null) {
            InventoryOverlay.renderEquipmentOverlayBackground((int)x, (int)y, (class_1309)entityLivingBase, (class_4587)matrixStack);
            InventoryOverlay.renderEquipmentStacks((class_1309)entityLivingBase, (int)x, (int)y, (class_310)mc);
        }
    }

    public static void renderPlayerInventoryOverlay(class_310 mc) {
        int x = GuiUtils.getScaledWindowWidth() / 2 - 88;
        int y = GuiUtils.getScaledWindowHeight() / 2 + 10;
        int slotOffsetX = 8;
        int slotOffsetY = 8;
        InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.GENERIC;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)y, (int)9, (int)27, (class_310)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)mc.field_1724.method_31548(), (int)(x + slotOffsetX), (int)(y + slotOffsetY), (int)9, (int)9, (int)27, (class_310)mc);
    }

    public static void renderHotbarScrollOverlay(class_310 mc) {
        class_1661 inv = mc.field_1724.method_31548();
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int x = xCenter - 88;
        int y = yCenter + 6;
        InventoryOverlay.InventoryRenderType type = InventoryOverlay.InventoryRenderType.GENERIC;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)y, (int)9, (int)27, (class_310)mc);
        InventoryOverlay.renderInventoryBackground((InventoryOverlay.InventoryRenderType)type, (int)x, (int)(y + 70), (int)9, (int)9, (class_310)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)inv, (int)(x + 8), (int)(y + 8), (int)9, (int)9, (int)27, (class_310)mc);
        InventoryOverlay.renderInventoryStacks((InventoryOverlay.InventoryRenderType)type, (class_1263)inv, (int)(x + 8), (int)(y + 78), (int)9, (int)0, (int)9, (class_310)mc);
        int currentRow = Configs.Internal.HOTBAR_SCROLL_CURRENT_ROW.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutline((int)(x + 5), (int)(y + currentRow * 18 + 5), (int)166, (int)22, (int)2, (int)-57312);
    }

    public static float getLavaFogDistance(class_1297 entity, float originalFog) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            int resp = class_1890.method_8211((class_1309)living);
            int aqua = class_1890.method_8203((class_1887)class_1893.field_9105, (class_1309)living);
            float fog = originalFog;
            if (aqua > 0) {
                fog *= 1.6f;
            }
            if (resp > 0) {
                fog *= (float)resp * 1.6f;
            }
            return Math.max(fog, originalFog);
        }
        return originalFog;
    }

    public static void renderDirectionsCursor(float zLevel, float partialTicks) {
        class_310 mc = class_310.method_1551();
        int width = GuiUtils.getScaledWindowWidth();
        int height = GuiUtils.getScaledWindowHeight();
        class_4184 camera = mc.field_1773.method_19418();
        class_4587 matrixStack = RenderSystem.getModelViewStack();
        matrixStack.method_22903();
        matrixStack.method_22904((double)width / 2.0, (double)height / 2.0, (double)zLevel);
        matrixStack.method_22907(class_1160.field_20702.method_23214(camera.method_19329()));
        matrixStack.method_22907(class_1160.field_20705.method_23214(camera.method_19330()));
        matrixStack.method_22905(-1.0f, -1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.renderCrosshair((int)10);
        matrixStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public static void notifyRotationChanged() {
        lastRotationChangeTime = System.currentTimeMillis();
    }

    public static void renderSnapAimAngleIndicator(class_4587 matrixStack) {
        long current = System.currentTimeMillis();
        if (current - lastRotationChangeTime < 750L) {
            class_310 mc = class_310.method_1551();
            int xCenter = GuiUtils.getScaledWindowWidth() / 2;
            int yCenter = GuiUtils.getScaledWindowHeight() / 2;
            SnapAimMode mode = (SnapAimMode)Configs.Generic.SNAP_AIM_MODE.getOptionListValue();
            if (mode != SnapAimMode.PITCH) {
                RenderUtils.renderSnapAimAngleIndicatorYaw(xCenter, yCenter, 80, 12, mc, matrixStack);
            }
            if (mode != SnapAimMode.YAW) {
                RenderUtils.renderSnapAimAngleIndicatorPitch(xCenter, yCenter, 12, 50, mc, matrixStack);
            }
        }
    }

    private static void renderSnapAimAngleIndicatorYaw(int xCenter, int yCenter, int width, int height, class_310 mc, class_4587 matrixStack) {
        double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
        double realYaw = class_3532.method_15367((double)MiscUtils.getLastRealYaw(), (double)360.0);
        double snappedYaw = MiscUtils.calculateSnappedAngle(realYaw, step);
        double startYaw = snappedYaw - step / 2.0;
        int x = xCenter - width / 2;
        int y = yCenter + 10;
        int lineX = x + (int)(class_3532.method_15338((double)(realYaw - startYaw)) / step * (double)width);
        class_327 textRenderer = mc.field_1772;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        String str = class_3532.method_15338((double)snappedYaw) + "\u00b0";
        textRenderer.method_1729(matrixStack, str, (float)(xCenter - textRenderer.method_1727(str) / 2), (float)(y + height + 2), -1);
        str = "<  " + class_3532.method_15338((double)(snappedYaw - step)) + "\u00b0";
        textRenderer.method_1729(matrixStack, str, (float)(x - textRenderer.method_1727(str)), (float)(y + height + 2), -1);
        str = class_3532.method_15338((double)(snappedYaw + step)) + "\u00b0  >";
        textRenderer.method_1729(matrixStack, str, (float)(x + width), (float)(y + height + 2), -1);
        if (Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue()) {
            double threshold = Configs.Generic.SNAP_AIM_THRESHOLD_YAW.getDoubleValue();
            int snapThreshOffset = (int)((double)width * threshold / step);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter - snapThreshOffset), (int)y, (int)(snapThreshOffset * 2), (int)height, (int)1615920976);
            if (threshold < step / 2.0) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter - snapThreshOffset), (int)y, (int)2, (int)height, (int)-14614752);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(xCenter + snapThreshOffset), (int)y, (int)2, (int)height, (int)-14614752);
            }
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)lineX, (int)y, (int)2, (int)height, (int)-1);
    }

    private static void renderSnapAimAngleIndicatorPitch(int xCenter, int yCenter, int width, int height, class_310 mc, class_4587 matrixStack) {
        double step = Configs.Generic.SNAP_AIM_PITCH_STEP.getDoubleValue();
        int limit = Configs.Generic.SNAP_AIM_PITCH_OVERSHOOT.getBooleanValue() ? 180 : 90;
        double realPitch = class_3532.method_15338((double)MiscUtils.getLastRealPitch());
        double snappedPitch = realPitch < 0.0 ? -MiscUtils.calculateSnappedAngle(-realPitch, step) : MiscUtils.calculateSnappedAngle(realPitch, step);
        snappedPitch = class_3532.method_15350((double)class_3532.method_15338((double)snappedPitch), (double)(-limit), (double)limit);
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        RenderUtils.renderPitchIndicator(x, y, width, height, realPitch, snappedPitch, step, true, mc, matrixStack);
    }

    public static void renderPitchLockIndicator(class_310 mc, class_4587 matrixStack) {
        int xCenter = GuiUtils.getScaledWindowWidth() / 2;
        int yCenter = GuiUtils.getScaledWindowHeight() / 2;
        int width = 12;
        int height = 50;
        int x = xCenter - width / 2;
        int y = yCenter - height - 10;
        double currentPitch = mc.field_1724.method_36455();
        double centerPitch = 0.0;
        double indicatorRange = 180.0;
        RenderUtils.renderPitchIndicator(x, y, width, height, currentPitch, centerPitch, indicatorRange, false, mc, matrixStack);
    }

    private static void renderPitchIndicator(int x, int y, int width, int height, double currentPitch, double centerPitch, double indicatorRange, boolean isSnapRange, class_310 mc, class_4587 matrixStack) {
        double startPitch = centerPitch - indicatorRange / 2.0;
        double printedRange = isSnapRange ? indicatorRange : indicatorRange / 2.0;
        int lineY = y + (int)((class_3532.method_15338((double)currentPitch) - startPitch) / indicatorRange * (double)height);
        double angleUp = centerPitch - printedRange;
        double angleDown = centerPitch + printedRange;
        fi.dy.masa.malilib.render.RenderUtils.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        class_327 textRenderer = mc.field_1772;
        if (isSnapRange) {
            String strUp = String.format("%6.1f\u00b0 ^", class_3532.method_15338((double)angleUp));
            String strDown = String.format("%6.1f\u00b0 v", class_3532.method_15338((double)angleDown));
            textRenderer.method_1729(matrixStack, strUp, (float)(x + width + 4), (float)(y - 4), -1);
            textRenderer.method_1729(matrixStack, strDown, (float)(x + width + 4), (float)(y + height - 4), -1);
            String str = String.format("%6.1f\u00b0", class_3532.method_15338((double)(isSnapRange ? centerPitch : currentPitch)));
            textRenderer.method_1729(matrixStack, str, (float)(x + width + 4), (float)(y + height / 2 - 4), -1);
        } else {
            String str = String.format("%4.1f\u00b0", class_3532.method_15338((double)(isSnapRange ? centerPitch : currentPitch)));
            textRenderer.method_1729(matrixStack, str, (float)(x + width + 4), (float)(lineY - 4), -1);
        }
        int bgColor = Configs.Generic.SNAP_AIM_INDICATOR_COLOR.getIntegerValue();
        fi.dy.masa.malilib.render.RenderUtils.drawOutlinedBox((int)x, (int)y, (int)width, (int)height, (int)bgColor, (int)-1);
        int yCenter = y + height / 2 - 1;
        if (isSnapRange && Configs.Generic.SNAP_AIM_ONLY_CLOSE_TO_ANGLE.getBooleanValue()) {
            double step = Configs.Generic.SNAP_AIM_YAW_STEP.getDoubleValue();
            double threshold = Configs.Generic.SNAP_AIM_THRESHOLD_PITCH.getDoubleValue();
            int snapThreshOffset = (int)((double)height * threshold / indicatorRange);
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter - snapThreshOffset), (int)width, (int)(snapThreshOffset * 2), (int)1615920976);
            if (threshold < step / 2.0) {
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter - snapThreshOffset), (int)width, (int)2, (int)-14614752);
                fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(yCenter + snapThreshOffset), (int)width, (int)2, (int)-14614752);
            }
        } else if (!isSnapRange) {
            fi.dy.masa.malilib.render.RenderUtils.drawRect((int)(x + 1), (int)(yCenter - 1), (int)(width - 2), (int)2, (int)-4144960);
        }
        fi.dy.masa.malilib.render.RenderUtils.drawRect((int)x, (int)(lineY - 1), (int)width, (int)2, (int)-1);
    }
}

