/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.world;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import me.jellysquid.mods.lithium.common.entity.EntityClassGroup;
import me.jellysquid.mods.lithium.common.world.chunk.ClassGroupFilterableList;
import me.jellysquid.mods.lithium.mixin.chunk.entity_class_groups.EntityTrackingSectionAccessor;
import me.jellysquid.mods.lithium.mixin.chunk.entity_class_groups.ServerEntityManagerAccessor;
import me.jellysquid.mods.lithium.mixin.chunk.entity_class_groups.ServerWorldAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1924;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import net.minecraft.class_3509;
import net.minecraft.class_4076;
import net.minecraft.class_5572;
import net.minecraft.class_5573;

public class WorldHelper {
    public static final boolean CUSTOM_TYPE_FILTERABLE_LIST_DISABLED = !ClassGroupFilterableList.class.isAssignableFrom(class_3509.class);

    public static List<class_1297> getEntitiesForCollision(class_1924 entityView, class_238 box, class_1297 collidingEntity) {
        if (CUSTOM_TYPE_FILTERABLE_LIST_DISABLED || !(entityView instanceof class_3218) || collidingEntity != null && EntityClassGroup.MINECART_BOAT_LIKE_COLLISION.contains(collidingEntity.getClass())) {
            return entityView.method_8335(collidingEntity, box);
        }
        return WorldHelper.getEntitiesOfClassGroup((class_3218)entityView, collidingEntity, EntityClassGroup.NoDragonClassGroup.BOAT_SHULKER_LIKE_COLLISION, box);
    }

    public static List<class_1297> getEntitiesOfClassGroup(class_3218 world, class_1297 collidingEntity, EntityClassGroup.NoDragonClassGroup entityClassGroup, class_238 box) {
        world.method_16107().method_39278("getEntities");
        class_5573 cache = ((ServerEntityManagerAccessor)((ServerWorldAccessor)world).getEntityManager()).getCache();
        int minX = class_4076.method_32204((double)(box.field_1323 - 2.0));
        int minY = class_4076.method_32204((double)(box.field_1322 - 2.0));
        int minZ = class_4076.method_32204((double)(box.field_1321 - 2.0));
        int maxX = class_4076.method_32204((double)(box.field_1320 + 2.0));
        int maxY = class_4076.method_32204((double)(box.field_1325 + 2.0));
        int maxZ = class_4076.method_32204((double)(box.field_1324 + 2.0));
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                for (int y = minY; y <= maxY; ++y) {
                    Collection entitiesOfType;
                    class_3509 allEntities;
                    class_5572 section = cache.method_31785(class_4076.method_18685((int)x, (int)y, (int)z));
                    if (section == null || (allEntities = ((EntityTrackingSectionAccessor)section).getCollection()).isEmpty() || (entitiesOfType = ((ClassGroupFilterableList)allEntities).getAllOfGroupType(entityClassGroup)).isEmpty()) continue;
                    for (class_1297 entity : entitiesOfType) {
                        if (!entity.method_5829().method_994(box) || entity.method_7325() || entity == collidingEntity) continue;
                        entities.add(entity);
                    }
                }
            }
        }
        return entities;
    }

    public static boolean areNeighborsWithinSameChunk(class_2338 pos) {
        int localX = pos.method_10263() & 0xF;
        int localY = pos.method_10264() & 0xF;
        int localZ = pos.method_10260() & 0xF;
        return localX > 0 && localY > 0 && localZ > 0 && localX < 15 && localY < 15 && localZ < 15;
    }
}

