/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.lithium.common.block;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import me.jellysquid.mods.lithium.common.block.BlockStateFlags;
import net.minecraft.class_2680;

public abstract class IndexedBlockStatePredicate
implements Predicate<class_2680> {
    public static final AtomicBoolean FULLY_INITIALIZED = new AtomicBoolean(false);
    public static final IndexedBlockStatePredicate[] ALL_FLAGS;
    private static final AtomicInteger NEXT_INDEX;
    private final int index;
    private final int mask;

    public IndexedBlockStatePredicate() {
        if (FULLY_INITIALIZED.get()) {
            throw new IllegalStateException("Lithium Cached BlockState Flags: Cannot register more flags after assuming to be fully initialized.");
        }
        this.index = NEXT_INDEX.getAndIncrement();
        if (this.index > 31 || this.index >= 2) {
            throw new IndexOutOfBoundsException();
        }
        this.mask = 1 << this.index;
        IndexedBlockStatePredicate.ALL_FLAGS[this.index] = this;
        if (FULLY_INITIALIZED.get()) {
            throw new IllegalStateException("Lithium Cached BlockState Flags: Cannot register more flags after assuming to be fully initialized.");
        }
    }

    public int getIndex() {
        return this.index;
    }

    public int getMask() {
        return this.mask;
    }

    static {
        NEXT_INDEX = new AtomicInteger(0);
        ALL_FLAGS = new IndexedBlockStatePredicate[2];
        if (!BlockStateFlags.ENABLED) {
            System.out.println("Lithium Cached BlockState Flags are disabled!");
        }
    }
}

