/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

public final class InvalidIdentifierHandler {
    private static final ThreadLocal<State> STATES = ThreadLocal.withInitial(State::new);

    public static boolean areInvalidPathsEnabled() {
        return STATES.get().isEnabled();
    }

    public static void enableInvalidPaths() {
        STATES.get().enable();
    }

    public static void disableInvalidPaths() {
        STATES.get().disable();
    }

    private static class State {
        private int timesEnabled = 0;

        private State() {
        }

        public boolean isEnabled() {
            return this.timesEnabled > 0;
        }

        public void enable() {
            ++this.timesEnabled;
        }

        public void disable() {
            --this.timesEnabled;
        }
    }
}

