/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Set;
import java.util.function.Function;
import me.pepperbell.continuity.api.client.CTMLoader;
import me.pepperbell.continuity.api.client.CTMProperties;
import me.pepperbell.continuity.api.client.QuadProcessor;
import net.minecraft.class_1058;
import net.minecraft.class_4730;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CTMLoadingContainer<T extends CTMProperties>
implements Comparable<CTMLoadingContainer<?>> {
    private final CTMLoader<T> loader;
    private final T properties;
    private Set<CTMLoadingContainer<?>> multipassDependents;
    private Set<CTMLoadingContainer<?>> recursiveMultipassDependents;
    private QuadProcessor cachedProcessor;

    public CTMLoadingContainer(CTMLoader<T> loader, T properties) {
        this.loader = loader;
        this.properties = properties;
    }

    public CTMLoader<T> getLoader() {
        return this.loader;
    }

    public T getProperties() {
        return this.properties;
    }

    public void addMultipassDependent(CTMLoadingContainer<?> dependent) {
        if (this.multipassDependents == null) {
            this.multipassDependents = new ObjectOpenHashSet();
        }
        this.multipassDependents.add(dependent);
    }

    public void resolveRecursiveMultipassDependents(Set<CTMLoadingContainer<?>> traversedContainers) {
        if (this.multipassDependents != null) {
            this.recursiveMultipassDependents = new ObjectOpenHashSet();
            this.addDependentsRecursively(this, traversedContainers);
            traversedContainers.clear();
        }
    }

    protected void addDependentsRecursively(CTMLoadingContainer<?> root, Set<CTMLoadingContainer<?>> traversedContainers) {
        traversedContainers.add(this);
        if (this.multipassDependents != null) {
            for (CTMLoadingContainer<?> dependent : this.multipassDependents) {
                if (traversedContainers.contains(dependent)) continue;
                root.recursiveMultipassDependents.add(dependent);
                dependent.addDependentsRecursively(root, traversedContainers);
            }
        }
    }

    @Nullable
    public Set<CTMLoadingContainer<?>> getRecursiveMultipassDependents() {
        return this.recursiveMultipassDependents;
    }

    public QuadProcessor toProcessor(Function<class_4730, class_1058> textureGetter) {
        if (this.cachedProcessor == null) {
            this.cachedProcessor = this.loader.getProcessorFactory().createProcessor(this.properties, textureGetter);
        }
        return this.cachedProcessor;
    }

    @Override
    public int compareTo(@NotNull CTMLoadingContainer<?> o) {
        return this.properties.compareTo(o.properties);
    }
}

