/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.processor;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.api.client.QuadProcessorFactory;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.processor.BaseProcessingPredicate;
import me.pepperbell.continuity.client.processor.ConnectingQuadProcessor;
import me.pepperbell.continuity.client.processor.ConnectionPredicate;
import me.pepperbell.continuity.client.processor.ProcessingDataKeys;
import me.pepperbell.continuity.client.processor.ProcessingPredicate;
import me.pepperbell.continuity.client.processor.simple.CTMSpriteProvider;
import me.pepperbell.continuity.client.properties.BaseCTMProperties;
import me.pepperbell.continuity.client.properties.CompactConnectingCTMProperties;
import me.pepperbell.continuity.client.util.DirectionMaps;
import me.pepperbell.continuity.client.util.MathUtil;
import me.pepperbell.continuity.client.util.QuadUtil;
import me.pepperbell.continuity.client.util.TextureUtil;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_4730;
import org.apache.commons.lang3.ArrayUtils;

public class CompactCTMQuadProcessor
extends ConnectingQuadProcessor {
    protected static int[][] QUAD_INDEX_MAP;
    protected boolean innerSeams;
    protected class_1058[] replacementSprites;

    public CompactCTMQuadProcessor(class_1058[] sprites, ProcessingPredicate processingPredicate, ConnectionPredicate connectionPredicate, boolean innerSeams, class_1058[] replacementSprites) {
        super(sprites, processingPredicate, connectionPredicate);
        this.innerSeams = innerSeams;
        this.replacementSprites = replacementSprites;
    }

    @Override
    public QuadProcessor.ProcessingResult processQuadInner(MutableQuadView quad, class_1058 sprite, class_1920 blockView, class_2680 state, class_2338 pos, Supplier<Random> randomSupplier, int pass, int processorIndex, QuadProcessor.ProcessingContext context) {
        class_1058 newSprite;
        int ctmIndex;
        class_1058 replacementSprite;
        int orientation = QuadUtil.getTextureOrientation((QuadView)quad);
        class_2350[] directions = DirectionMaps.getMap(quad.lightFace())[orientation];
        class_2338.class_2339 mutablePos = context.getData(ProcessingDataKeys.MUTABLE_POS_KEY);
        int connections = CTMSpriteProvider.getConnections(this.connectionPredicate, this.innerSeams, directions, mutablePos, blockView, state, pos, quad.lightFace(), sprite);
        if (this.replacementSprites != null && (replacementSprite = this.replacementSprites[ctmIndex = CTMSpriteProvider.SPRITE_INDEX_MAP[connections]]) != null) {
            if (!TextureUtil.isMissingSprite(replacementSprite)) {
                QuadUtil.interpolate(quad, sprite, replacementSprite);
            }
            return QuadProcessor.ProcessingResult.STOP;
        }
        MeshBuilder meshBuilder = context.getData(ProcessingDataKeys.MESH_BUILDER_KEY);
        QuadEmitter quadEmitter = meshBuilder.getEmitter();
        int[] quadIndices = QUAD_INDEX_MAP[orientation];
        class_2350 cullFace = quad.cullFace();
        RenderMaterial material = quad.material();
        boolean n0 = quad.hasNormal(0);
        boolean n1 = quad.hasNormal(1);
        boolean n2 = quad.hasNormal(2);
        boolean n3 = quad.hasNormal(3);
        boolean n01 = n0 && n1;
        boolean n12 = n1 && n2;
        boolean n23 = n2 && n3;
        boolean n30 = n3 && n0;
        boolean n4 = n0 && n2;
        float x01 = MathUtil.average(quad.x(0), quad.x(1));
        float y01 = MathUtil.average(quad.y(0), quad.y(1));
        float z01 = MathUtil.average(quad.z(0), quad.z(1));
        int c01 = MathUtil.averageColor(quad.spriteColor(0, 0), quad.spriteColor(1, 0));
        int l01 = MathUtil.averageLight(quad.lightmap(0), quad.lightmap(1));
        float u01 = MathUtil.average(quad.spriteU(0, 0), quad.spriteU(1, 0));
        float v01 = MathUtil.average(quad.spriteV(0, 0), quad.spriteV(1, 0));
        float nx01 = 0.0f;
        float ny01 = 0.0f;
        float nz01 = 0.0f;
        if (n01) {
            nx01 = MathUtil.average(quad.normalX(0), quad.normalX(1));
            ny01 = MathUtil.average(quad.normalY(0), quad.normalY(1));
            nz01 = MathUtil.average(quad.normalZ(0), quad.normalZ(1));
            float scale = 1.0f / (float)Math.sqrt(nx01 * nx01 + ny01 * ny01 + nz01 * nz01);
            nx01 *= scale;
            ny01 *= scale;
            nz01 *= scale;
        }
        float x12 = MathUtil.average(quad.x(1), quad.x(2));
        float y12 = MathUtil.average(quad.y(1), quad.y(2));
        float z12 = MathUtil.average(quad.z(1), quad.z(2));
        int c12 = MathUtil.averageColor(quad.spriteColor(1, 0), quad.spriteColor(2, 0));
        int l12 = MathUtil.averageLight(quad.lightmap(1), quad.lightmap(2));
        float u12 = MathUtil.average(quad.spriteU(1, 0), quad.spriteU(2, 0));
        float v12 = MathUtil.average(quad.spriteV(1, 0), quad.spriteV(2, 0));
        float nx12 = 0.0f;
        float ny12 = 0.0f;
        float nz12 = 0.0f;
        if (n12) {
            nx12 = MathUtil.average(quad.normalX(1), quad.normalX(2));
            ny12 = MathUtil.average(quad.normalY(1), quad.normalY(2));
            nz12 = MathUtil.average(quad.normalZ(1), quad.normalZ(2));
            float scale = 1.0f / (float)Math.sqrt(nx12 * nx12 + ny12 * ny12 + nz12 * nz12);
            nx12 *= scale;
            ny12 *= scale;
            nz12 *= scale;
        }
        float x23 = MathUtil.average(quad.x(2), quad.x(3));
        float y23 = MathUtil.average(quad.y(2), quad.y(3));
        float z23 = MathUtil.average(quad.z(2), quad.z(3));
        int c23 = MathUtil.averageColor(quad.spriteColor(2, 0), quad.spriteColor(3, 0));
        int l23 = MathUtil.averageLight(quad.lightmap(2), quad.lightmap(3));
        float u23 = MathUtil.average(quad.spriteU(2, 0), quad.spriteU(3, 0));
        float v23 = MathUtil.average(quad.spriteV(2, 0), quad.spriteV(3, 0));
        float nx23 = 0.0f;
        float ny23 = 0.0f;
        float nz23 = 0.0f;
        if (n23) {
            nx23 = MathUtil.average(quad.normalX(2), quad.normalX(3));
            ny23 = MathUtil.average(quad.normalY(2), quad.normalY(3));
            nz23 = MathUtil.average(quad.normalZ(2), quad.normalZ(3));
            float scale = 1.0f / (float)Math.sqrt(nx23 * nx23 + ny23 * ny23 + nz23 * nz23);
            nx23 *= scale;
            ny23 *= scale;
            nz23 *= scale;
        }
        float x30 = MathUtil.average(quad.x(3), quad.x(0));
        float y30 = MathUtil.average(quad.y(3), quad.y(0));
        float z30 = MathUtil.average(quad.z(3), quad.z(0));
        int c30 = MathUtil.averageColor(quad.spriteColor(3, 0), quad.spriteColor(0, 0));
        int l30 = MathUtil.averageLight(quad.lightmap(3), quad.lightmap(0));
        float u30 = MathUtil.average(quad.spriteU(3, 0), quad.spriteU(0, 0));
        float v30 = MathUtil.average(quad.spriteV(3, 0), quad.spriteV(0, 0));
        float nx30 = 0.0f;
        float ny30 = 0.0f;
        float nz30 = 0.0f;
        if (n30) {
            nx30 = MathUtil.average(quad.normalX(3), quad.normalX(0));
            ny30 = MathUtil.average(quad.normalY(3), quad.normalY(0));
            nz30 = MathUtil.average(quad.normalZ(3), quad.normalZ(0));
            float scale = 1.0f / (float)Math.sqrt(nx30 * nx30 + ny30 * ny30 + nz30 * nz30);
            nx30 *= scale;
            ny30 *= scale;
            nz30 *= scale;
        }
        float x4 = MathUtil.average(quad.x(0), quad.x(2));
        float y4 = MathUtil.average(quad.y(0), quad.y(2));
        float z4 = MathUtil.average(quad.z(0), quad.z(2));
        int c4 = MathUtil.averageColor(quad.spriteColor(0, 0), quad.spriteColor(2, 0));
        int l4 = MathUtil.averageLight(quad.lightmap(0), quad.lightmap(2));
        float u4 = MathUtil.average(quad.spriteU(0, 0), quad.spriteU(2, 0));
        float v4 = MathUtil.average(quad.spriteV(0, 0), quad.spriteV(2, 0));
        float nx4 = 0.0f;
        float ny4 = 0.0f;
        float nz4 = 0.0f;
        if (n4) {
            nx4 = MathUtil.average(quad.normalX(0), quad.normalX(2));
            ny4 = MathUtil.average(quad.normalY(0), quad.normalY(2));
            nz4 = MathUtil.average(quad.normalZ(0), quad.normalZ(2));
            float scale = 1.0f / (float)Math.sqrt(nx4 * nx4 + ny4 * ny4 + nz4 * nz4);
            nx4 *= scale;
            ny4 *= scale;
            nz4 *= scale;
        }
        quad.copyTo((MutableQuadView)quadEmitter);
        quadEmitter.cullFace(cullFace);
        quadEmitter.material(material);
        quadEmitter.pos(1, x01, y01, z01);
        quadEmitter.pos(2, x4, y4, z4);
        quadEmitter.pos(3, x30, y30, z30);
        quadEmitter.spriteColor(1, 0, c01);
        quadEmitter.spriteColor(2, 0, c4);
        quadEmitter.spriteColor(3, 0, c30);
        quadEmitter.lightmap(1, l01);
        quadEmitter.lightmap(2, l4);
        quadEmitter.lightmap(3, l30);
        quadEmitter.sprite(1, 0, u01, v01);
        quadEmitter.sprite(2, 0, u4, v4);
        quadEmitter.sprite(3, 0, u30, v30);
        if (n01) {
            quadEmitter.normal(1, nx01, ny01, nz01);
        }
        if (n4) {
            quadEmitter.normal(2, nx4, ny4, nz4);
        }
        if (n30) {
            quadEmitter.normal(3, nx30, ny30, nz30);
        }
        if (!TextureUtil.isMissingSprite(newSprite = this.sprites[this.getSpriteIndex(quadIndices[0], connections)])) {
            QuadUtil.interpolate((MutableQuadView)quadEmitter, sprite, newSprite);
        }
        quadEmitter.emit();
        quad.copyTo((MutableQuadView)quadEmitter);
        quadEmitter.cullFace(cullFace);
        quadEmitter.material(material);
        quadEmitter.pos(0, x01, y01, z01);
        quadEmitter.pos(2, x12, y12, z12);
        quadEmitter.pos(3, x4, y4, z4);
        quadEmitter.spriteColor(0, 0, c01);
        quadEmitter.spriteColor(2, 0, c12);
        quadEmitter.spriteColor(3, 0, c4);
        quadEmitter.lightmap(0, l01);
        quadEmitter.lightmap(2, l12);
        quadEmitter.lightmap(3, l4);
        quadEmitter.sprite(0, 0, u01, v01);
        quadEmitter.sprite(2, 0, u12, v12);
        quadEmitter.sprite(3, 0, u4, v4);
        if (n01) {
            quadEmitter.normal(0, nx01, ny01, nz01);
        }
        if (n12) {
            quadEmitter.normal(2, nx12, ny12, nz12);
        }
        if (n4) {
            quadEmitter.normal(3, nx4, ny4, nz4);
        }
        if (!TextureUtil.isMissingSprite(newSprite = this.sprites[this.getSpriteIndex(quadIndices[1], connections)])) {
            QuadUtil.interpolate((MutableQuadView)quadEmitter, sprite, newSprite);
        }
        quadEmitter.emit();
        quad.copyTo((MutableQuadView)quadEmitter);
        quadEmitter.cullFace(cullFace);
        quadEmitter.material(material);
        quadEmitter.pos(0, x4, y4, z4);
        quadEmitter.pos(1, x12, y12, z12);
        quadEmitter.pos(3, x23, y23, z23);
        quadEmitter.spriteColor(0, 0, c4);
        quadEmitter.spriteColor(1, 0, c12);
        quadEmitter.spriteColor(3, 0, c23);
        quadEmitter.lightmap(0, l4);
        quadEmitter.lightmap(1, l12);
        quadEmitter.lightmap(3, l23);
        quadEmitter.sprite(0, 0, u4, v4);
        quadEmitter.sprite(1, 0, u12, v12);
        quadEmitter.sprite(3, 0, u23, v23);
        if (n4) {
            quadEmitter.normal(0, nx4, ny4, nz4);
        }
        if (n12) {
            quadEmitter.normal(1, nx12, ny12, nz12);
        }
        if (n23) {
            quadEmitter.normal(3, nx23, ny23, nz23);
        }
        if (!TextureUtil.isMissingSprite(newSprite = this.sprites[this.getSpriteIndex(quadIndices[2], connections)])) {
            QuadUtil.interpolate((MutableQuadView)quadEmitter, sprite, newSprite);
        }
        quadEmitter.emit();
        quad.copyTo((MutableQuadView)quadEmitter);
        quadEmitter.cullFace(cullFace);
        quadEmitter.material(material);
        quadEmitter.pos(0, x30, y30, z30);
        quadEmitter.pos(1, x4, y4, z4);
        quadEmitter.pos(2, x23, y23, z23);
        quadEmitter.spriteColor(0, 0, c30);
        quadEmitter.spriteColor(1, 0, c4);
        quadEmitter.spriteColor(2, 0, c23);
        quadEmitter.lightmap(0, l30);
        quadEmitter.lightmap(1, l4);
        quadEmitter.lightmap(2, l23);
        quadEmitter.sprite(0, 0, u30, v30);
        quadEmitter.sprite(1, 0, u4, v4);
        quadEmitter.sprite(2, 0, u23, v23);
        if (n30) {
            quadEmitter.normal(0, nx30, ny30, nz30);
        }
        if (n4) {
            quadEmitter.normal(1, nx4, ny4, nz4);
        }
        if (n23) {
            quadEmitter.normal(2, nx23, ny23, nz23);
        }
        if (!TextureUtil.isMissingSprite(newSprite = this.sprites[this.getSpriteIndex(quadIndices[3], connections)])) {
            QuadUtil.interpolate((MutableQuadView)quadEmitter, sprite, newSprite);
        }
        quadEmitter.emit();
        context.addMesh(meshBuilder.build());
        return QuadProcessor.ProcessingResult.ABORT_AND_CANCEL_QUAD;
    }

    protected int getSpriteIndex(int quadIndex, int connections) {
        boolean connected2;
        int index1 = quadIndex;
        int index2 = (quadIndex + 3) % 4;
        boolean connected1 = (connections >> index1 * 2 & 1) == 1;
        boolean bl = connected2 = (connections >> index2 * 2 & 1) == 1;
        if (connected1 && connected2) {
            if ((connections >> index2 * 2 + 1 & 1) == 1) {
                return 1;
            }
            return 4;
        }
        int swap = quadIndex % 2;
        if (connected1) {
            return 3 - swap;
        }
        if (connected2) {
            return 2 + swap;
        }
        return 0;
    }

    static {
        int[][] map = QUAD_INDEX_MAP = (int[][])new int[8][];
        map[0] = new int[]{0, 1, 2, 3};
        map[1] = (int[])map[0].clone();
        ArrayUtils.shift((int[])map[1], (int)1);
        map[2] = (int[])map[1].clone();
        ArrayUtils.shift((int[])map[2], (int)1);
        map[3] = (int[])map[2].clone();
        ArrayUtils.shift((int[])map[3], (int)1);
        map[4] = (int[])map[3].clone();
        ArrayUtils.reverse((int[])map[4]);
        map[5] = (int[])map[4].clone();
        ArrayUtils.shift((int[])map[5], (int)1);
        map[6] = (int[])map[5].clone();
        ArrayUtils.shift((int[])map[6], (int)1);
        map[7] = (int[])map[6].clone();
        ArrayUtils.shift((int[])map[7], (int)1);
    }

    public static class Factory
    implements QuadProcessorFactory<CompactConnectingCTMProperties> {
        @Override
        public QuadProcessor createProcessor(CompactConnectingCTMProperties properties, Function<class_4730, class_1058> textureGetter) {
            int i;
            int provided;
            int textureAmount = this.getTextureAmount(properties);
            List<class_4730> spriteIds = properties.getSpriteIds();
            int max = provided = spriteIds.size();
            class_1058[] replacementSprites = null;
            if (provided > textureAmount) {
                Int2IntMap replacementMap = properties.getTileReplacementMap();
                if (replacementMap != null) {
                    int replacementTextureAmount = this.getReplacementTextureAmount(properties);
                    replacementSprites = new class_1058[replacementTextureAmount];
                    for (Int2IntMap.Entry entry : replacementMap.int2IntEntrySet()) {
                        int key = entry.getIntKey();
                        if (key < replacementTextureAmount) {
                            int value = entry.getIntValue();
                            if (value < provided) {
                                replacementSprites[key] = textureGetter.apply(spriteIds.get(value));
                                continue;
                            }
                            ContinuityClient.LOGGER.warn("Cannot replace tile " + key + " with tile " + value + " as only " + provided + " tiles were provided in file '" + properties.getId() + "' in pack '" + properties.getPackName() + "'");
                            continue;
                        }
                        ContinuityClient.LOGGER.warn("Cannot replace tile " + key + " as method '" + properties.getMethod() + "' only supports " + replacementTextureAmount + " replacement tiles in file '" + properties.getId() + "' in pack '" + properties.getPackName() + "'");
                    }
                } else {
                    ContinuityClient.LOGGER.warn("Method '" + properties.getMethod() + "' requires " + textureAmount + " tiles but " + provided + " were provided in file '" + properties.getId() + "' in pack '" + properties.getPackName() + "'");
                }
                max = textureAmount;
            }
            class_1058[] sprites = new class_1058[textureAmount];
            class_1058 missingSprite = textureGetter.apply(TextureUtil.MISSING_SPRITE_ID);
            boolean supportsNullSprites = this.supportsNullSprites(properties);
            for (i = 0; i < max; ++i) {
                class_4730 spriteId = spriteIds.get(i);
                class_1058 sprite = spriteId.equals((Object)BaseCTMProperties.SPECIAL_SKIP_SPRITE_ID) ? missingSprite : (spriteId.equals((Object)BaseCTMProperties.SPECIAL_DEFAULT_SPRITE_ID) ? (supportsNullSprites ? null : missingSprite) : textureGetter.apply(spriteId));
                sprites[i] = sprite;
            }
            if (provided < textureAmount) {
                ContinuityClient.LOGGER.error("Method '" + properties.getMethod() + "' requires at least " + textureAmount + " tiles but only " + provided + " were provided in file '" + properties.getId() + "' in pack '" + properties.getPackName() + "'");
                for (i = provided; i < textureAmount; ++i) {
                    sprites[i] = missingSprite;
                }
            }
            return this.createProcessor(properties, sprites, replacementSprites);
        }

        public QuadProcessor createProcessor(CompactConnectingCTMProperties properties, class_1058[] sprites, class_1058[] replacementSprites) {
            return new CompactCTMQuadProcessor(sprites, BaseProcessingPredicate.fromProperties(properties), properties.getConnectionPredicate(), properties.getInnerSeams(), replacementSprites);
        }

        public int getTextureAmount(CompactConnectingCTMProperties properties) {
            return 5;
        }

        public int getReplacementTextureAmount(CompactConnectingCTMProperties properties) {
            return 47;
        }

        public boolean supportsNullSprites(CompactConnectingCTMProperties properties) {
            return false;
        }
    }
}

